/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse.event;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import toast.apocalypse.event.EventFullMoon;

public abstract class EventBase {
    public static final EventBase[] EVENTS = new EventBase[64];
    public static final EventBase fullMoon = new EventFullMoon(0);
    public final byte EVENT_ID;

    public EventBase(int id) {
        this.EVENT_ID = (byte)id;
        if (EVENTS[id] != null) {
            throw new IllegalArgumentException("Duplicate event id! " + id);
        }
        EventBase.EVENTS[id] = this;
    }

    public abstract String getStartMessage();

    public boolean canBeInterrupted(EventBase event) {
        return event == fullMoon;
    }

    public abstract void onStart();

    public void update() {
    }

    public void update(WorldServer world) {
    }

    public void update(EntityPlayer player) {
    }

    public void onEnd() {
    }

    public void save(DataOutputStream out) throws IOException {
    }

    public void load(DataInputStream in) throws IOException {
    }
}

