/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse.event;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import toast.apocalypse.ApocalypseMod;
import toast.apocalypse.PropHelper;
import toast.apocalypse.Properties;
import toast.apocalypse.WorldDifficultyManager;
import toast.apocalypse.entity.EntityBreecher;
import toast.apocalypse.entity.EntityDestroyer;
import toast.apocalypse.entity.EntityGhost;
import toast.apocalypse.entity.EntityGrump;
import toast.apocalypse.entity.EntitySeeker;
import toast.apocalypse.event.EventBase;
import toast.apocalypse.event.SpawnFullMoon;

public class EventFullMoon
extends EventBase {
    public static final int[] SPAWN_WEIGHTS = new int[]{Properties.getInt("full_moons", "weight_breecher"), Properties.getInt("full_moons", "weight_grump"), Properties.getInt("full_moons", "weight_seeker"), Properties.getInt("full_moons", "weight_ghost"), Properties.getInt("full_moons", "weight_destroyer")};
    private int gracePeriod;
    private int baseGracePeriod;
    public int[] mobs = new int[5];

    public static boolean canSpawn(int mobIndex) {
        return mobIndex >= 0 && ((EventFullMoon)EventBase.fullMoon).mobs[mobIndex] > 0;
    }

    public static EntityLiving newMob(WorldServer world, int mobIndex) {
        switch (mobIndex) {
            case 0: {
                return new EntityBreecher((World)world);
            }
            case 1: {
                return new EntityGrump((World)world);
            }
            case 2: {
                return new EntitySeeker((World)world);
            }
            case 3: {
                return new EntityGhost((World)world);
            }
            case 4: {
                return new EntityDestroyer((World)world);
            }
        }
        return null;
    }

    public static void decreaseCount(int mobIndex) {
        if (mobIndex >= 0) {
            int n = mobIndex;
            ((EventFullMoon)EventBase.fullMoon).mobs[n] = ((EventFullMoon)EventBase.fullMoon).mobs[n] - 1;
        }
    }

    public static int getMobIndex(EntityLiving entity) {
        if (entity instanceof EntityBreecher) {
            return 0;
        }
        if (entity instanceof EntityGrump) {
            return 1;
        }
        if (entity instanceof EntitySeeker) {
            return 2;
        }
        if (entity instanceof EntityGhost) {
            return 3;
        }
        if (entity instanceof EntityDestroyer) {
            return 4;
        }
        return -1;
    }

    public static int nextMobIndex() {
        int totalWeight = 0;
        for (int mobIndex = 0; mobIndex < SPAWN_WEIGHTS.length; ++mobIndex) {
            if (SPAWN_WEIGHTS[mobIndex] <= 0 || !EventFullMoon.canSpawn(mobIndex)) continue;
            totalWeight += SPAWN_WEIGHTS[mobIndex];
        }
        if (totalWeight > 0) {
            int choice = ApocalypseMod.random.nextInt(totalWeight);
            for (int mobIndex = 0; mobIndex < SPAWN_WEIGHTS.length; ++mobIndex) {
                if (SPAWN_WEIGHTS[mobIndex] <= 0 || !EventFullMoon.canSpawn(mobIndex) || (choice -= SPAWN_WEIGHTS[mobIndex]) >= 0) continue;
                return mobIndex;
            }
        }
        return -1;
    }

    public EventFullMoon(int id) {
        super(id);
    }

    @Override
    public String getStartMessage() {
        return "event.Apocalypse.fullMoon";
    }

    @Override
    public boolean canBeInterrupted(EventBase event) {
        return false;
    }

    @Override
    public void onStart() {
        double effectiveDifficulty;
        WorldServer[] worlds;
        this.gracePeriod = 320;
        long worldDifficulty = WorldDifficultyManager.getWorldDifficulty();
        int playerCount = 0;
        for (WorldServer world : worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            if (world == null) continue;
            playerCount += world.field_73010_i.size();
        }
        if (playerCount == 0) {
            for (int mobIndex = 0; mobIndex < this.mobs.length; ++mobIndex) {
                this.mobs[mobIndex] = 0;
            }
            return;
        }
        if (PropHelper.START_BREECHERS >= 0L && PropHelper.START_BREECHERS <= worldDifficulty) {
            effectiveDifficulty = (double)(worldDifficulty - PropHelper.START_BREECHERS) / (double)PropHelper.FULL_MOON_TIME;
            this.mobs[0] = PropHelper.MOON_BREECHERS_MIN + (int)(PropHelper.MOON_BREECHERS * effectiveDifficulty);
        } else {
            this.mobs[0] = 0;
        }
        if (PropHelper.START_GRUMPS >= 0L && PropHelper.START_GRUMPS <= worldDifficulty) {
            effectiveDifficulty = (double)(worldDifficulty - PropHelper.START_GRUMPS) / (double)PropHelper.FULL_MOON_TIME;
            this.mobs[1] = PropHelper.MOON_GRUMPS_MIN + (int)(PropHelper.MOON_GRUMPS * effectiveDifficulty);
        } else {
            this.mobs[1] = 0;
        }
        if (PropHelper.START_SEEKERS >= 0L && PropHelper.START_SEEKERS <= worldDifficulty) {
            effectiveDifficulty = (double)(worldDifficulty - PropHelper.START_SEEKERS) / (double)PropHelper.FULL_MOON_TIME;
            this.mobs[2] = PropHelper.MOON_SEEKERS_MIN + (int)(PropHelper.MOON_SEEKERS * effectiveDifficulty);
        } else {
            this.mobs[2] = 0;
        }
        if (PropHelper.START_GHOSTS >= 0L && PropHelper.START_GHOSTS <= worldDifficulty) {
            effectiveDifficulty = (double)(worldDifficulty - PropHelper.START_GHOSTS) / (double)PropHelper.FULL_MOON_TIME;
            this.mobs[3] = PropHelper.MOON_GHOSTS_MIN + (int)(PropHelper.MOON_GHOSTS * effectiveDifficulty);
        } else {
            this.mobs[3] = 0;
        }
        if (PropHelper.START_DESTROYERS >= 0L && PropHelper.START_DESTROYERS <= worldDifficulty) {
            effectiveDifficulty = (double)(worldDifficulty - PropHelper.START_DESTROYERS) / (double)PropHelper.FULL_MOON_TIME;
            this.mobs[4] = PropHelper.MOON_DESTROYERS_MIN + (int)(PropHelper.MOON_DESTROYERS * effectiveDifficulty);
        } else {
            this.mobs[4] = 0;
        }
        int totalMobs = 0;
        for (int mobIndex = 0; mobIndex < this.mobs.length; ++mobIndex) {
            int n = mobIndex;
            this.mobs[n] = this.mobs[n] * playerCount;
            totalMobs += this.mobs[mobIndex];
        }
        if (totalMobs == 0) {
            return;
        }
        this.baseGracePeriod = 5000 / totalMobs / playerCount;
    }

    @Override
    public void update() {
        if (this.gracePeriod > 0) {
            this.gracePeriod -= 5;
        }
        for (int mobIndex = 0; mobIndex < this.mobs.length; ++mobIndex) {
            if (this.mobs[mobIndex] <= 0 || SPAWN_WEIGHTS[mobIndex] <= 0) continue;
            return;
        }
        WorldDifficultyManager.endEvent();
    }

    @Override
    public void update(WorldServer world) {
        if (world.field_73011_w.field_76574_g == 0 && !WorldDifficultyManager.isFullMoon((World)world)) {
            WorldDifficultyManager.endEvent();
            return;
        }
        if (this.gracePeriod <= 0 && SpawnFullMoon.performSpawning(world) > 0) {
            this.gracePeriod = this.baseGracePeriod + world.field_73012_v.nextInt(this.baseGracePeriod >> 1);
        }
    }

    @Override
    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.gracePeriod);
        out.writeInt(this.baseGracePeriod);
        for (int mobType : this.mobs) {
            out.writeInt(mobType);
        }
    }

    @Override
    public void load(DataInputStream in) throws IOException {
        this.gracePeriod = in.readInt();
        this.baseGracePeriod = in.readInt();
        for (int mobIndex = 0; mobIndex < this.mobs.length; ++mobIndex) {
            this.mobs[mobIndex] = in.readInt();
        }
    }
}

