/*
 * Decompiled with CFR 0.152.
 */
package toast.apocalypse.event;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import toast.apocalypse.entity.IFullMoonMob;
import toast.apocalypse.event.EventFullMoon;

public class SpawnFullMoon {
    private static final int maxNumberOfCreature = 18;
    private static final HashMap<ChunkCoordIntPair, Boolean> eligibleChunksForSpawning = new HashMap();

    public SpawnFullMoon() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static boolean canMonsterSpawnAtLocation(World world, int x, int y, int z) {
        return !world.func_147439_a(x, y, z).func_149703_v();
    }

    public static int performSpawning(WorldServer world) {
        int x;
        eligibleChunksForSpawning.clear();
        for (EntityPlayer entityplayer : world.field_73010_i) {
            int chunkX = (int)Math.floor(entityplayer.field_70165_t / 16.0);
            int chunkZ = (int)Math.floor(entityplayer.field_70161_v / 16.0);
            int spawnRange = 8;
            for (x = -spawnRange; x <= spawnRange; ++x) {
                for (int z = -spawnRange; z <= spawnRange; ++z) {
                    boolean onEdge = x == -spawnRange || x == spawnRange || z == -spawnRange || z == spawnRange;
                    ChunkCoordIntPair chunkCoords = new ChunkCoordIntPair(x + chunkX, z + chunkZ);
                    if (!onEdge) {
                        eligibleChunksForSpawning.put(chunkCoords, false);
                        continue;
                    }
                    if (eligibleChunksForSpawning.containsKey(chunkCoords)) continue;
                    eligibleChunksForSpawning.put(chunkCoords, true);
                }
            }
        }
        if (world.func_72907_a(IFullMoonMob.class) <= 18 * eligibleChunksForSpawning.size() / 256) {
            ArrayList<ChunkCoordIntPair> spawnChunks = new ArrayList<ChunkCoordIntPair>(eligibleChunksForSpawning.keySet());
            Collections.shuffle(spawnChunks);
            for (ChunkCoordIntPair chunk : spawnChunks) {
                if (eligibleChunksForSpawning.get(chunk).booleanValue()) continue;
                ChunkPosition chunkPos = SpawnFullMoon.getRandomSpawningPointInChunk((World)world, chunk.field_77276_a, chunk.field_77275_b);
                x = chunkPos.field_151329_a;
                int y = chunkPos.field_151327_b;
                int z = chunkPos.field_151328_c;
                Material material = world.func_147439_a(x, y, z).func_149688_o();
                if (world.func_147439_a(x, y, z).func_149721_r() || material != Material.field_151579_a && material != Material.field_151586_h) continue;
                for (int groupAttempts = 0; groupAttempts < 3; ++groupAttempts) {
                    int blockX = x;
                    int blockY = y;
                    int blockZ = z;
                    int spawnRadius = 6;
                    int mobIndex = EventFullMoon.nextMobIndex();
                    for (int spawnAttempts = 0; spawnAttempts < 4; ++spawnAttempts) {
                        float spawnZ;
                        float spawnY;
                        float spawnX = (float)(blockX += world.field_73012_v.nextInt(spawnRadius) - world.field_73012_v.nextInt(spawnRadius)) + 0.5f;
                        if (world.func_72977_a((double)spawnX, (double)(spawnY = (float)blockY), (double)(spawnZ = (float)(blockZ += world.field_73012_v.nextInt(spawnRadius) - world.field_73012_v.nextInt(spawnRadius)) + 0.5f), 20.0) != null) continue;
                        EntityLiving monster = EventFullMoon.newMob(world, mobIndex);
                        if (monster == null) {
                            return 0;
                        }
                        monster.func_70012_b((double)spawnX, (double)spawnY, (double)spawnZ, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if (!monster.func_70601_bi()) continue;
                        world.func_72838_d((Entity)monster);
                        EventFullMoon.decreaseCount(mobIndex);
                        if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)monster, (World)world, (float)spawnX, (float)spawnY, (float)spawnZ)) {
                            monster.func_110161_a(null);
                        }
                        return 1;
                    }
                }
            }
        }
        return 0;
    }

    private static ChunkPosition getRandomSpawningPointInChunk(World world, int chunkX, int chunkZ) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int x = (chunkX << 4) + world.field_73012_v.nextInt(16);
        int z = (chunkZ << 4) + world.field_73012_v.nextInt(16);
        int y = world.field_73012_v.nextInt(chunk == null ? world.func_72940_L() : chunk.func_76625_h() + 16 - 1);
        return new ChunkPosition(x, y, z);
    }
}

