/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import java.awt.image.BufferedImage;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.ChunkPainter;
import journeymap.client.cartography.IChunkRenderer;
import journeymap.client.cartography.render.CaveRenderer;
import journeymap.client.cartography.render.EndRenderer;
import journeymap.client.cartography.render.NetherRenderer;
import journeymap.client.cartography.render.SurfaceRenderer;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.model.RegionImageCache;
import journeymap.client.model.RegionImageSet;
import journeymap.common.Journeymap;
import org.apache.logging.log4j.Level;

public class ChunkRenderController {
    private final IChunkRenderer netherRenderer = new NetherRenderer();
    private final IChunkRenderer endRenderer = new EndRenderer();
    private final SurfaceRenderer overWorldSurfaceRenderer;
    private final IChunkRenderer overWorldCaveRenderer;

    public ChunkRenderController() {
        SurfaceRenderer surfaceRenderer;
        this.overWorldSurfaceRenderer = surfaceRenderer = new SurfaceRenderer();
        this.overWorldCaveRenderer = new CaveRenderer(surfaceRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renderChunk(RegionCoord rCoord, MapType mapType, ChunkMD chunkMd) {
        if (!JourneymapClient.getInstance().isMapping().booleanValue()) {
            return false;
        }
        ChunkPainter undergroundG2D = null;
        ChunkPainter dayG2D = null;
        ChunkPainter nightG2D = null;
        boolean renderOkay = false;
        try {
            RegionImageSet regionImageSet = RegionImageCache.instance().getRegionImageSet(rCoord);
            if (mapType.isUnderground()) {
                BufferedImage image = regionImageSet.getChunkImage(chunkMd, mapType);
                if (image != null) {
                    undergroundG2D = new ChunkPainter(RegionImageHandler.initRenderingHints(image.createGraphics()));
                    switch (rCoord.dimension) {
                        case -1: {
                            renderOkay = this.netherRenderer.render(undergroundG2D, chunkMd, mapType.vSlice);
                            break;
                        }
                        case 1: {
                            renderOkay = this.endRenderer.render(undergroundG2D, chunkMd, mapType.vSlice);
                            break;
                        }
                        default: {
                            renderOkay = this.overWorldCaveRenderer.render(undergroundG2D, chunkMd, mapType.vSlice);
                        }
                    }
                    if (renderOkay) {
                        regionImageSet.setChunkImage(chunkMd, mapType, image);
                    }
                }
            } else {
                BufferedImage imageDay = regionImageSet.getChunkImage(chunkMd, MapType.day(rCoord.dimension));
                BufferedImage imageNight = regionImageSet.getChunkImage(chunkMd, MapType.night(rCoord.dimension));
                if (imageDay != null) {
                    dayG2D = new ChunkPainter(RegionImageHandler.initRenderingHints(imageDay.createGraphics()));
                }
                if (imageNight != null) {
                    nightG2D = new ChunkPainter(RegionImageHandler.initRenderingHints(imageNight.createGraphics()));
                }
                boolean bl = renderOkay = dayG2D != null && this.overWorldSurfaceRenderer.render(dayG2D, nightG2D, chunkMd);
                if (renderOkay) {
                    regionImageSet.setChunkImage(chunkMd, MapType.day(rCoord.dimension), imageDay);
                    regionImageSet.setChunkImage(chunkMd, MapType.night(rCoord.dimension), imageNight);
                }
            }
            if (renderOkay) {
                chunkMd.setRendered();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Journeymap.getLogger().log(Level.WARN, LogFormatter.toString(e));
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in ChunkRenderController: " + LogFormatter.toString(t));
        }
        finally {
            if (dayG2D != null) {
                dayG2D.finishPainting();
            }
            if (nightG2D != null) {
                nightG2D.finishPainting();
            }
            if (undergroundG2D != null) {
                undergroundG2D.finishPainting();
            }
        }
        if (!renderOkay && Journeymap.getLogger().isDebugEnabled()) {
            Journeymap.getLogger().debug("Chunk render failed: %s / %s / %s", new Object[]{rCoord, chunkMd, mapType});
        }
        return renderOkay;
    }
}

