/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import littlebreadloaf.bleach_kd.armor.IHollowMask;
import littlebreadloaf.bleach_kd.events.ExtendedPlayerProperties;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.proxies.ClientProxy;
import littlebreadloaf.bleach_kd.render.models.armor.ModelMaskIchigo;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ItemHollowIchigoHelmet
extends ItemArmor
implements IHollowMask {
    int tickTime;
    int depleteTimer;

    public ItemHollowIchigoHelmet(ItemArmor.ArmorMaterial par2, int par3, int par4) {
        super(par2, par3, par4);
        this.depleteTimer = this.tickTime = 20;
        this.func_77655_b("mask_ichigo_full");
        this.func_111206_d("bleach_kd:armours/mask_ichigo_full");
        this.func_77637_a(BleachItems.tabBleach);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1RegisterIcon) {
        this.field_77791_bV = par1RegisterIcon.func_94245_a("bleach_kd".toLowerCase() + ":armours/mask_ichigo_full");
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layer) {
        return "bleach_kd".toLowerCase() + ":textures/models/armor/hollow_ichigo_full.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        --this.depleteTimer;
        ExtendedPlayerProperties props = (ExtendedPlayerProperties)player.getExtendedProperties("BleachPlayer");
        if (props.isEnergyMoreThan(0) && !world.field_72995_K) {
            player.func_70690_d(new PotionEffect(Potion.field_76429_m.field_76415_H, this.tickTime, 1));
            player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, this.tickTime, 0));
            if (this.depleteTimer <= 0) {
                this.depleteTimer = this.tickTime;
                props.consumeSpiritEnergy(40);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        ModelBiped armorModel = ClientProxy.getArmorModel(10);
        if (itemStack != null && armorModel != null && armorSlot == 0) {
            ModelMaskIchigo ichigoMask = (ModelMaskIchigo)armorModel;
            if (entityLiving instanceof EntityPlayer) {
                ichigoMask.resetHidden();
                EntityPlayer player = (EntityPlayer)entityLiving;
                ExtendedPlayerProperties props = ExtendedPlayerProperties.get(player);
                if (props.getMaxSpirit() < 500) {
                    ichigoMask.frontOnly();
                    if (props.getMaskNBTVariant() == 1 || props.getMaskNBTVariant() == 3) {
                        ichigoMask.FACELEFT.field_78807_k = false;
                        ichigoMask.JAWLEFT.field_78807_k = false;
                        ichigoMask.FACERIGHT.field_78807_k = true;
                        ichigoMask.JAWRIGHT.field_78807_k = true;
                    } else if (props.getMaskNBTVariant() == 2 || props.getMaskNBTVariant() == 4) {
                        ichigoMask.FACELEFT.field_78807_k = true;
                        ichigoMask.JAWLEFT.field_78807_k = true;
                        ichigoMask.FACERIGHT.field_78807_k = false;
                        ichigoMask.JAWRIGHT.field_78807_k = false;
                    }
                    if (props.isEnergyLessThan(250)) {
                        ichigoMask.JAW.field_78807_k = true;
                    }
                } else if (props.getMaskNBTVariant() == 1) {
                    ichigoMask.leftOnly(true);
                } else if (props.getMaskNBTVariant() == 2) {
                    ichigoMask.leftOnly(false);
                } else if (props.getMaskNBTVariant() == 3) {
                    ichigoMask.leftOnly(true);
                    ichigoMask.FACELEFT.field_78807_k = true;
                    ichigoMask.JAW.field_78807_k = true;
                } else if (props.getMaskNBTVariant() == 4) {
                    ichigoMask.leftOnly(false);
                    ichigoMask.FACERIGHT.field_78807_k = true;
                    ichigoMask.JAW.field_78807_k = true;
                }
            } else {
                ichigoMask.resetHidden();
            }
            ichigoMask.field_78116_c.field_78806_j = false;
            ichigoMask.field_78114_d.field_78806_j = false;
            ichigoMask.field_78117_n = entityLiving.func_70093_af();
            ichigoMask.field_78093_q = entityLiving.func_70115_ae();
            ichigoMask.field_78091_s = entityLiving.func_70631_g_();
            return ichigoMask;
        }
        return null;
    }

    @Override
    public int getJumpBoost() {
        return 0;
    }

    @Override
    public int getSpeedBoost() {
        return 2;
    }

    @Override
    public int getAttackBoost() {
        return 2;
    }

    @Override
    public void specialAttackEffect(EntityLivingBase wearer, EntityLivingBase attackee) {
    }
}

