/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import littlebreadloaf.bleach_kd.ConfigHandler;
import littlebreadloaf.bleach_kd.armor.BleachItemArmor;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.events.ExtendedPlayerProperties;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.proxies.ClientProxy;
import littlebreadloaf.bleach_kd.render.models.armor.ModelCaptainJacket;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemShiniCaptain
extends BleachItemArmor {
    public String[] title = new String[]{"cloaktype", "leftarm", "rightarm", "scarf", "belt", "shoulders", "wrists", "hollow", "squad"};
    int replenishTimer = 200;
    public String cloakData = "cloakData";
    private final int[] defaultCloak = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    public String cloakIntArray = "cloakArray";

    public ItemShiniCaptain(ItemArmor.ArmorMaterial par2, int par3) {
        super(par2, par3, 1);
        this.setFaction(1);
        this.func_77637_a(BleachItems.tabBleach);
        this.func_111206_d("bleach_kd:armours/captain_jacket_item");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        for (int j = 0; j < 9; ++j) {
            int i = this.decodeCloakData(stack, j);
            if (i == 0) continue;
            int val = i;
            if (j == 8 && i == 14) {
                val = 0;
            }
            String s = StatCollector.func_74838_a((String)("captainCloak." + this.title[j] + ".name"));
            list.add(s + " : " + val);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float fx, float fy, float fz) {
        if (world.field_72995_K) {
            return false;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150325_L) {
            int blockMeta = world.func_72805_g(x, y, z);
            int scarf = player.func_70093_af() ? 4 : 3;
            this.recodeCloakData(stack, scarf, blockMeta + 1);
            return true;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150383_bp) {
            int scarf = player.func_70093_af() ? 4 : 3;
            this.recodeCloakData(stack, scarf, 0);
            return true;
        }
        if (world.func_147439_a(x, y, z) == BleachBlocks.paperLamp) {
            if (player.func_70093_af()) {
                if ((!ConfigHandler.restrictCaptainNumber || !player.field_71075_bZ.field_75098_d) && ConfigHandler.restrictCaptainNumber) return false;
                int[] data = this.getCloakData(stack);
                this.recodeCloakData(stack, 8, data[8] + 1);
                return true;
            }
            int[] data = this.getCloakData(stack);
            this.recodeCloakData(stack, 0, data[0] + 1);
            return true;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150344_f) {
            int[] data = this.getCloakData(stack);
            int shoulder = player.func_70093_af() ? 6 : 5;
            this.recodeCloakData(stack, shoulder, data[shoulder] + 1);
            return true;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150460_al) {
            int shoulder = player.func_70093_af() ? 6 : 5;
            this.recodeCloakData(stack, shoulder, 0);
            return true;
        }
        if (world.func_147439_a(x, y, z) == Blocks.field_150434_aF) {
            int[] data = this.getCloakData(stack);
            int leftarm = player.func_70093_af() ? 1 : 2;
            this.recodeCloakData(stack, leftarm, data[leftarm] + 1);
            return true;
        }
        if (world.func_147439_a(x, y, z) == BleachBlocks.reiatsuBlock) {
            int leftarm = player.func_70093_af() ? 1 : 2;
            this.recodeCloakData(stack, leftarm, 0);
            if (!player.func_82247_a(x, y, z, side, stack)) return true;
            world.func_147468_f(x, y, z);
            return true;
        }
        if (world.func_147439_a(x, y, z) != Blocks.field_150484_ah) return super.onItemUseFirst(stack, player, world, x, y, z, side, fx, fy, fz);
        boolean missingBlock = false;
        block0: for (int valX = -1; valX < 2 && !missingBlock; ++valX) {
            for (int valZ = -1; valZ < 2; ++valZ) {
                if (valX == 0 && valZ == 0 || world.func_147439_a(x + valX, y, z + valZ) == BleachBlocks.reiatsuBlock) continue;
                missingBlock = true;
                continue block0;
            }
        }
        if (missingBlock || !player.field_71071_by.func_70431_c(new ItemStack(BleachItems.maskshard, 9))) return false;
        for (int i = 0; i < 9; ++i) {
            player.field_71071_by.func_146026_a(BleachItems.maskshard);
        }
        this.recodeCloakData(stack, 7, 1);
        return true;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layer) {
        String s = "bleach_kd".toLowerCase() + ":textures/models/armor/captain_jacket/captain_jacket";
        if (layer != null && layer.equalsIgnoreCase("overlay")) {
            int squad = this.decodeCloakData(stack, 8);
            squad = squad == 14 ? 0 : squad;
            String num = Integer.toString(squad);
            return s + "_squad" + num + ".png";
        }
        s = s + "_player";
        s = s + (this.decodeCloakData(stack, 7) == 0 ? "" : "_h");
        return s + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack p_82790_1_, int p_82790_2_) {
        return 0xFFFFFF;
    }

    public int func_82814_b(ItemStack itemstack) {
        if (this.decodeCloakData(itemstack, 8) != 0) {
            return 0xFFFFFF;
        }
        return -1;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            --this.replenishTimer;
            ExtendedPlayerProperties props = (ExtendedPlayerProperties)player.getExtendedProperties("BleachPlayer");
            if (this.replenishTimer <= 0 && props.isShinigami()) {
                props.replenishSpiritEnergy(4);
                this.replenishTimer = 200;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        ModelBiped armorModel = ClientProxy.getArmorModel(11);
        if (itemStack != null && armorModel != null) {
            ModelCaptainJacket cloak = (ModelCaptainJacket)armorModel;
            cloak.SquadLogo.field_78807_k = this.decodeCloakData(itemStack, 8) == 0;
            cloak.outfitType(this.decodeCloakData(itemStack, 0));
            if (this.decodeCloakData(itemStack, 7) == 1) {
                cloak.SquadLogo.field_78807_k = true;
            }
            if (this.decodeCloakData(itemStack, 0) != 2) {
                cloak.setLeftArm(this.decodeCloakData(itemStack, 1));
                cloak.setRightArm(this.decodeCloakData(itemStack, 2));
            }
            cloak.setColourScarf(this.decodeCloakData(itemStack, 3) - 1);
            cloak.setColourBelt(this.decodeCloakData(itemStack, 4) - 1);
            cloak.ShoulderLeftWood.field_78807_k = this.decodeCloakData(itemStack, 5) != 0 ? this.decodeCloakData(itemStack, 5) == 2 : true;
            cloak.ShoulderRightWood.field_78807_k = this.decodeCloakData(itemStack, 5) != 0 ? this.decodeCloakData(itemStack, 5) == 1 : true;
            cloak.LeftSleeveWood.field_78807_k = this.decodeCloakData(itemStack, 6) != 0 ? this.decodeCloakData(itemStack, 5) == 2 : true;
            cloak.RightSleeveWood.field_78807_k = this.decodeCloakData(itemStack, 6) != 0 ? this.decodeCloakData(itemStack, 5) == 1 : true;
            armorModel.field_78116_c.field_78806_j = armorSlot == 0;
            armorModel.field_78114_d.field_78806_j = armorSlot == 0;
            armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
            armorModel.field_78112_f.field_78806_j = armorSlot == 1;
            armorModel.field_78113_g.field_78806_j = armorSlot == 1;
            armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
            armorModel.field_78117_n = entityLiving.func_70093_af();
            armorModel.field_78093_q = entityLiving.func_70115_ae();
            armorModel.field_78091_s = entityLiving.func_70631_g_();
            armorModel.field_78118_o = false;
            int n = armorModel.field_78120_m = entityLiving.func_71124_b(0) != null ? 1 : 0;
            if (entityLiving instanceof EntityPlayer && entityLiving.func_70694_bm() != null) {
                if (entityLiving.func_70694_bm().func_77975_n() == EnumAction.bow) {
                    boolean bl = armorModel.field_78118_o = ((EntityPlayer)entityLiving).func_71057_bx() > 0;
                }
                if (((EntityPlayer)entityLiving).func_71057_bx() > 0 && entityLiving.func_70694_bm().func_77975_n() == EnumAction.block) {
                    armorModel.field_78120_m = 3;
                }
            }
            return armorModel;
        }
        return null;
    }

    public int decodeCloakData(ItemStack stack, int index) {
        int[] curVals = this.getCloakData(stack);
        return curVals[index];
    }

    public void recodeCloakData(ItemStack stack, int index, int value) {
        if (index > 8) {
            return;
        }
        int[] newVals = this.getCloakData(stack);
        int maxVal = 0;
        switch (index) {
            case 0: {
                maxVal = 2;
                break;
            }
            case 1: {
                maxVal = 4;
                break;
            }
            case 2: {
                maxVal = 4;
                break;
            }
            case 3: {
                maxVal = 16;
                break;
            }
            case 4: {
                maxVal = 16;
                break;
            }
            case 5: {
                maxVal = 3;
                break;
            }
            case 6: {
                maxVal = 3;
                break;
            }
            case 7: {
                maxVal = 1;
                break;
            }
            case 8: {
                maxVal = 14;
            }
        }
        if (value > maxVal) {
            value = index == 0 || index == 8 ? 0 : maxVal;
        } else if (value < 0) {
            value = 0;
        }
        newVals[index] = value;
        this.setCloakData(stack, newVals);
    }

    public int[] getCloakData(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return this.defaultCloak;
        }
        NBTTagCompound tag1 = tag.func_74775_l(this.cloakData);
        return tag1 == null ? this.defaultCloak : (tag1.func_74764_b(this.cloakIntArray) ? tag1.func_74759_k(this.cloakIntArray) : this.defaultCloak);
    }

    public void setCloakData(ItemStack stack, int[] value) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        NBTTagCompound tag1 = tag.func_74775_l(this.cloakData);
        if (!tag.func_74764_b(this.cloakData)) {
            tag.func_74782_a(this.cloakData, (NBTBase)tag1);
        }
        tag1.func_74783_a(this.cloakIntArray, value);
    }

    public void randomizeJacket(ItemStack stack, boolean basic) {
        int squad = ConfigHandler.restrictCaptainNumber ? 0 : field_77697_d.nextInt(14);
        int leftarm = field_77697_d.nextInt(5);
        int rightarm = field_77697_d.nextInt(5);
        this.recodeCloakData(stack, 8, squad);
        this.recodeCloakData(stack, 0, field_77697_d.nextInt(2));
        this.recodeCloakData(stack, 1, leftarm);
        this.recodeCloakData(stack, 2, rightarm);
        this.recodeCloakData(stack, 4, field_77697_d.nextInt(2));
    }
}

