/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.entities;

import cpw.mods.fml.common.FMLLog;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BleachEntityList {
    private static final Logger logger = LogManager.getLogger();
    public static Map stringToClassMapping = new HashMap();
    public static Map classToStringMapping = new HashMap();
    public static Map IDtoClassMapping = new HashMap();
    private static Map classToIDMapping = new HashMap();
    private static Map stringToIDMapping = new HashMap();
    public static HashMap entityEggs = new LinkedHashMap();

    public static void addMapping(Class par1Class, String par2String, int par3Id) {
        if (stringToClassMapping.containsKey(par2String)) {
            throw new IllegalArgumentException("ID is already registered: " + par2String);
        }
        if (IDtoClassMapping.containsKey(par3Id)) {
            throw new IllegalArgumentException("ID is already registered: " + par3Id);
        }
        stringToClassMapping.put(par2String, par1Class);
        classToStringMapping.put(par1Class, par2String);
        IDtoClassMapping.put(par3Id, par1Class);
        classToIDMapping.put(par1Class, par3Id);
        stringToIDMapping.put(par2String, par3Id);
    }

    public static void addMapping(Class entity, String name, int id, int solidColour, int spotcolour) {
        BleachEntityList.addMapping(entity, name, id);
        entityEggs.put(id, new EntityEggInfo(id, solidColour, spotcolour));
    }

    public static Entity createEntityByName(String name, World world) {
        Entity entity = null;
        try {
            Class oclass = (Class)stringToClassMapping.get(name);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return entity;
    }

    public static Entity createEntityFromNBT(NBTTagCompound compound, World world) {
        Entity entity = null;
        if ("Minecart".equals(compound.func_74779_i("id"))) {
            switch (compound.func_74762_e("Type")) {
                case 0: {
                    compound.func_74778_a("id", "MinecartRideable");
                    break;
                }
                case 1: {
                    compound.func_74778_a("id", "MinecartChest");
                    break;
                }
                case 2: {
                    compound.func_74778_a("id", "MinecartFurnace");
                }
            }
            compound.func_82580_o("Type");
        }
        Class oclass = null;
        try {
            oclass = (Class)stringToClassMapping.get(compound.func_74779_i("id"));
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity != null) {
            try {
                entity.func_70020_e(compound);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"An Entity %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", (Object[])new Object[]{compound.func_74779_i("id"), oclass.getName()});
                entity = null;
            }
        } else {
            logger.warn("Skipping Entity with id " + compound.func_74779_i("id"));
        }
        return entity;
    }

    public static Entity createEntityByID(int entityid, World world) {
        Entity entity = null;
        try {
            Class oclass = BleachEntityList.getClassFromID(entityid);
            if (oclass != null) {
                entity = (Entity)oclass.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (entity == null) {
            logger.warn("Skipping Entity with id " + entityid);
        }
        return entity;
    }

    public static int getEntityID(Entity entity) {
        Class<?> oclass = entity.getClass();
        return classToIDMapping.containsKey(oclass) ? (Integer)classToIDMapping.get(oclass) : 0;
    }

    public static Class getClassFromID(int entityid) {
        return (Class)IDtoClassMapping.get(entityid);
    }

    public static String getEntityString(Entity entityName) {
        return (String)classToStringMapping.get(entityName.getClass());
    }

    public static String getStringFromID(int p_75617_0_) {
        Class oclass = BleachEntityList.getClassFromID(p_75617_0_);
        return oclass != null ? (String)classToStringMapping.get(oclass) : null;
    }

    public static void func_151514_a() {
    }

    public static Set func_151515_b() {
        return Collections.unmodifiableSet(stringToIDMapping.keySet());
    }

    public static class EntityEggInfo {
        public final int spawnedID;
        public final int primaryColour;
        public final int secondaryColour;

        public EntityEggInfo(int entityId, int solidColour, int spotColour) {
            this.spawnedID = entityId;
            this.primaryColour = solidColour;
            this.secondaryColour = spotColour;
        }
    }
}

