/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import littlebreadloaf.bleach_kd.BleachLib;
import littlebreadloaf.bleach_kd.BleachMod;
import littlebreadloaf.bleach_kd.ConfigHandler;
import littlebreadloaf.bleach_kd.api.Tools;
import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.armor.IHollowMask;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.entities.hollows.EntityHollowOre;
import littlebreadloaf.bleach_kd.events.BleachSounds;
import littlebreadloaf.bleach_kd.events.ExtendedPlayerProperties;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.items.ISpiritFood;
import littlebreadloaf.bleach_kd.items.shikai.ItemShikai;
import littlebreadloaf.bleach_kd.network.ParticleMessage;
import littlebreadloaf.bleach_kd.network.PropertiesPacket;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;

public class BleachEvents {
    public static final UUID spiritHealthModifierUUID = UUID.fromString("81a548d8-8365-4ba7-8389-881fe302bc2a");
    public static final UUID spiritSpeedModifierUUID = UUID.fromString("36c948d8-8365-4ba7-8389-881fe302bc2a");
    public static final UUID spiritDamageModifierUUID = UUID.fromString("6414cac2-8365-4ba7-8389-881fe302bc2a");
    public static final UUID maskSpeedModifierUUID = UUID.fromString("36c954d8-152f-455b-8f10-247f51afbc23");
    public static final UUID maskDamageModifierUUID = UUID.fromString("6414cac2-152f-455b-8f10-247f51afbc23");
    public static AttributeModifier spiritHealthModifier = new AttributeModifier(spiritHealthModifierUUID, "Spirit Enhanced Health", 0.0, 0);
    public static AttributeModifier spiritSpeedModifier = new AttributeModifier(spiritSpeedModifierUUID, "Spirit Enhanced Speed", 0.01, 0);
    public static AttributeModifier spiritDamageModifier = new AttributeModifier(spiritDamageModifierUUID, "Spirit Enhanced Damage", 1.0, 0);
    public static AttributeModifier maskSpeedModifier = new AttributeModifier(maskSpeedModifierUUID, "Mask Enhanced Speed", 0.01, 0);
    public static AttributeModifier maskDamageModifier = new AttributeModifier(maskDamageModifierUUID, "Mask Enhanced Damage", 1.0, 0);
    private int replenishTimer = 100;
    private int consumeTimer = 40;
    private int maskTimer = 40;
    private int seeleDamageTimer = 60;
    private int hollowPoison = 0;

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            ExtendedPlayerProperties.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onClonePlayer(PlayerEvent.Clone event) {
        NBTTagCompound compound = new NBTTagCompound();
        ExtendedPlayerProperties.get(event.original).saveNBTData(compound);
        ExtendedPlayerProperties.get(event.entityPlayer).loadNBTData(compound);
        EntityPlayer player = event.entityPlayer;
        ExtendedPlayerProperties props = ExtendedPlayerProperties.get(player);
        if (event.wasDeath) {
            props.deactivateAllPowers();
        }
        if (event.wasDeath && !ConfigHandler.disableFactionItem && props.getFaction() == -1 && !player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_146028_b(BleachItems.factionSelect)) {
            ItemStack factionSelector = new ItemStack(BleachItems.factionSelect, 1);
            player.field_71071_by.func_70441_a(factionSelector);
        }
        if (!(!event.wasDeath || ConfigHandler.removeTempGarganta || player.field_71075_bZ.field_75098_d || player.field_70170_p.func_82736_K().func_82766_b("keepInventory") || player.field_71093_bK != ConfigHandler.worldHuecoMundoID || player.field_71071_by.func_146028_b(BleachItems.tempGargantaItem))) {
            ItemStack tempGarganta = new ItemStack(BleachItems.tempGargantaItem, 1);
            player.field_71071_by.func_70441_a(tempGarganta);
        }
        if (event.wasDeath && ConfigHandler.humanEvo && props.isHumanFac()) {
            ItemStack chest = player.func_71124_b(3);
            if (chest != null && chest.func_77973_b() == BleachArmor.SoulChain) {
                props.setAsWhole(1, 0);
            }
            if (props.getReiryoku(0) > 100) {
                props.setAsWhole(1, 1);
            }
        }
    }

    @SubscribeEvent
    public void onAchievementTrigger(AchievementEvent event) {
        EntityPlayerMP player;
        ExtendedPlayerProperties props;
        if (event.achievement.equals((Object)AchievementList.field_76004_f) && !ConfigHandler.disableFactionItem && (props = ExtendedPlayerProperties.get((EntityPlayer)(player = (EntityPlayerMP)event.entityPlayer))).getFaction() == -1 && !player.field_71071_by.func_146028_b(BleachItems.factionSelect) && !player.field_71075_bZ.field_75098_d) {
            ItemStack factionSelector = new ItemStack(BleachItems.factionSelect, 1);
            player.field_71071_by.func_70441_a(factionSelector);
        }
    }

    @SubscribeEvent
    public void onEntityKilled(LivingDeathEvent event) {
        if (ConfigHandler.allowExpFromEntities && event.entityLiving != null && event.source.func_76364_f() != null && event.source.func_76364_f() instanceof EntityPlayer) {
            int reircheck;
            Random rand1;
            int index;
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            ExtendedPlayerProperties props = ExtendedPlayerProperties.get(player);
            if (props.getBleachStat(index = (rand1 = new Random()).nextInt(3)) < 50) {
                props.addStatExp(index, 5);
            }
            int n = reircheck = props.isHollow() ? 100 : 200;
            if (props.getReiryoku(0) < reircheck) {
                props.addSXP(1);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityTracker et;
        if (event.entityLiving instanceof EntityPlayer && event.entityLiving != null && !event.entityLiving.field_70170_p.field_72995_K && (et = ((WorldServer)event.entityLiving.field_70170_p).func_73039_n()) != null) {
            et.func_151248_b((Entity)event.entityLiving, BleachMod.network.getPacketFrom((IMessage)new PropertiesPacket(event.entityLiving.func_145782_y(), event.entityLiving.field_70170_p)));
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        ExtendedPlayerProperties props;
        if (event.entityLiving instanceof EntityPlayer) {
            ItemStack helm;
            float newStepHeight;
            EntityPlayer thePlayer = (EntityPlayer)event.entityLiving;
            props = ExtendedPlayerProperties.get(thePlayer);
            float f = newStepHeight = props.getSpeed() >= 0.036 ? 1.0f : 0.5f;
            float hollowBonus = props.getFactionId() == 3 || props.getFactionId() == 10 ? 0.5f : (props.getFactionId() == 9 ? 3.0f : 0.0f);
            thePlayer.field_70138_W = newStepHeight + hollowBonus;
            if (thePlayer.func_82169_q(3) != null && (helm = thePlayer.func_82169_q(3)).func_77973_b() instanceof IHollowMask && !thePlayer.field_70170_p.field_72995_K && !thePlayer.field_71075_bZ.field_75098_d && props.isEnergyLessThan(100)) {
                BleachLib.unequipItem(thePlayer, 3, helm);
            }
            if (thePlayer.func_82169_q(2) == null && !thePlayer.field_70170_p.field_72995_K && !thePlayer.field_71075_bZ.field_75098_d && props.getActivePower(3) == 1) {
                props.deactivateQuincy();
            }
            if (thePlayer.func_82169_q(2) != null) {
                ItemStack chest = thePlayer.func_82169_q(2);
                if (!thePlayer.field_70170_p.field_72995_K && !thePlayer.field_71075_bZ.field_75098_d) {
                    if (chest.func_77973_b() == BleachArmor.QuincyLeztzStil) {
                        if (props.getActivePower(3) != 1) {
                            BleachLib.unequipItem(thePlayer, 2, chest);
                        }
                    } else if (props.getActivePower(3) == 1) {
                        props.deactivateQuincy();
                    }
                }
            }
        }
        if (!event.entity.field_70170_p.field_72995_K) {
            EntityPlayer player;
            if (BleachLib.isEntityInCube(event.entity)) {
                --this.seeleDamageTimer;
                event.entity.field_70159_w *= (double)0.01f;
                event.entity.field_70179_y *= (double)0.01f;
                if (event.entity.field_70181_x > 0.0) {
                    event.entity.field_70181_x *= (double)0.01f;
                }
                if (event.entityLiving.func_70668_bt() == Tools.SPIRIT && this.seeleDamageTimer <= 0) {
                    event.entityLiving.func_70097_a(DamageSource.field_76376_m, 2.0f);
                }
                if (event.entityLiving instanceof EntityPlayer) {
                    player = (EntityPlayer)event.entityLiving;
                    props = ExtendedPlayerProperties.get(player);
                    if (this.seeleDamageTimer <= 0 && !props.isHumanFac() && props.isQuincy()) {
                        float hollowDam = props.isHollow() ? 1.5f : (props.isArrancar() ? 2.5f : (props.isVisored() ? 0.5f : 0.0f));
                        event.entityLiving.func_70097_a(DamageSource.field_76376_m, 1.0f + hollowDam);
                    }
                }
            }
            if (event.entityLiving != null) {
                ItemStack helm = event.entityLiving.func_71124_b(4);
                if (event.entityLiving instanceof EntityPlayer) {
                    EntityPlayer player2 = (EntityPlayer)event.entityLiving;
                    helm = player2.func_82169_q(3);
                }
                IAttributeInstance movement = event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111263_d);
                IAttributeInstance damage = event.entityLiving.func_110148_a(SharedMonsterAttributes.field_111264_e);
                if (helm != null && helm.func_77973_b() instanceof IHollowMask) {
                    IHollowMask mask = (IHollowMask)helm.func_77973_b();
                    if (movement != null) {
                        int boost = mask.getSpeedBoost();
                        if (movement.func_111127_a(maskSpeedModifierUUID) != null) {
                            movement.func_111124_b(maskSpeedModifier);
                        }
                        if (boost != 0) {
                            maskSpeedModifier = new AttributeModifier(maskSpeedModifierUUID, "Mask Enhanced Speed", 0.1 * (double)boost, 1);
                            movement.func_111121_a(maskSpeedModifier);
                        }
                    }
                    if (damage != null) {
                        int boost = mask.getAttackBoost();
                        if (damage.func_111127_a(maskDamageModifierUUID) != null) {
                            damage.func_111124_b(maskDamageModifier);
                        }
                        if (boost != 0) {
                            maskDamageModifier = new AttributeModifier(maskDamageModifierUUID, "Mask Enhanced Damage", 2.0 * (double)boost, 1);
                            damage.func_111121_a(maskDamageModifier);
                        }
                    }
                } else {
                    if (movement != null && movement.func_111127_a(maskSpeedModifierUUID) != null) {
                        movement.func_111124_b(maskSpeedModifier);
                    }
                    if (damage != null && damage.func_111127_a(maskDamageModifierUUID) != null) {
                        damage.func_111124_b(maskDamageModifier);
                    }
                }
            }
            if (event.entityLiving instanceof EntityPlayer) {
                player = (EntityPlayer)event.entityLiving;
                props = ExtendedPlayerProperties.get(player);
                --this.replenishTimer;
                --this.consumeTimer;
                --this.maskTimer;
                if (this.consumeTimer <= 0) {
                    props.trackActivePowers();
                    this.consumeTimer = 40;
                }
                if (this.maskTimer <= 0) {
                    if (props.getActivePower(2) == 0) {
                        if (props.getMaskTime() < props.getMaskTimerMax()) {
                            props.recoverMaskEnergy(0);
                            this.maskTimer = 40;
                        }
                    } else if (props.getActivePower(2) == 1) {
                        props.decreaseMaskTimer(0);
                        this.maskTimer = 20;
                    }
                }
                IAttributeInstance health = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
                IAttributeInstance movement = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
                IAttributeInstance damage = player.func_110148_a(SharedMonsterAttributes.field_111264_e);
                if (health != null) {
                    if (health.func_111127_a(spiritHealthModifierUUID) != null) {
                        health.func_111124_b(spiritHealthModifier);
                    }
                    spiritHealthModifier = new AttributeModifier(spiritHealthModifierUUID, "Spirit Enhanced Health", (double)props.getBonusHealth(), 0);
                    health.func_111121_a(spiritHealthModifier);
                }
                if (movement != null) {
                    if (movement.func_111127_a(spiritSpeedModifierUUID) != null) {
                        movement.func_111124_b(spiritSpeedModifier);
                    }
                    double timesFaster = props.getSpeed();
                    double hollowBoost = player.func_70051_ag() && props.isHollow() ? (double)props.getHollowBoost(0) : 0.0;
                    spiritSpeedModifier = new AttributeModifier(spiritSpeedModifierUUID, "Spirit Enhanced Speed", timesFaster + hollowBoost, 0);
                    movement.func_111121_a(spiritSpeedModifier);
                }
                if (damage != null) {
                    if (damage.func_111127_a(spiritDamageModifierUUID) != null) {
                        damage.func_111124_b(spiritDamageModifier);
                    }
                    double damageBoost = props.getBaseDamage();
                    double hollowDam = props.isHollow() ? (double)props.getHollowBoost(1) : 0.0;
                    spiritDamageModifier = new AttributeModifier(spiritDamageModifierUUID, "Spirit Enhanced Damage", damageBoost + hollowDam, 0);
                    damage.func_111121_a(spiritDamageModifier);
                }
                if (this.replenishTimer <= 0) {
                    boolean soul;
                    boolean hueco = player.field_71093_bK == ConfigHandler.worldHuecoMundoID;
                    boolean bl = soul = player.field_71093_bK == ConfigHandler.worldSoulSocietyID;
                    int dim = hueco ? 0 : (soul ? 1 : (player.field_71093_bK == -1 ? 2 : (player.field_71093_bK == 0 ? 3 : (player.field_71093_bK == 1 ? 4 : 5))));
                    float dimensionBoost = (float)ConfigHandler.regenWorlds[dim] / 2.0f;
                    int regenRate = props.getSpiritRecoverySpeed();
                    int regenAmount = props.getSpiritRecoveryAmount();
                    float reishiManip = (float)props.getBleachStat(8) / (float)ConfigHandler.statMax[8];
                    int dimManip = (int)(dimensionBoost * reishiManip);
                    props.replenishSpiritEnergy(dimManip + regenAmount);
                    this.replenishTimer = regenRate;
                    if (props.isHollow()) {
                        // empty if block
                    }
                    if (props.isQuincy() && props.getReiryoku(3) > 30 && props.getUnlockedPower(3) == 0) {
                        if (this.hollowPoison > 300) {
                            player.func_70097_a(DamageSource.field_76376_m, 1.0f);
                            this.hollowPoison = 0;
                        }
                        ++this.hollowPoison;
                    }
                    boolean reiatsuFlag = false;
                    Block blockCheck = player.field_70170_p.func_147439_a((int)player.field_70165_t, (int)player.field_70163_u - 1, (int)player.field_70161_v);
                    if (blockCheck != null && blockCheck == BleachBlocks.reiatsuBlock) {
                        reiatsuFlag = true;
                    }
                    if (player.field_71093_bK == ConfigHandler.worldHuecoMundoID || player.field_71093_bK == ConfigHandler.worldSoulSocietyID) {
                        props.replenishSpiritEnergy((int)(3.5 * (1.0 + 0.001 * (double)props.getMaxSpirit())));
                    } else if (!reiatsuFlag && props.isEnergyMoreThan(50) && !ConfigHandler.hollowSpiritDecay) {
                        props.consumeSpiritEnergy((int)(1.0 + 0.001 * (double)props.getMaxSpirit()));
                    }
                    if (reiatsuFlag || props.isEnergyLessThan(50)) {
                        props.replenishSpiritEnergy((int)(1.5 * (1.0 + 0.001 * (double)props.getMaxSpirit())));
                    }
                }
                if (props.isHollow() && props.getHead() == 2 && player.func_70051_ag() && props.getAttackMode() == 1) {
                    Vec3 normalizer = Vec3.func_72443_a((double)0.008, (double)0.008, (double)0.008).func_72432_b();
                    List list = player.field_70170_p.func_72839_b((Entity)player, player.field_70121_D.func_72329_c().func_72314_b(Math.abs(normalizer.field_72450_a * 0.5), Math.abs(normalizer.field_72448_b * 0.5), Math.abs(normalizer.field_72449_c * 0.5)));
                    for (int l = 0; l < list.size(); ++l) {
                        Entity entity1 = (Entity)list.get(l);
                        if (!(entity1 instanceof EntityLivingBase)) continue;
                        double moveX = entity1.field_70165_t - player.field_70165_t;
                        double moveY = entity1.field_70163_u - player.field_70163_u;
                        double moveZ = entity1.field_70161_v - player.field_70161_v;
                        double angle = Math.atan2(moveZ, moveX);
                        moveX = 0.8 * Math.cos(angle);
                        moveZ = 0.8 * Math.sin(angle);
                        moveY = 0.5;
                        entity1.func_70024_g(moveX, moveY, moveZ);
                        ((EntityLivingBase)entity1).func_70097_a(DamageSource.field_76377_j, 1.0f);
                    }
                }
                if (props.isHollow() && props.getHead() == 5 && player.func_70089_S() && player.func_70055_a(Material.field_151586_h)) {
                    player.func_70050_g(300);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingJumpEvent(LivingEvent.LivingJumpEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            float multiply;
            int jumpBoost;
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            ExtendedPlayerProperties props = ExtendedPlayerProperties.get(player);
            int n = jumpBoost = props.getMaxSpirit() < ConfigHandler.spiritJumpBoost ? props.getMaxSpirit() : ConfigHandler.spiritJumpBoost;
            float f = player.func_70051_ag() ? 0.001f : (multiply = player.func_70093_af() ? 0.0f : 5.0E-4f);
            if (player.field_70122_E) {
                event.entityLiving.field_70181_x += (double)((float)jumpBoost * multiply + props.getHollowBoost(2));
                ItemStack helmet = player.func_71124_b(3);
                if (helmet != null && helmet.func_77973_b() instanceof IHollowMask) {
                    IHollowMask mask = (IHollowMask)helmet.func_77973_b();
                    event.entityLiving.field_70181_x += (double)((float)mask.getJumpBoost() * 0.1f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            ExtendedPlayerProperties props = (ExtendedPlayerProperties)player.getExtendedProperties("BleachPlayer");
            event.distance = (float)((double)event.distance - (double)props.getMaxSpirit() * (0.02 * (double)props.getSpiritEnergy()));
            if (event.entityLiving.field_71093_bK == ConfigHandler.worldHuecoMundoID && event.distance < 20.0f) {
                event.setCanceled(true);
            }
            if (props.isHollow() && props.getBack() == 3) {
                event.setCanceled(true);
            }
            if (props.isHollow() && props.getLegs() == 3 && player.field_70123_F) {
                event.setCanceled(true);
            }
            if (player.func_82169_q(3) != null && player.func_82169_q(3).func_77973_b() == BleachArmor.LizardHelmet) {
                event.setCanceled(true);
            }
            if (ConfigHandler.negateFallDamage && (props.fullOutfit(0) || props.fullArrancar() || props.fullQuincy() || props.fullShinigami())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (event.item.func_92059_d().func_77973_b().equals(BleachItems.heart) && event.entityPlayer != null) {
            event.entityPlayer.func_70691_i(8.0f);
            for (int i = 0; i < 5; ++i) {
                BleachMod.network.sendToAll((IMessage)new ParticleMessage(4, (int)event.entityPlayer.field_70165_t, (int)event.entityPlayer.field_70163_u, (int)event.entityPlayer.field_70161_v));
            }
            event.item.func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        ExtendedPlayerProperties props;
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer) {
            player = (EntityPlayer)event.entityLiving;
            props = ExtendedPlayerProperties.get(player);
            if (event.source.equals(DamageSource.field_76379_h)) {
                float currentEnergy = props.getSpiritEnergy();
                int capMax = props.getMaxSpirit() < 750 ? props.getMaxSpirit() : 750;
                float multiply = (float)capMax * 0.01f;
                float fallLimit = 6.0f + multiply;
                if (event.ammount - fallLimit < 5.0f && props.isEnergyMoreThan((int)event.ammount * 2)) {
                    props.consumeSpiritEnergy((int)event.ammount * 2);
                    event.setCanceled(true);
                }
            }
        }
        if (event.entityLiving != null) {
            if (event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityPlayer) {
                player = (EntityPlayer)event.source.func_76346_g();
                props = ExtendedPlayerProperties.get(player);
                if (event.entityLiving.func_70668_bt() == Tools.SPIRIT && props.getReiryoku(0) < 30 && props.isHumanFac()) {
                    event.setCanceled(true);
                }
                if (props.isHollow() && props.isTailUsable() && props.getTail() == 3 && player.func_70093_af() && props.isEnergyMoreThan(20) && !event.entityLiving.field_70170_p.field_72995_K) {
                    props.consumeSpiritEnergy(20);
                    event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76436_u.func_76396_c(), 80, 0));
                    return;
                }
            }
            if (event.source.func_76346_g() != null && event.source.func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase entLiving = (EntityLivingBase)event.source.func_76346_g();
                ItemStack helm = entLiving.func_71124_b(4);
                if (entLiving instanceof EntityPlayer) {
                    EntityPlayer entPlayer = (EntityPlayer)entLiving;
                    helm = entPlayer.func_82169_q(3);
                }
                if (helm != null && helm.func_77973_b() instanceof IHollowMask) {
                    IHollowMask mask = (IHollowMask)helm.func_77973_b();
                    mask.specialAttackEffect(entLiving, event.entityLiving);
                }
            }
        }
        if (event.entityLiving instanceof EntityHollowOre && event.source.equals(DamageSource.field_76368_d)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.entity != null && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            ExtendedPlayerProperties props = ExtendedPlayerProperties.get(player);
            ItemStack heldItem = player.func_70694_bm();
            if (heldItem != null && heldItem.func_77973_b() == BleachItems.shikailightning) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        EntityPlayer player;
        Entity entity = event.source.func_76346_g();
        if (entity != null && entity instanceof EntityPlayer) {
            player = (EntityPlayer)entity;
            ItemStack heldItem = player.func_71045_bC();
            ExtendedPlayerProperties props = ExtendedPlayerProperties.get(player);
            if (props.isHollow()) {
                float hollowDamage = 0.0f;
                if (heldItem != null) {
                    hollowDamage += heldItem.func_77973_b() instanceof ItemSword ? 2.0f : 5.0f;
                } else {
                    int spiritUse = props.getAttackMode() == 0 ? 0 : 3;
                    props.consumeSpiritEnergy(spiritUse);
                    hollowDamage += props.getAttackMode() == 0 ? 8.0f : 10.0f;
                    if (props.getArms() == 1 || props.getArms() == 2) {
                        hollowDamage += 4.0f;
                    }
                }
                event.ammount += hollowDamage;
            }
            float extraDamg = (float)(props.getMaxSpirit() > ConfigHandler.spiritDamageBoost ? ConfigHandler.spiritDamageBoost : props.getMaxSpirit()) * 0.01f;
            extraDamg = props.isHollow() ? extraDamg * 0.5f : extraDamg;
            event.ammount += extraDamg;
        }
        if (event.entityLiving instanceof EntityPlayer) {
            boolean configOverride;
            player = (EntityPlayer)event.entityLiving;
            ExtendedPlayerProperties props = ExtendedPlayerProperties.get(player);
            ItemStack heldItem = player.func_71045_bC();
            ItemStack var9 = player.func_71124_b(1);
            ItemStack var10 = player.func_71124_b(2);
            ItemStack var11 = player.func_71124_b(3);
            if (heldItem != null && heldItem.func_77973_b() == BleachItems.shikaipoison && event.source.func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase var5 = (EntityLivingBase)event.source.func_76346_g();
                var5.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 80, 0));
            }
            boolean bl = configOverride = ConfigHandler.spiritFlashandArmour == 1 || ConfigHandler.spiritFlashandArmour == 3;
            if (var9 != null && var10 != null && var11 != null || props.isHollow() || configOverride) {
                boolean arrancar;
                boolean shoes = var9 != null && (var9.func_77973_b() == BleachArmor.Sandals || var9.func_77973_b() == BleachArmor.QuincyShoes || var9.func_77973_b() == BleachArmor.ArrancarShoes || var9.func_77973_b() == BleachArmor.SandalsH);
                boolean shinigami = !(var10 == null || var11 == null || var10.func_77973_b() != BleachArmor.ShiniPants && var10.func_77973_b() != BleachArmor.ShiniHPants || var11.func_77973_b() != BleachArmor.ShiniRobe && var11.func_77973_b() != BleachArmor.ShiniHRobe && var11.func_77973_b() != BleachArmor.ShiniCaptain);
                boolean quincy = var10 != null && var11 != null && var10.func_77973_b() == BleachArmor.QuincyPants && var11.func_77973_b() == BleachArmor.QuincyRobe;
                boolean bl2 = arrancar = var10 != null && var11 != null && var10.func_77973_b() == BleachArmor.ArrancarPants && var11.func_77973_b() == BleachArmor.ArrancarJacket;
                if (props.fullOutfit(0) || props.isHollow() || configOverride) {
                    boolean sword;
                    float currentEnergy = props.getSpiritEnergy();
                    float amountToConsume = 0.0f;
                    boolean fallFlag = event.source.equals(DamageSource.field_76379_h);
                    boolean bl3 = sword = heldItem != null && heldItem.func_77973_b() instanceof ItemShikai;
                    float f = sword ? (player.func_70632_aY() ? event.ammount * 0.5f : event.ammount) : (amountToConsume = event.ammount * 1.5f);
                    if (!fallFlag) {
                        int upperDamLimit = ConfigHandler.upperDamLimit;
                        boolean flagDam = false;
                        if (upperDamLimit != -1) {
                            int maxBase = props.totalBaseReiryoku();
                            if (amountToConsume >= (float)(upperDamLimit = (int)((float)upperDamLimit + (float)maxBase / 10.0f))) {
                                int remainder = props.consumeAndUseSpirit(upperDamLimit);
                                amountToConsume -= (float)(upperDamLimit - remainder);
                                flagDam = true;
                            } else {
                                int remainder = props.consumeAndUseSpirit((int)amountToConsume);
                                if (remainder > 0) {
                                    flagDam = true;
                                    amountToConsume = remainder;
                                } else {
                                    event.setCanceled(true);
                                }
                            }
                        } else {
                            int remainder = props.consumeAndUseSpirit((int)amountToConsume);
                            if (remainder > 0) {
                                flagDam = true;
                                amountToConsume = remainder;
                            } else {
                                event.setCanceled(true);
                            }
                        }
                        if (flagDam) {
                            float f2 = amountToConsume > 0.0f ? (amountToConsume / 3.5f > 0.0f ? amountToConsume / 3.5f : 0.0f) : (event.ammount = 0.0f);
                        }
                    }
                }
            }
            if (props.isHollow() && event.source.func_76346_g() instanceof EntityLivingBase) {
                EntityLivingBase hurter = (EntityLivingBase)event.source.func_76346_g();
                if (props.getBack() == 2) {
                    hurter.func_70097_a(DamageSource.field_76377_j, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        int hollowOreID;
        boolean flagGol;
        ExtendedPlayerProperties props = ExtendedPlayerProperties.get(event.entityPlayer);
        Vec3 look = event.entityPlayer.func_70676_i(1.0f);
        boolean flagDia = event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == BleachBlocks.hollowdiamond;
        boolean flagEme = event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == BleachBlocks.hollowemerald;
        boolean bl = flagGol = event.entityPlayer.field_70170_p.func_147439_a(event.x, event.y, event.z) == BleachBlocks.hollowgold;
        int n = flagDia ? 0 : (flagEme ? 2 : (hollowOreID = flagGol ? 1 : -1));
        if ((flagDia || flagEme || flagGol) && hollowOreID != -1 && event.action.equals((Object)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK)) {
            EntityHollowOre var18 = new EntityHollowOre(event.entityPlayer.field_70170_p, hollowOreID);
            int var10 = event.x;
            int var11 = event.y;
            int var12 = event.z;
            var18.func_70012_b(var10, var11, var12, 0.0f, 0.0f);
            event.entityPlayer.field_70170_p.func_72876_a(null, (double)event.x, (double)event.y, (double)event.z, 1.0f, true);
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    for (int k = -2; k <= 2; ++k) {
                        if (event.entityPlayer.field_70170_p.func_147439_a(event.x + i, event.y + k, event.z + j) == Blocks.field_150357_h) continue;
                        event.entityPlayer.field_70170_p.func_147468_f(event.x + i, event.y + k, event.z + j);
                    }
                }
            }
            event.entityPlayer.field_70170_p.func_72838_d((Entity)var18);
            event.entityPlayer.field_70170_p.func_72956_a((Entity)var18, BleachSounds.ore_hollow.toString(), 1.4f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerEat(PlayerUseItemEvent.Start event) {
        ExtendedPlayerProperties props;
        if (event.item != null && (props = ExtendedPlayerProperties.get(event.entityPlayer)).isHollow() && event.item.func_77973_b() instanceof ItemFood && !BleachLib.acceptedHollowFood(event.item)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerEat(PlayerUseItemEvent.Finish event) {
        ExtendedPlayerProperties props;
        if (event.item != null && (props = ExtendedPlayerProperties.get(event.entityPlayer)).isHollow() && BleachLib.acceptedHollowFood(event.item) && event.item.func_77973_b() instanceof ISpiritFood) {
            ISpiritFood foodItem = (ISpiritFood)event.item.func_77973_b();
            props.replenishSpiritEnergy(5);
            event.entityPlayer.func_71024_bL().func_75122_a(foodItem.getFood(), (float)foodItem.getSaturation());
        }
    }
}

