/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.events;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import littlebreadloaf.bleach_kd.BleachLib;
import littlebreadloaf.bleach_kd.BleachMod;
import littlebreadloaf.bleach_kd.ConfigHandler;
import littlebreadloaf.bleach_kd.Names;
import littlebreadloaf.bleach_kd.armor.BleachArmor;
import littlebreadloaf.bleach_kd.armor.ISpiritArmour;
import littlebreadloaf.bleach_kd.armor.ItemQuincyLeztzStil;
import littlebreadloaf.bleach_kd.armor.ItemSoulChain;
import littlebreadloaf.bleach_kd.events.BleachSounds;
import littlebreadloaf.bleach_kd.items.BleachItems;
import littlebreadloaf.bleach_kd.items.ItemReiatsu;
import littlebreadloaf.bleach_kd.items.shikai.ItemShikai;
import littlebreadloaf.bleach_kd.network.MoveMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedPlayerProperties
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "BleachPlayer";
    private int debugEXPmultiply = 1;
    private final EntityPlayer player;
    private Random rand = new Random();
    private float[] SoulXP = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private float SpiritEnergy = 1.0f;
    private int faction = -1;
    private int[] elementPoints = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private String ZName = "";
    private int[] Zanpakuto = new int[]{-1, -1, -1};
    private int HollowKillCount = 0;
    private int HollowDeathType = 0;
    private int attackMode = 0;
    private int[] hollowType = new int[]{0, 0, 0, 0, 0, 0};
    private int MaskNBTVariant = 0;
    private int[] bleachStats = new int[]{5, 5, 5, 0, 0, 0, 0, 1, 1};
    private int[] bleachExp = new int[]{0, 0, 0, -1, 0, 0, 0, 0, 0};
    private int[] factionRep = new int[]{0, 0, 0, 0, 0, 0, 0};
    private int[] abilities = new int[]{0, 0, 0, 0, 0};
    private int[] spellLevels = new int[]{0, 0, 0, 0};
    private int[] trackedData = new int[]{0, 0, 0};
    private int[] activePower = new int[]{0, 0, 0, 0, 0};
    private int[] activePowerXP = new int[]{0, 0, 0, 0, 0};
    private int[] reiryokuCreative = new int[]{0, 0, 0, 0};
    private int upgradeCount = 0;
    private int maskTimerMax = 0;
    private int maskTimer = 0;
    private int[] battleInfo = new int[]{0, 0, 0};
    private int[] reiryoku = new int[]{5, 0, 0, 0};
    private int[] UnlockedPower = new int[]{0, 0, 0, 0, 0, 0, 0};
    private int[] hollowParts = new int[]{0, 0, 0, 0, 0, 0};
    private int HTex = 0;
    private float HColorR = 1.0f;
    private float HColorB = 1.0f;
    private float HColorG = 1.0f;
    private int MColor = this.rand.nextInt(16);
    private int maxSpirit = 0;
    ItemStack[] Shikai = new ItemStack[]{new ItemStack(BleachItems.shikaifire, 1), new ItemStack(BleachItems.shikaiice, 1), new ItemStack(BleachItems.shikaipoison, 1), new ItemStack(BleachItems.shikaiheal, 1), new ItemStack(BleachItems.shikaiearth, 1), new ItemStack(BleachItems.shikaiwind, 1), new ItemStack(BleachItems.shikailight, 1), new ItemStack(BleachItems.shikaidark, 1), new ItemStack(BleachItems.shikailunar, 1), new ItemStack(BleachItems.shikailightning, 1), new ItemStack(BleachItems.shikaiwater, 1), new ItemStack(BleachItems.shikainormal, 1)};
    public static int headCount = 5;
    public static int backCount = 5;
    public static int armsCount = 6;
    public static int legsCount = 5;
    public static int tailCount = 4;
    public static int texCount = 2;
    public static String[] getFaction = new String[]{"human", "whole", "shinigami", "hollow", "quincy", "bount", "sinner", "fullbring", "visored", "menos", "adjuchas", "vastolorde", "arrancar", "ascended"};
    public static String[] getReiryokuName = new String[]{"base", "shinigami", "quincy", "hollow"};
    public static String[] getStatName = new String[]{"strength", "agility", "endurance", "discipline", "weapon", "ranged", "magic", "reiatsucontrol", "reishimanipulation"};

    public ExtendedPlayerProperties(EntityPlayer player) {
        this.player = player;
        this.MaskNBTVariant = 0;
        boolean randomize = false;
        boolean randMaskSkin = false;
        if (ConfigHandler.removeHollowEvolution && ConfigHandler.defaultHollow) {
            randomize = false;
        } else if (ConfigHandler.removeHollowEvolution) {
            randomize = true;
        }
        if (ConfigHandler.defaultHollow) {
            randomize = false;
        } else if (!ConfigHandler.removeHollowEvolution) {
            randomize = false;
            randMaskSkin = true;
        }
        if (randomize) {
            this.randomizeHollow();
        }
        if (randMaskSkin) {
            this.randMaskSkin();
        }
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new ExtendedPlayerProperties(player));
    }

    public static final ExtendedPlayerProperties get(EntityPlayer player) {
        if (player != null) {
            return (ExtendedPlayerProperties)player.getExtendedProperties(EXT_PROP_NAME);
        }
        return null;
    }

    public static final ExtendedPlayerProperties getFromID(int entityID) {
        Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(entityID);
        EntityPlayer entPlayer = (EntityPlayer)entity;
        return (ExtendedPlayerProperties)entPlayer.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74776_a("SoulXP", this.SoulXP[0]);
        properties.func_74776_a("SoulXPShini", this.SoulXP[1]);
        properties.func_74776_a("SoulXPQuincy", this.SoulXP[2]);
        properties.func_74776_a("SoulXPHollow", this.SoulXP[3]);
        properties.func_74776_a("SpiritEnergy", this.SpiritEnergy);
        properties.func_74768_a("MaxSpirit", this.maxSpirit);
        properties.func_74783_a("ReiryokuInfo", this.reiryoku);
        properties.func_74783_a("ReiryokuCreative", this.reiryokuCreative);
        properties.func_74768_a("UpgradeCount", this.upgradeCount);
        properties.func_74768_a("Faction", this.faction);
        properties.func_74783_a("FactionRep", this.factionRep);
        properties.func_74783_a("UnlockedPower", this.UnlockedPower);
        properties.func_74783_a("SwordPoints", this.elementPoints);
        properties.func_74768_a("AttackMode", this.attackMode);
        properties.func_74783_a("Zanpakuto", this.Zanpakuto);
        properties.func_74778_a("ZName", this.ZName);
        properties.func_74768_a("MColor", this.MColor);
        properties.func_74768_a("MaskNBTVariant", this.MaskNBTVariant);
        properties.func_74768_a("MaskTimer", this.maskTimer);
        properties.func_74768_a("MaskTimerMax", this.maskTimerMax);
        properties.func_74768_a("HollowKills", this.HollowKillCount);
        properties.func_74768_a("HollowDeathType", this.HollowDeathType);
        properties.func_74783_a("HollowType", this.hollowType);
        properties.func_74783_a("HollowParts", this.hollowParts);
        properties.func_74768_a("HTex", this.HTex);
        properties.func_74776_a("HColorR", this.HColorR);
        properties.func_74776_a("HColorB", this.HColorB);
        properties.func_74776_a("HColorG", this.HColorG);
        properties.func_74783_a("BleachStats", this.bleachStats);
        properties.func_74783_a("BleachExp", this.bleachExp);
        properties.func_74783_a("BleachAbilities", this.abilities);
        properties.func_74783_a("BleachSpellLevels", this.spellLevels);
        properties.func_74783_a("TrackedData", this.trackedData);
        properties.func_74783_a("ActivePowers", this.activePower);
        properties.func_74783_a("PowerExp", this.activePowerXP);
        properties.func_74783_a("BattleInfo", this.battleInfo);
        nbt.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        if (nbt.func_74764_b(EXT_PROP_NAME)) {
            NBTTagCompound properties = (NBTTagCompound)nbt.func_74781_a(EXT_PROP_NAME);
            this.SoulXP[0] = properties.func_74760_g("SoulXP");
            this.SoulXP[1] = properties.func_74760_g("SoulXPShini");
            this.SoulXP[2] = properties.func_74760_g("SoulXPQuincy");
            this.SoulXP[3] = properties.func_74760_g("SoulXPHollow");
            this.SpiritEnergy = properties.func_74760_g("SpiritEnergy");
            this.maxSpirit = properties.func_74762_e("MaxSpirit");
            this.reiryoku = properties.func_74759_k("ReiryokuInfo");
            this.reiryokuCreative = properties.func_74759_k("ReiryokuCreative");
            this.upgradeCount = properties.func_74762_e("UpgradeCount");
            this.faction = properties.func_74762_e("Faction");
            this.factionRep = properties.func_74759_k("FactionRep");
            this.UnlockedPower = properties.func_74759_k("UnlockedPower");
            this.elementPoints = properties.func_74759_k("SwordPoints");
            this.attackMode = properties.func_74762_e("AttackMode");
            this.Zanpakuto = properties.func_74759_k("Zanpakuto");
            this.ZName = properties.func_74779_i("ZName");
            this.MColor = properties.func_74762_e("MColor");
            this.MaskNBTVariant = properties.func_74762_e("MaskNBTVariant");
            this.maskTimer = properties.func_74762_e("MaskTimer");
            this.maskTimerMax = properties.func_74762_e("MaskTimerMax");
            this.HollowKillCount = properties.func_74762_e("HollowKills");
            this.HollowDeathType = properties.func_74762_e("HollowDeathType");
            this.hollowType = properties.func_74759_k("HollowType");
            this.hollowParts = properties.func_74759_k("HollowParts");
            this.HTex = properties.func_74762_e("HTex");
            this.HColorR = properties.func_74760_g("HColorR");
            this.HColorB = properties.func_74760_g("HColorB");
            this.HColorG = properties.func_74760_g("HColorG");
            this.bleachStats = properties.func_74759_k("BleachStats");
            this.bleachExp = properties.func_74759_k("BleachExp");
            this.abilities = properties.func_74759_k("BleachAbilities");
            this.spellLevels = properties.func_74759_k("BleachSpellLevels");
            this.trackedData = properties.func_74759_k("TrackedData");
            this.activePower = properties.func_74759_k("ActivePowers");
            this.activePowerXP = properties.func_74759_k("PowerExp");
            this.battleInfo = properties.func_74759_k("BattleInfo");
        }
    }

    public void saveClientNBTData(NBTTagCompound nbt) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74783_a("ActivePowers", this.activePower);
        properties.func_74768_a("Faction", this.faction);
        properties.func_74783_a("HollowParts", this.hollowParts);
        properties.func_74768_a("HTex", this.HTex);
        properties.func_74776_a("HColorR", this.HColorR);
        properties.func_74776_a("HColorB", this.HColorB);
        properties.func_74776_a("HColorG", this.HColorG);
        properties.func_74768_a("MColor", this.MColor);
        properties.func_74768_a("MaskNBTVariant", this.MaskNBTVariant);
        nbt.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadClientNBTData(NBTTagCompound nbt) {
        if (nbt.func_74764_b(EXT_PROP_NAME)) {
            NBTTagCompound properties = (NBTTagCompound)nbt.func_74781_a(EXT_PROP_NAME);
            this.activePower = properties.func_74759_k("ActivePowers");
            this.faction = properties.func_74762_e("Faction");
            this.hollowParts = properties.func_74759_k("HollowParts");
            this.HTex = properties.func_74762_e("HTex");
            this.HColorR = properties.func_74760_g("HColorR");
            this.HColorB = properties.func_74760_g("HColorB");
            this.HColorG = properties.func_74760_g("HColorG");
            this.MColor = properties.func_74762_e("MColor");
            this.MaskNBTVariant = properties.func_74762_e("MaskNBTVariant");
        }
    }

    private static String getSaveKey(EntityPlayer player) {
        return player.func_70005_c_() + ":" + EXT_PROP_NAME;
    }

    public void init(Entity entity, World world) {
    }

    public void setZName(String name) {
        this.ZName = name;
    }

    public void setZType(int var1) {
        this.Zanpakuto[0] = var1;
    }

    public void setZTexture(int var1) {
        this.Zanpakuto[1] = var1;
    }

    public void setZCombatStyle(int var1) {
        this.Zanpakuto[2] = var1;
    }

    public String getZName() {
        return this.ZName;
    }

    public int getZType() {
        return this.Zanpakuto[0];
    }

    public int getZTexture() {
        return this.Zanpakuto[1];
    }

    public int getZCombatStyle() {
        return this.Zanpakuto[2];
    }

    public void addSXPReiryoku(int amount, int index) {
        amount *= this.debugEXPmultiply;
        int n = index;
        this.SoulXP[n] = this.SoulXP[n] + (float)(amount *= ConfigHandler.reiryokuXPRate) / (float)this.getMaxReiryoku(index);
        if ((double)this.SoulXP[index] >= 1.0) {
            this.addReiryoku(index, 5);
            this.SoulXP[index] = 0.0f;
        }
    }

    public void addSXP(int amount) {
        this.addSXP(amount, 0);
    }

    public void addSXP(int amount, int index) {
        this.addSXPReiryoku(amount, index);
    }

    public float getCurrentSXP(int index) {
        return this.SoulXP[index];
    }

    public void setCurrentSpiritEnergy(int amount) {
        float energy = (float)amount / (float)this.getMaxSpirit();
        this.SpiritEnergy = energy > 0.0f ? (energy > 1.0f ? 1.0f : energy) : 0.0f;
    }

    public void setMaxSpirit(int amount) {
        this.maxSpirit = amount > 5 ? amount : 0;
    }

    public int getMaxSpirit() {
        return this.maxSpirit;
    }

    public boolean useAbility(int ability, int lvl) {
        this.trackedData[1] = ability;
        this.trackedData[2] = lvl;
        boolean worked = false;
        switch (ability) {
            case 0: {
                worked = this.activateFlashStep(lvl);
                break;
            }
            case 1: {
                worked = this.activateKidoSpell(lvl);
                break;
            }
            case 3: {
                worked = this.activateCero(lvl);
                break;
            }
            case 4: {
                worked = this.activatePortal(lvl);
                break;
            }
            default: {
                return false;
            }
        }
        if (worked) {
            return this.consumeFromAbility();
        }
        return false;
    }

    public boolean activateFlashStep(int lvl) {
        return false;
    }

    public boolean activateKidoSpell(int lvl) {
        return false;
    }

    public boolean activateCero(int lvl) {
        return false;
    }

    public boolean activatePortal(int lvl) {
        return false;
    }

    public boolean consumeFromAbility() {
        int abiUsed = this.trackedData[1];
        int abiLvl = this.trackedData[2];
        int amount = 10;
        return this.consumeSpiritEnergy(amount);
    }

    public float getPercentSpiritEnergy() {
        return this.SpiritEnergy;
    }

    public int getSpiritEnergy() {
        return (int)(this.SpiritEnergy * (float)this.getMaxSpirit());
    }

    public int consumeAndUseSpirit(int amount) {
        if (!this.player.field_71075_bZ.field_75098_d) {
            int remainder = this.consumeSpiritEnergy(amount) ? 0 : amount - this.getSpiritEnergy();
            return remainder;
        }
        return 0;
    }

    public boolean consumeSpiritEnergy(int amount) {
        if (!this.player.field_71075_bZ.field_75098_d) {
            boolean sufficient = this.isEnergyMoreThan(amount);
            this.SpiritEnergy -= sufficient ? (float)amount / (float)this.getMaxSpirit() : this.SpiritEnergy;
            this.SpiritEnergy = this.SpiritEnergy <= 0.0f ? 0.0f : (this.SpiritEnergy > 1.0f ? 1.0f : this.SpiritEnergy);
            return sufficient;
        }
        return true;
    }

    public boolean replenishSpiritEnergy(int amount) {
        boolean sufficient = this.SpiritEnergy < 1.0f;
        this.SpiritEnergy += this.SpiritEnergy < 1.0f ? (float)amount / (float)this.getMaxSpirit() : this.SpiritEnergy;
        this.SpiritEnergy = this.SpiritEnergy >= 1.0f ? 1.0f : this.SpiritEnergy;
        return sufficient;
    }

    public boolean isEnergyMoreThan(int compareTo) {
        return this.getSpiritEnergy() > compareTo;
    }

    public boolean isEnergyLessThan(int compareTo) {
        return this.getSpiritEnergy() < compareTo;
    }

    public void setPoints(int index, int amount) {
        this.elementPoints[index] = amount;
    }

    public void addPoints(int type, int amount) {
        int n = type;
        this.elementPoints[n] = this.elementPoints[n] + amount;
    }

    public int getPointTotal() {
        int sum = 0;
        for (int value : this.elementPoints) {
            sum += value;
        }
        return sum;
    }

    public int getPoints(int index) {
        if (index >= 8) {
            return this.getPointTotal();
        }
        return this.elementPoints[index];
    }

    public void setType(int type) {
        int i;
        for (i = 0; i < this.elementPoints.length; ++i) {
            this.elementPoints[i] = i == type ? 400 : 0;
        }
        switch (type) {
            case 8: {
                this.elementPoints[7] = 200;
                this.elementPoints[6] = 200;
                break;
            }
            case 9: {
                this.elementPoints[6] = 200;
                this.elementPoints[5] = 200;
                break;
            }
            case 10: {
                this.elementPoints[1] = 200;
                this.elementPoints[0] = 200;
                break;
            }
            case 11: {
                for (i = 0; i < this.elementPoints.length; ++i) {
                    this.elementPoints[i] = 50;
                }
                break;
            }
        }
        this.setUnlockedPower(2, 2);
    }

    public void resetType() {
        this.elementPoints = new int[8];
        this.Zanpakuto = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.Zanpakuto[i] = -1;
        }
        this.setZName("");
        if (this.getUnlockedPower(0) == 2) {
            this.setUnlockedPower(2, 1);
        }
    }

    public void randomTexture() {
        this.setZTexture(this.rand.nextInt(5));
    }

    public void setAttackMode(int var1) {
        this.attackMode = var1;
    }

    public int getAttackMode() {
        return this.attackMode;
    }

    public int getMaskNBTVariant() {
        return this.MaskNBTVariant;
    }

    public void updateMaskNBTVariant() {
        ++this.MaskNBTVariant;
        if (this.MaskNBTVariant >= 5) {
            this.MaskNBTVariant = 0;
        }
        if (this.MaskNBTVariant < 0) {
            this.MaskNBTVariant = 0;
        }
    }

    public void setMColor(int var1) {
        this.MColor = var1;
    }

    public int getMColor() {
        return this.MColor;
    }

    public boolean checkValidFlash() {
        if (!this.isQuincy() && BleachLib.isEntityInCube((Entity)this.player)) {
            return false;
        }
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (this.player.field_70170_p.func_147439_a((int)this.player.field_70165_t, (int)(this.player.field_70163_u + (double)j), (int)(this.player.field_70161_v + (double)k)) == Blocks.field_150350_a) continue;
                return true;
            }
        }
        return false;
    }

    public void decideWhatToDo(int readInt) {
        if (readInt == 1) {
            if (this.checkValidFlash()) {
                boolean configOverride;
                int distance = 9;
                boolean bl = configOverride = ConfigHandler.spiritFlashandArmour == 2 || ConfigHandler.spiritFlashandArmour == 3;
                if ((this.isFullBring() || this.fullOutfit(0) || configOverride) && this.isEnergyMoreThan(5)) {
                    if (this.player instanceof EntityPlayerMP) {
                        BleachMod.network.sendTo((IMessage)new MoveMessage(distance), (EntityPlayerMP)this.player);
                    }
                    this.consumeSpiritEnergy(5);
                    this.player.field_70170_p.func_72956_a((Entity)this.player, BleachSounds.shunpo.toString(), 0.4f, 1.0f);
                }
            }
        } else if (readInt == 2) {
            Item curr;
            if (this.isQuincy() && this.getUnlockedPower(4) >= 3 && this.SpiritEnergy > 0.2f && this.player.func_71045_bC() != null && this.player.func_71045_bC().field_77994_a == 1 && ((curr = this.player.func_71045_bC().func_77973_b()) == BleachItems.sanreiGlove || curr == BleachArmor.QuincyLeztzStil)) {
                this.activateLeztzStil();
            }
            if (!this.isHollow() && !this.isFullBring() && this.getUnlockedPower(3) != 0) {
                if (this.getActivePower(2) == 0) {
                    this.activateMask();
                } else if (this.getActivePower(2) == 1) {
                    this.deactivateMask();
                }
            }
            if (this.isHollow()) {
                if (this.getAttackMode() == 0) {
                    this.setAttackMode(1);
                    return;
                }
                if (this.getAttackMode() == 1) {
                    this.setAttackMode(0);
                    return;
                }
            }
        } else {
            if (readInt == 3) {
                ItemStack bleachGuide = new ItemStack(BleachItems.bleachGuideBook);
                if (!this.player.field_71071_by.func_70441_a(bleachGuide)) {
                    this.player.func_146097_a(bleachGuide, false, true);
                }
                return;
            }
            if (readInt == 11) {
                if (this.reiryoku[0] < 50) {
                    this.setReiryoku(0, 50);
                }
                this.setAsShinigami(0, 0);
            } else if (readInt == 12) {
                if (this.reiryoku[0] < 50) {
                    this.setReiryoku(0, 50);
                }
                this.setAsHollow(0, 0);
            } else if (readInt == 13) {
                if (this.reiryoku[0] < 50) {
                    this.setReiryoku(0, 50);
                }
                this.setAsQuincy(0, 0);
            } else if (readInt == 14) {
                this.setAsHuman(0);
            }
        }
    }

    public void activate(ItemStack stack, int attackMode) {
        if (attackMode == -1) {
            ItemSoulChain chain;
            ItemReiatsu reiatsu;
            if (this.isHollow() && this.getAbilityLevel(4) >= 2 && stack.func_77973_b() == BleachItems.reiatsu && stack.field_77994_a == 1 && (reiatsu = (ItemReiatsu)stack.func_77973_b()).getHollowActive(stack) == 0) {
                reiatsu.setHollowActive(stack, 0);
                return;
            }
            if ((this.isHuman() || this.isSpirit()) && stack.func_77973_b() == BleachArmor.SoulChain && stack.field_77994_a == 1 && (chain = (ItemSoulChain)stack.func_77973_b()).getHollowActive(stack) == 0) {
                chain.setHollowActive(stack, 1);
                return;
            }
            if (stack.func_77973_b() == BleachItems.zanpakuto && this.getUnlockedPower(2) >= 2 && this.reiryoku[0] >= 200 && this.getPointTotal() >= 400 && stack.func_82837_s() && stack.func_82833_r().equalsIgnoreCase(this.getZName()) && this.isShinigami()) {
                if (!this.player.field_70170_p.field_72995_K) {
                    if (this.getZTexture() == -1) {
                        this.randomTexture();
                        if (this.getZType() == 0 && this.getZName().equalsIgnoreCase("vox populi")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 1 && this.getZName().equalsIgnoreCase("ice cream")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 2 && this.getZName().equalsIgnoreCase("ashisogi jizo")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 3 && this.getZName().equalsIgnoreCase("love")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 4 && this.getZName().equalsIgnoreCase("piko piko")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 5 && this.getZName().equalsIgnoreCase("fightin words")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 6 && this.getZName().equalsIgnoreCase("master sword")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 7 && this.getZName().equalsIgnoreCase("souledge")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 8 && this.getZName().equalsIgnoreCase("zangetsu")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 9 && this.getZName().equalsIgnoreCase("mjolnir")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 10 && this.getZName().equalsIgnoreCase("sakana")) {
                            this.setZTexture(5);
                        } else if (this.getZType() == 11 && this.getZName().equalsIgnoreCase("ticonderoga")) {
                            this.setZTexture(5);
                        }
                    }
                    ItemStack shikai = this.Shikai[this.getZType()];
                    shikai.func_151001_c(stack.func_82833_r());
                    this.player.func_70062_b(0, shikai);
                    this.player.field_71071_by.func_70296_d();
                    Vec3 normalizer = Vec3.func_72443_a((double)0.008, (double)0.008, (double)0.008).func_72432_b();
                    List list = this.player.field_70170_p.func_72872_a(EntityPlayer.class, this.player.field_70121_D.func_72329_c().func_72314_b(Math.abs(normalizer.field_72450_a * 15.0), Math.abs(normalizer.field_72448_b * 15.0), Math.abs(normalizer.field_72449_c * 15.0)));
                    for (int l = 0; l < list.size(); ++l) {
                        Entity entity1 = (Entity)list.get(l);
                        if (entity1 == null || !(entity1 instanceof EntityPlayer)) continue;
                        EntityPlayer surroundingPlayers = (EntityPlayer)entity1;
                        surroundingPlayers.func_145747_a((IChatComponent)new ChatComponentText(Names.ShikaiPhrases[6 * this.getZType() + this.getZTexture()] + " " + stack.func_82833_r() + "!"));
                    }
                }
                this.consumeSpiritEnergy(50);
            }
        } else if (this.isFullBring() && this.getActivePower(4) == 0) {
            this.activateFullBring();
        }
    }

    public void deactivate(Item theItem) {
        if (theItem instanceof ItemShikai) {
            ItemStack Sword = new ItemStack(BleachItems.zanpakuto, 1);
            if (this.player.func_70694_bm().func_82837_s()) {
                Sword.func_151001_c(this.player.func_70694_bm().func_82833_r());
            }
            this.player.func_70062_b(0, Sword);
        } else if (theItem == BleachItems.quincybow) {
            ItemStack Pendant = new ItemStack(BleachItems.quincypendant, 1, 0);
            this.player.func_70062_b(0, Pendant);
            this.player.func_70694_bm().func_77964_b(0);
        } else if (theItem == BleachItems.quincyweb) {
            ItemStack Pendant = new ItemStack(BleachItems.quincypendant, 1, 1);
            this.player.func_70062_b(0, Pendant);
            this.player.func_70694_bm().func_77964_b(1);
        } else if (theItem == BleachItems.seele) {
            ItemStack Seele = new ItemStack(BleachItems.seele, 1, 0);
            this.player.func_70062_b(0, Seele);
        }
    }

    public int armourCheck(int armorSlot) {
        ItemStack armour = this.player.field_71071_by.func_70440_f(armorSlot);
        if (armour != null && armour.func_77973_b() instanceof ISpiritArmour) {
            ISpiritArmour spiritArmour = (ISpiritArmour)armour.func_77973_b();
            return spiritArmour.getFaction();
        }
        return -1;
    }

    public boolean fullOutfit(int factionCheck) {
        int sum = 0;
        for (int i = 0; i < 3; ++i) {
            if (factionCheck != 0) {
                if (this.armourCheck(i) != factionCheck) continue;
                ++sum;
                continue;
            }
            if (this.armourCheck(i) == -1) continue;
            ++sum;
        }
        return sum == 3;
    }

    public boolean fullQuincy() {
        ItemStack shoes = this.player.field_71071_by.field_70460_b[0];
        ItemStack pants = this.player.field_71071_by.field_70460_b[1];
        ItemStack chest = this.player.field_71071_by.field_70460_b[2];
        return this.fullOutfit(2) && this.isQuincy() && shoes != null && shoes.func_77973_b() == BleachArmor.QuincyShoes && pants != null && pants.func_77973_b() == BleachArmor.QuincyPants && chest != null && chest.func_77973_b() == BleachArmor.QuincyRobe;
    }

    public boolean fullShinigami() {
        ItemStack shoes = this.player.field_71071_by.field_70460_b[0];
        ItemStack pants = this.player.field_71071_by.field_70460_b[1];
        ItemStack chest = this.player.field_71071_by.field_70460_b[2];
        return !(!this.fullOutfit(1) || !this.isShinigami() || shoes == null || shoes.func_77973_b() != BleachArmor.Sandals && shoes.func_77973_b() != BleachArmor.SandalsH || pants == null || pants.func_77973_b() != BleachArmor.ShiniPants && pants.func_77973_b() != BleachArmor.ShiniHPants || chest == null || chest.func_77973_b() != BleachArmor.ShiniRobe && chest.func_77973_b() != BleachArmor.ShiniHRobe && chest.func_77973_b() != BleachArmor.ShiniCaptain);
    }

    public boolean fullArrancar() {
        ItemStack shoes = this.player.field_71071_by.field_70460_b[0];
        ItemStack pants = this.player.field_71071_by.field_70460_b[1];
        ItemStack chest = this.player.field_71071_by.field_70460_b[2];
        return this.fullOutfit(3) && this.isArrancar() && shoes != null && shoes.func_77973_b() == BleachArmor.ArrancarShoes && pants != null && pants.func_77973_b() == BleachArmor.ArrancarPants && chest != null && chest.func_77973_b() == BleachArmor.ArrancarJacket;
    }

    public void setUnlockedPower(int index, int par1) {
        this.UnlockedPower[index] = par1;
        this.powerUpdate();
        this.updateFaction();
    }

    public int getUnlockedPower(int index) {
        return this.UnlockedPower[index];
    }

    public void setAbilityUnlock(int index, int level) {
        this.abilities[index] = level;
    }

    public int getAbilityLevel(int index) {
        return this.abilities[index];
    }

    public void decreaseMaskTimer(int amount) {
        if (amount == 0) {
            amount = 20;
        }
        this.maskTimer -= amount;
        if (this.maskTimer <= 0) {
            this.maskTimer = 0;
            this.deactivateMask();
        }
    }

    public void recoverMaskEnergy(int amount) {
        if (this.activePower[2] == 0) {
            if (amount == 0) {
                amount = 20;
            }
            if (this.maskTimer < this.getMaskTimerMax()) {
                this.maskTimer += amount;
            }
        }
    }

    public void setMaskTimerMax() {
        int maskXP = this.activePowerXP[2];
        int maskLvl = this.getUnlockedPower(3);
        int reiHollow = this.reiryoku[3];
        this.maskTimerMax = 300;
    }

    public int getMaskTime() {
        return this.maskTimer;
    }

    public int getMaskTimerMax() {
        return this.maskTimerMax;
    }

    public boolean activateMask() {
        int maskTimerMax = this.getMaskTimerMax();
        if ((float)this.getMaskTime() > 0.1f * (float)maskTimerMax) {
            this.activatePower(2, 1);
            return true;
        }
        return false;
    }

    public void activateBankai() {
        this.activatePower(0, 1);
    }

    public void activateResurrecion() {
        this.activatePower(1, 1);
    }

    public void activateSepunda() {
        this.activatePower(1, 2);
    }

    public void activateLeztzStil() {
        ItemStack chest = this.player.func_82169_q(2);
        ItemStack current = this.player.func_71045_bC();
        if (!this.player.field_70170_p.field_72995_K) {
            ItemStack letz = new ItemStack(BleachArmor.QuincyLeztzStil);
            if (current.func_77973_b() instanceof ItemQuincyLeztzStil) {
                letz = current.func_77946_l();
            }
            ItemQuincyLeztzStil leztz = (ItemQuincyLeztzStil)letz.func_77973_b();
            int type = 0;
            if (chest != null) {
                type = chest.func_77973_b() == BleachArmor.QuincyRobe ? 1 : (chest.func_77973_b() == BleachArmor.QuincyRobe2 ? 2 : (chest.func_77973_b() == BleachArmor.ShiniRobe ? 3 : (chest.func_77973_b() == BleachArmor.ShiniHRobe ? 4 : 0)));
                BleachLib.unequipItem(this.player, 2, chest);
            }
            leztz.setCloakVariation(letz, type);
            if (!this.player.field_71075_bZ.field_75098_d) {
                this.player.field_71071_by.func_70299_a(this.player.field_71071_by.field_70461_c, (ItemStack)null);
            }
            this.player.func_70062_b(3, letz);
        }
        this.activatePower(3, 1);
    }

    public void activateVolstandig() {
        this.activatePower(3, 2);
    }

    public void activateVolstandig2() {
        this.activatePower(3, 3);
    }

    public void activateFullBring() {
        this.activatePower(4, 1);
    }

    public void activateFullPowerFullBring() {
        this.activatePower(4, 2);
    }

    public void activatePower(int power, int level) {
        boolean flag = false;
        if (power == 0 && this.isShinigami() && this.getUnlockedPower(2) >= 4 && this.activePower[0] == 0) {
            this.activePower[0] = 1;
            flag = true;
        }
        if (power == 1 && this.isArrancar()) {
            int n = level > 2 ? 2 : (level = level < 0 ? 0 : level);
            if (this.activePower[1] == 0 && level >= 1 && this.getUnlockedPower(2) >= 2) {
                this.activePower[1] = 1;
                flag = true;
            } else if (this.activePower[1] == 1 && level == 2 && this.getUnlockedPower(2) >= 3) {
                this.activePower[1] = 2;
                flag = true;
            }
        }
        if (power == 2 && this.isVisored() && this.activePower[2] == 0 && this.getUnlockedPower(3) > 0) {
            this.activePower[2] = 1;
            flag = true;
        }
        if (power == 3 && this.isQuincy()) {
            int n = level < 0 ? 0 : (level = level > 3 ? 3 : level);
            if (this.activePower[3] == 0 && level >= 1 && this.getUnlockedPower(4) >= 3) {
                this.activePower[3] = 1;
                flag = true;
            } else if (this.activePower[3] == 1 && level >= 2 && this.getUnlockedPower(4) >= 4) {
                this.activePower[3] = 2;
                flag = true;
            } else if (this.activePower[3] == 2 && level >= 3 && this.getUnlockedPower(4) >= 5) {
                this.activePower[3] = 3;
                flag = true;
            }
        }
        if (power == 4 && this.isFullBring()) {
            int n = level < 0 ? 0 : (level = level > 2 ? 2 : level);
            if (this.activePower[4] == 0 && level >= 1 && this.getUnlockedPower(3) >= 1) {
                this.activePower[4] = 1;
                flag = true;
            } else if (this.activePower[4] == 1 && level >= 2 && this.getUnlockedPower(3) >= 2) {
                this.activePower[4] = 2;
                flag = true;
            }
        }
        if (flag) {
            this.powerUpdate();
        }
    }

    public void trackActivePowers() {
        for (int i = 0; i < 5; ++i) {
            if (this.getActivePower(i) == 0) continue;
            this.consumeSpiritFromPower(i, this.getActivePower(i));
            this.addExperienceFromPower(i, this.getActivePower(i));
        }
    }

    public int getActivePower(int index) {
        return this.activePower[index];
    }

    public void addExperienceFromPower(int power, int level) {
        int expToAdd = 1;
        int powerXP = this.activePowerXP[power];
        if (powerXP < 1000) {
            int n = power;
            this.activePowerXP[n] = this.activePowerXP[n] + expToAdd;
        }
        if (power == 2 && powerXP == this.getMaskTimerMax()) {
            this.addHollowReiryoku(5);
            this.activePowerXP[power] = 0;
        }
    }

    public void consumeSpiritFromPower(int power, int level) {
        int powerXP = this.activePowerXP[power];
        int amount = 40;
        if (power == 4 && level == 1) {
            amount = 5;
        }
        this.consumeSpiritEnergy(amount);
        if (this.getSpiritEnergy() <= 0) {
            this.deactivatePower(power);
        }
    }

    public void deactivateAllPowers() {
        for (int i = 0; i < 5; ++i) {
            this.deactivatePower(i);
        }
    }

    public void deactivatePower(int power) {
        this.activePower[power] = 0;
        this.powerUpdate();
    }

    public void deactivateBankai() {
        this.deactivatePower(0);
    }

    public void deactivateHollow() {
        this.deactivatePower(1);
    }

    public void deactivateMask() {
        this.setMaskTimerMax();
        this.deactivatePower(2);
    }

    public void deactivateQuincy() {
        this.deactivatePower(3);
    }

    public void deactivateFullBring() {
        this.deactivatePower(4);
    }

    public void powerUpdate() {
        this.setMaxSpirit(this.setUsableMaxReiryoku());
    }

    public void setHTex(int var1) {
        this.HTex = var1;
    }

    public void setHead(int var1) {
        this.hollowParts[0] = var1;
    }

    public void setBack(int var1) {
        this.hollowParts[1] = var1;
    }

    public void setArms(int var1) {
        this.hollowParts[2] = var1;
    }

    public void setLegs(int var1) {
        this.hollowParts[3] = var1;
    }

    public void setTail(int var1) {
        this.hollowParts[4] = var1;
    }

    public void setHColorR(float var1) {
        this.HColorR = var1;
    }

    public void setHColorB(float var1) {
        this.HColorB = var1;
    }

    public void setHColorG(float var1) {
        this.HColorG = var1;
    }

    public void setHollowTypes(int index, int amount) {
        this.hollowType[index] = amount;
    }

    public void addHollowType(int type, int amount) {
        int n = type;
        this.hollowType[n] = this.hollowType[n] + amount;
    }

    public int getHollowTypeTotal(boolean include5) {
        int sum = 0;
        for (int value : this.hollowType) {
            sum += value;
        }
        if (!include5) {
            sum -= this.hollowType[5];
        }
        return sum;
    }

    public int getHollowType(int index) {
        return this.hollowType[index];
    }

    public int getHTex() {
        return this.HTex;
    }

    public int getHead() {
        return this.hollowParts[0];
    }

    public int getBack() {
        return this.hollowParts[1];
    }

    public int getArms() {
        return this.hollowParts[2];
    }

    public int getLegs() {
        return this.hollowParts[3];
    }

    public int getTail() {
        return this.hollowParts[4];
    }

    public float getHColorR() {
        return this.HColorR;
    }

    public float getHColorB() {
        return this.HColorB;
    }

    public float getHColorG() {
        return this.HColorG;
    }

    public void randMaskSkin() {
        Random rand = new Random();
        this.setHColorR(rand.nextFloat());
        this.setHColorB(rand.nextFloat());
        this.setHColorG(rand.nextFloat());
        this.setHTex(rand.nextInt(texCount + 1));
    }

    public void randomizeHollow() {
        Random rand = new Random();
        this.setHColorR(rand.nextFloat());
        this.setHColorB(rand.nextFloat());
        this.setHColorG(rand.nextFloat());
        this.setHTex(rand.nextInt(texCount + 1));
        this.setHead(rand.nextInt(headCount + 1));
        this.setBack(rand.nextInt(backCount + 1));
        this.setLegs(rand.nextInt(legsCount + 1));
        this.setArms(rand.nextInt(armsCount + 1));
        this.setTail(rand.nextInt(tailCount + 1));
    }

    public void setHollowPart(int partType) {
        switch (partType) {
            case 0: {
                if (this.getHead() == 0) {
                    this.setHead(this.rand.nextInt(headCount + 1));
                }
                return;
            }
            case 1: {
                if (this.getBack() == 0) {
                    this.setBack(this.rand.nextInt(backCount + 1));
                }
                return;
            }
            case 2: {
                if (this.getArms() == 0) {
                    this.setArms(this.rand.nextInt(armsCount + 1));
                }
                return;
            }
            case 3: {
                if (this.getLegs() == 0) {
                    this.setLegs(this.rand.nextInt(legsCount + 1));
                }
                return;
            }
            case 4: {
                if (this.getTail() == 0) {
                    this.setTail(this.rand.nextInt(tailCount + 1));
                }
                return;
            }
        }
    }

    public void setHollowPart(int index, int part) {
        this.hollowParts[index] = part;
    }

    public int getHollowPart(int partType) {
        return this.hollowParts[partType];
    }

    public boolean isTailUsable() {
        switch (this.getLegs()) {
            case 3: {
                return false;
            }
        }
        switch (this.getTail()) {
            case 0: {
                return false;
            }
        }
        return true;
    }

    public void resetHollow() {
        this.randMaskSkin();
        for (int i = 0; i < 6; ++i) {
            this.hollowType[i] = 0;
            this.hollowParts[i] = 0;
        }
    }

    public int getFactionRep(int index) {
        return this.factionRep[index];
    }

    public void setFactionRep(int index, int value) {
        this.factionRep[index] = value;
    }

    public boolean isHuman() {
        return this.getUnlockedPower(0) == 0;
    }

    public boolean isSpirit() {
        return this.getUnlockedPower(1) == 1;
    }

    public boolean noPowers() {
        boolean flag = true;
        if (this.getUnlockedPower(0) == 0) {
            for (int i = 2; i < this.UnlockedPower.length; ++i) {
                if (this.getUnlockedPower(i) == 0) continue;
                flag = false;
                break;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public boolean isHumanFac() {
        return this.getFaction() == 0;
    }

    public boolean isAWhole() {
        return this.getFaction() == 1;
    }

    public boolean isShinigami() {
        int fac = this.getFaction();
        return fac == 2 || fac == 8;
    }

    public boolean isShinigamiFac() {
        return this.getFaction() == 2;
    }

    public boolean isVisored() {
        return this.getFaction() == 8;
    }

    public boolean isQuincy() {
        return this.getFaction() == 4;
    }

    public boolean isHollow() {
        int fac = this.getFaction();
        return fac == 3 || fac == 9 || fac == 10 || fac == 11;
    }

    public boolean isArrancar() {
        return this.getFaction() == 12;
    }

    public boolean isBount() {
        return this.getFaction() == 5;
    }

    public boolean isFullBring() {
        return this.getFaction() == 7;
    }

    public boolean isTogabito() {
        return this.getFaction() == 6;
    }

    public boolean isAscended() {
        return this.getFaction() == 13;
    }

    public int getFactionId() {
        int faction;
        int powerBase = this.getUnlockedPower(0);
        int n = faction = powerBase == 7 ? 13 : powerBase;
        if (powerBase == 0 && this.getUnlockedPower(1) == 1 && this.noPowers()) {
            faction = 1;
        }
        if (powerBase == 0 && this.getUnlockedPower(3) != 0) {
            faction = 7;
        }
        if (powerBase == 2 && this.getUnlockedPower(3) != 0) {
            faction = 8;
        }
        if (powerBase == 3) {
            int hollow;
            int n2 = hollow = this.getUnlockedPower(3) - 3 >= 0 ? 9 + this.getUnlockedPower(3) - 3 : powerBase;
            if (this.getUnlockedPower(2) != 0) {
                hollow = 12;
            }
            faction = hollow;
        }
        return faction;
    }

    public int getFaction() {
        return this.faction;
    }

    public void updateFaction() {
        this.faction = this.getFactionId();
    }

    public boolean setAsFaction(int id, int level, int override) {
        switch (id) {
            case 0: {
                this.setAsHuman(override);
                return true;
            }
            case 1: {
                this.setAsWhole(1, override);
                return true;
            }
            case 2: {
                this.setAsShinigami(level, override);
                return true;
            }
            case 3: {
                this.setAsHollow(level, override);
                return true;
            }
            case 4: {
                this.setAsQuincy(level, override);
                return true;
            }
            case 5: {
                this.setAsBount(override);
                return true;
            }
            case 6: {
                this.setAsSinner(override);
                return true;
            }
            case 7: {
                this.setAsFullbringer(level, override);
                return true;
            }
            case 8: {
                this.setAsVisored(level, override);
                return true;
            }
            case 9: {
                this.setAsMenos(override);
                return true;
            }
            case 10: {
                this.setAsAdjuchas(override);
                return true;
            }
            case 11: {
                this.setAsVastoLorde(override);
                return true;
            }
            case 12: {
                this.setAsArrancar(level, override);
                return true;
            }
            case 13: {
                this.setAsAscended(override);
                return true;
            }
        }
        return false;
    }

    public void setAsHuman(int override) {
        if (override == 0) {
            for (int i = 0; i < this.UnlockedPower.length; ++i) {
                this.setUnlockedPower(i, 0);
            }
        }
    }

    public void setAsWhole(int living, int override) {
        this.setAsHuman(override);
        if (living == 1) {
            this.setUnlockedPower(1, 1);
        }
    }

    public void setAlive(int override) {
        if (this.getUnlockedPower(0) != 7 && this.getUnlockedPower(0) != 3 && this.getUnlockedPower(0) != 6) {
            this.setUnlockedPower(1, 0);
        }
    }

    public void setAsHollow(int level, int override) {
        this.setAsWhole(1, override);
        this.setUnlockedPower(0, 3);
        level = level <= 0 ? 1 : (level > 6 ? 6 : level);
        this.setUnlockedPower(3, level);
    }

    public void setAsMenos(int override) {
        this.setAsHollow(3, override);
    }

    public void setAsAdjuchas(int override) {
        this.setAsHollow(4, override);
    }

    public void setAsVastoLorde(int override) {
        this.setAsHollow(5, override);
    }

    public void setAsArrancar(int level, int override) {
        this.setAsHollow(6, override);
        level = level + 1 > 3 ? 3 : level + 1;
        this.setUnlockedPower(2, level);
    }

    public void setAsShinigami(int level, int override) {
        this.setAsWhole(this.getUnlockedPower(1), override);
        this.setUnlockedPower(0, 2);
        level = level <= 0 ? 1 : (level > 5 ? 5 : level);
        this.setUnlockedPower(2, level);
    }

    public void setAsShiniCaptain(int override) {
        this.setAsShinigami(4, override);
    }

    public void setAsVisored(int mask, int override) {
        int level = this.getUnlockedPower(2);
        level = level < 2 ? 2 : (level > 4 ? 4 : level);
        this.setAsShinigami(level, override);
        int n = mask < 1 ? 1 : (mask = mask > 5 ? 5 : mask);
        if (this.getUnlockedPower(3) == 0) {
            this.setUnlockedPower(3, mask);
        }
    }

    public void setAsMergedShini(int override) {
        this.setAsShinigami(5, override);
    }

    public void setAsQuincy(int level, int override) {
        this.setAsHuman(override);
        this.setUnlockedPower(0, 4);
        this.setUnlockedPower(1, 0);
        level = level <= 0 ? 1 : (level > 5 ? 5 : level);
        this.setUnlockedPower(4, level);
    }

    public void setAsQuincyLeztzStil(int override) {
        this.setAsQuincy(3, override);
    }

    public void setAsQuincyVolstandigUser(int voltLvl, int override) {
        voltLvl = voltLvl >= 2 ? 1 : (voltLvl >= 0 ? voltLvl : 0);
        this.setAsQuincy(4 + voltLvl, override);
    }

    public void setAsFullbringer(int level, int override) {
        this.setAsHuman(override);
        level = level < 1 ? 1 : (level > 3 ? 3 : level);
        this.setUnlockedPower(3, level);
    }

    public void setAsBount(int override) {
        this.setAsHuman(override);
        this.setUnlockedPower(0, 5);
        this.setUnlockedPower(5, 1);
    }

    public void setAsSinner(int override) {
        this.setUnlockedPower(0, 6);
        this.setUnlockedPower(1, 1);
        this.setUnlockedPower(6, 1);
    }

    public void setAsAscended(int override) {
        this.setUnlockedPower(0, 7);
        this.setUnlockedPower(1, 1);
        for (int i = 2; i < this.UnlockedPower.length; ++i) {
            this.setUnlockedPower(i, 5);
        }
    }

    public void setBleachStat(int index, int value) {
        this.bleachStats[index] = value;
        this.powerUpdate();
    }

    public int getBleachStat(int index) {
        return this.bleachStats[index];
    }

    public void setBleachStatExp(int index, int value) {
        this.bleachExp[index] = value;
    }

    public int getBleachStatExp(int index) {
        return this.bleachExp[index];
    }

    public double getBaseDamage() {
        int strength = this.bleachStats[0];
        int reiryoku = this.getMaxSpirit();
        int endurance = this.bleachStats[2];
        int reiatsu = this.bleachStats[7];
        float reiatsuCount = 0 + reiatsu / (5 * (ConfigHandler.statMax[7] / 100));
        float strFactor = this.bleachStats[0] / 10 + 10 * this.bleachStats[0] / ConfigHandler.statMax[0];
        float endFactor = this.bleachStats[2] > 50 ? (float)(this.bleachStats[2] <= 170 ? this.bleachStats[2] / 10 - 2 : 15) : 1.0f;
        float reiry = reiryoku / 100;
        float reiryDiv = reiry / 5.0f;
        int damMax = ConfigHandler.spiritDamageBoost;
        int damageIncrease = (int)(strFactor + endFactor / 10.0f + reiryDiv);
        return damageIncrease > damMax ? (double)damMax : (double)damageIncrease;
    }

    public float getHollowBoost(int typeNeeded) {
        float boost = 0.0f;
        for (int i = 0; i < 5; ++i) {
            boost += this.getHollowPartBoost(i, typeNeeded);
        }
        return boost;
    }

    public float getHollowPartBoost(int partType, int typeNeeded) {
        float value = 0.0f;
        float amplifier = 0.0f;
        if (this.getUnlockedPower(0) == 3) {
            amplifier = 1.0f;
            switch (this.getUnlockedPower(3)) {
                case 3: {
                    amplifier = 0.0f;
                }
                case 4: {
                    amplifier = 1.2f;
                }
                case 5: {
                    amplifier = 1.6f;
                }
                case 6: {
                    amplifier = 0.0f;
                }
            }
            if (this.getUnlockedPower(3) >= 6) {
                amplifier = 0.0f;
            }
            if (partType > 4 || partType < 0) {
                return 0.0f;
            }
            int check = this.getHollowPart(partType);
            if (partType == 0) {
                // empty if block
            }
            if (partType == 1) {
                // empty if block
            }
            if (partType == 2) {
                switch (check) {
                    case 1: {
                        float f = value = typeNeeded == 1 ? 2.0f : 0.0f;
                    }
                }
            }
            if (partType == 3) {
                switch (check) {
                    case 1: {
                        value = typeNeeded == 2 ? 0.2f : 0.0f;
                        break;
                    }
                    case 3: {
                        float f = value = typeNeeded == 0 ? 0.03f : 0.0f;
                    }
                }
            }
            if (partType != 4 || this.isTailUsable()) {
                // empty if block
            }
        }
        return value * amplifier;
    }

    public void getExpGained(int index) {
    }

    public void getWeaponDamage() {
    }

    public void getRangedDamage() {
    }

    public void getSpiritDefense() {
    }

    public double getSpeed() {
        float strFactor;
        float f = (float)this.getBleachStat(0) > 50.0f ? ((float)this.getBleachStat(0) <= 170.0f ? (float)this.getBleachStat(0) / 10.0f - 2.0f : 15.0f) : (strFactor = 1.0f);
        float reishiFactor = (float)this.getBleachStat(8) < 30.0f ? 1.0f : ((float)this.getBleachStat(8) <= 200.0f ? (float)this.getBleachStat(8) / 10.0f : 20.0f);
        float reiryokuFactor = (float)this.getMaxSpirit() * 0.1f * ((float)this.getBleachStat(8) / (float)ConfigHandler.statMax[8]);
        float agiFactor = (float)this.getBleachStat(1) / 10.0f * ((float)this.getBleachStat(1) / (float)ConfigHandler.statMax[1] + 1.0f) * 2.0f;
        double combo = (double)(strFactor + reishiFactor) * 0.001;
        double boost = (double)(agiFactor + reiryokuFactor) * 0.002;
        double spdMax = (double)ConfigHandler.spiritSpeedBoost * 0.01;
        return (boost > spdMax ? spdMax : boost) + combo;
    }

    public int getSpellCost() {
        int amount = 0;
        return amount;
    }

    public int getSpiritRecoveryAmount() {
        return 5;
    }

    public int getSpiritRecoverySpeed() {
        int baseReiryoku = this.getReiryoku(0);
        int baseType = this.getUnlockedPower(0);
        int endurance = this.bleachStats[3];
        float maxHealth = this.player.func_110138_aP();
        boolean foodFlag = this.player.func_71024_bL().func_75116_a() > 10;
        return 100;
    }

    public void getSPUseCost(int abilityID) {
    }

    public int getFlashStepDistance() {
        return 1;
    }

    public void chargeEnergy() {
    }

    public void getSpiritWeaponTime() {
    }

    public float getBonusHealth() {
        float healthMax;
        float endurFactor;
        int reiryokuCount = this.getMaxSpirit() / 250;
        float bonus = Math.round((float)reiryokuCount * ((endurFactor = (float)this.bleachStats[2] / (float)ConfigHandler.statMax[2]) + 1.0f));
        return bonus > (healthMax = (float)ConfigHandler.healthBonus) ? healthMax : bonus;
    }

    public void addStat(int index, int amount) {
        int n = index;
        this.bleachStats[n] = this.bleachStats[n] + amount;
        if (this.bleachStats[index] > ConfigHandler.statMax[index]) {
            this.bleachStats[index] = ConfigHandler.statMax[index];
        }
        this.upgradeCount += amount;
        this.checkForUpgrade();
    }

    public void checkForUpgrade() {
        if (this.upgradeCount > 30) {
            boolean flag = false;
            boolean shini = this.isShinigamiFac() && this.getBleachStat(4) > 50 && this.getBleachStat(7) > 20;
            boolean quincy = this.isQuincy() && this.getBleachStat(5) > 40 && this.getBleachStat(8) > 40;
            boolean hollow = this.isHollow() && this.getBleachStat(2) > 40 && this.getBleachStat(7) > 20;
            boolean arrancar = this.isArrancar() && this.getBleachStat(4) > 40 && this.getBleachStat(8) > 30;
            boolean bl = flag = shini || quincy || hollow || arrancar;
            if (flag) {
                int current = this.getAbilityLevel(2);
                this.setAbilityUnlock(2, current + 1);
                this.upgradeCount = 0;
            }
        }
    }

    public void addStatExp(int index, int amount) {
        amount *= this.debugEXPmultiply;
        int n = index;
        this.bleachExp[n] = this.bleachExp[n] + (amount *= ConfigHandler.statXPRate);
        if (this.bleachExp[index] < 0) {
            this.bleachExp[index] = 0;
        }
        if (this.bleachExp[index] > 20 + this.getBleachStat(index) * 40) {
            this.addStat(index, 1);
            this.bleachExp[index] = 0;
        }
    }

    public int getReiryoku(int index) {
        return this.reiryoku[index];
    }

    public void resetReiryoku() {
        this.reiryoku[0] = 5;
        this.reiryokuCreative[0] = 0;
        for (int i = 1; i < 4; ++i) {
            this.reiryoku[i] = 0;
            this.reiryokuCreative[i] = 0;
        }
        this.powerUpdate();
    }

    public void setReiryoku(int index, int amount) {
        this.reiryoku[index] = amount;
        this.reiryokuCreative[index] = 1;
        this.powerUpdate();
    }

    public void reduceReiryoku(int index, int amount) {
        int min;
        int n = index;
        this.reiryoku[n] = this.reiryoku[n] - amount;
        int n2 = min = index == 0 ? 5 : 0;
        if (this.reiryoku[index] < min) {
            this.reiryoku[index] = min;
        }
    }

    public void addReiryoku(int index, int amount) {
        int n = index;
        this.reiryoku[n] = this.reiryoku[n] + amount;
        int conMax = ConfigHandler.reiryokuMax;
        int conMaxBypass = ConfigHandler.reiryokuMaxBypass;
        if (conMax >= 0) {
            int max = this.getMaxReiryoku(index);
            if (conMax != 0) {
                int n2 = max = conMax > 100 ? conMax : 100;
                if (index != 0) {
                    max /= 4;
                }
            }
            if (this.reiryoku[index] > max) {
                if (this.reiryokuCreative[index] == 0 || conMaxBypass == 0) {
                    this.reiryoku[index] = max;
                } else if (conMaxBypass == 1) {
                    int n3 = index;
                    this.reiryoku[n3] = this.reiryoku[n3] - amount;
                }
            }
        } else if (index != 0 && this.reiryoku[index] > this.reiryoku[0] / 4) {
            if (this.reiryokuCreative[index] == 0 || conMaxBypass == 0) {
                this.reiryoku[index] = this.reiryoku[0] / 4;
            } else if (conMaxBypass == 1) {
                int n4 = index;
                this.reiryoku[n4] = this.reiryoku[n4] - amount;
            }
        }
        this.powerUpdate();
    }

    public int totalBaseReiryoku() {
        int sum = 0;
        for (int i = 0; i < 4; ++i) {
            sum += this.reiryoku[i];
        }
        return sum;
    }

    public int getMaxReiryoku(int index) {
        int base = 250;
        if (index == 0) {
            base = 100;
            switch (this.getFactionId()) {
                case 1: {
                    base = 100;
                    break;
                }
                case 2: {
                    base = this.UnlockedPower[2] == 1 ? 300 : (this.UnlockedPower[2] == 2 ? 550 : (this.UnlockedPower[2] == 3 ? 750 : (this.UnlockedPower[2] == 4 ? 1000 : (this.UnlockedPower[2] == 5 ? 1500 : base))));
                    break;
                }
                case 3: {
                    base = this.UnlockedPower[3] == 1 ? 400 : (this.UnlockedPower[3] == 2 ? 750 : 250);
                    break;
                }
                case 4: {
                    base = this.UnlockedPower[4] == 1 ? 150 : (this.UnlockedPower[4] == 2 ? 200 : (this.UnlockedPower[4] == 3 ? 300 : 250));
                    break;
                }
                case 5: {
                    base = 600;
                    break;
                }
                case 6: {
                    base = 900;
                    break;
                }
                case 7: {
                    base = this.UnlockedPower[3] == 1 ? 450 : 650;
                    break;
                }
                case 8: {
                    base = this.UnlockedPower[2] == 2 ? 550 : (this.UnlockedPower[2] == 3 ? 750 : (this.UnlockedPower[2] == 4 ? 1000 : 250));
                    break;
                }
                case 9: {
                    base = 500;
                    break;
                }
                case 10: {
                    base = 700;
                    break;
                }
                case 11: {
                    base = 1150;
                    break;
                }
                case 12: {
                    base = this.UnlockedPower[2] == 2 ? 1200 : 900;
                    break;
                }
                case 13: {
                    base = 2000;
                }
            }
            base += this.abilities[2] * 100;
        }
        if (index == 1) {
            int shiniLvl = this.UnlockedPower[2];
            base += shiniLvl * 70;
        }
        if (index == 2) {
            int quincyLvl = this.UnlockedPower[4];
            base += quincyLvl * 160;
        }
        if (index == 3) {
            int hollowLvl = this.UnlockedPower[3];
            base += hollowLvl * 90;
        }
        return base;
    }

    public void addBaseReiryoku(int amount) {
        this.addReiryoku(0, amount);
    }

    public void addShiniReiryoku(int amount) {
        this.addReiryoku(1, amount);
    }

    public void addQuincyReiryoku(int amount) {
        this.addReiryoku(2, amount);
    }

    public void addHollowReiryoku(int amount) {
        this.addReiryoku(3, amount);
    }

    public int setUsableMaxReiryoku() {
        int base = this.reiryoku[0];
        if (this.getUnlockedPower(0) == 2) {
            if (this.activePower[0] == 1) {
                base += this.reiryoku[1];
            }
            if (this.getUnlockedPower(2) >= 5) {
                return base *= 2;
            }
            if (this.getUnlockedPower(3) != 0 && this.activePower[2] == 1) {
                base += this.reiryoku[3];
            }
            if (this.getUnlockedPower(4) != 0 && this.activePower[0] != 0) {
                base += this.reiryoku[2] / 2;
            } else if (this.getUnlockedPower(4) >= 3 && this.activePower[0] == 0 && this.activePower[3] != 0) {
                base = (int)((double)base + (double)this.reiryoku[2] * 1.5);
            }
        }
        if (this.getUnlockedPower(0) == 3) {
            if (this.activePower[1] != 0) {
                base = (int)((double)base + (double)this.reiryoku[3] * 1.3);
            }
            if (this.activePower[1] == 2) {
                base = (int)((double)base * 1.5);
            }
        }
        if (this.getUnlockedPower(0) == 4) {
            base += this.reiryoku[2];
            if (this.activePower[3] != 0) {
                base *= 2;
                if (this.activePower[3] == 2) {
                    base = (int)((float)base * 1.25f);
                }
            }
        }
        if (this.getUnlockedPower(0) == 0 && this.activePower[4] != 0) {
            base += this.reiryoku[3] / 5;
            if (this.activePower[4] == 2) {
                base += this.reiryoku[3] / 2;
            }
        }
        return base;
    }
}

