/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.world;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class HuecoMundoChunkProvider
implements IChunkProvider {
    private Random rand;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    private World worldObj;
    private double[] noiseArray;
    private double[] stoneNoise = new double[256];
    private BiomeGenBase[] biomesForGeneration;
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] parabolicField;
    int[][] field_73219_j = new int[32][32];

    public HuecoMundoChunkProvider(World world, long seed, boolean features) {
        this.worldObj = world;
        this.rand = new Random(seed);
        this.noiseGen1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(this.rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        NoiseGeneratorOctaves[] noiseGens = new NoiseGeneratorOctaves[]{this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGen4, this.noiseGen5, this.noiseGen6, this.mobSpawnerNoise};
        noiseGens = (NoiseGeneratorOctaves[])TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.rand, (NoiseGenerator[])noiseGens);
        this.noiseGen1 = noiseGens[0];
        this.noiseGen2 = noiseGens[1];
        this.noiseGen3 = noiseGens[2];
        this.noiseGen4 = noiseGens[3];
        this.noiseGen5 = noiseGens[4];
        this.noiseGen6 = noiseGens[5];
        this.mobSpawnerNoise = noiseGens[6];
    }

    public void generateTerrain(int par1, int par2, Block[] chunk) {
        int subZ;
        double d16;
        double d15;
        double d14;
        int short1;
        int j2;
        int subX;
        double d13;
        double d12;
        double d11;
        double d10;
        double d9;
        int subY;
        double d8;
        double d7;
        double d6;
        double d5;
        double d4;
        double d3;
        double d2;
        double d1;
        double d0;
        int y;
        int z;
        int x;
        int miniChunk = 4;
        int chunkSize = 16;
        int seeLevel = 59;
        int k = miniChunk + 1;
        int b3 = 17;
        int l = miniChunk + 1;
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76937_a(this.biomesForGeneration, par1 * 4 - 2, par2 * 4 - 2, k + 5, l + 5);
        this.noiseArray = this.initializeNoiseField(this.noiseArray, par1 * miniChunk, 0, par2 * miniChunk, k, b3, l);
        for (x = 0; x < miniChunk; ++x) {
            for (z = 0; z < miniChunk; ++z) {
                for (y = 0; y < chunkSize; ++y) {
                    d0 = 0.125;
                    d1 = this.noiseArray[((x + 0) * l + z + 0) * b3 + y + 0];
                    d2 = this.noiseArray[((x + 0) * l + z + 1) * b3 + y + 0];
                    d3 = this.noiseArray[((x + 1) * l + z + 0) * b3 + y + 0];
                    d4 = this.noiseArray[((x + 1) * l + z + 1) * b3 + y + 0];
                    d5 = (this.noiseArray[((x + 0) * l + z + 0) * b3 + y + 1] - d1) * d0;
                    d6 = (this.noiseArray[((x + 0) * l + z + 1) * b3 + y + 1] - d2) * d0;
                    d7 = (this.noiseArray[((x + 1) * l + z + 0) * b3 + y + 1] - d3) * d0;
                    d8 = (this.noiseArray[((x + 1) * l + z + 1) * b3 + y + 1] - d4) * d0;
                    for (subY = 0; subY < 8; ++subY) {
                        d9 = 0.25;
                        d10 = d1;
                        d11 = d2;
                        d12 = (d3 - d1) * d9;
                        d13 = (d4 - d2) * d9;
                        for (subX = 0; subX < 4; ++subX) {
                            j2 = subX + x * 4 << 11 | 0 + z * 4 << 7 | y * 8 + subY;
                            short1 = 128;
                            j2 -= short1;
                            d14 = 0.25;
                            d15 = (d11 - d10) * d14;
                            d16 = d10 - d15;
                            for (subZ = 0; subZ < 4; ++subZ) {
                                double d;
                                d16 += d15;
                                chunk[j2 += short1] = d > 0.0 && y * 8 + subY >= seeLevel ? BleachBlocks.whitesand : Blocks.field_150350_a;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
        this.noiseArray = this.initializeNoiseFieldBottom(this.noiseArray, par1 * miniChunk, 0, par2 * miniChunk, k, b3, l);
        for (x = 0; x < miniChunk; ++x) {
            for (z = 0; z < miniChunk; ++z) {
                for (y = 0; y < chunkSize; ++y) {
                    d0 = 0.125;
                    d1 = this.noiseArray[((x + 0) * l + z + 0) * b3 + y + 0];
                    d2 = this.noiseArray[((x + 0) * l + z + 1) * b3 + y + 0];
                    d3 = this.noiseArray[((x + 1) * l + z + 0) * b3 + y + 0];
                    d4 = this.noiseArray[((x + 1) * l + z + 1) * b3 + y + 0];
                    d5 = (this.noiseArray[((x + 0) * l + z + 0) * b3 + y + 1] - d1) * d0;
                    d6 = (this.noiseArray[((x + 0) * l + z + 1) * b3 + y + 1] - d2) * d0;
                    d7 = (this.noiseArray[((x + 1) * l + z + 0) * b3 + y + 1] - d3) * d0;
                    d8 = (this.noiseArray[((x + 1) * l + z + 1) * b3 + y + 1] - d4) * d0;
                    for (subY = 0; subY < 8; ++subY) {
                        d9 = 0.25;
                        d10 = d1;
                        d11 = d2;
                        d12 = (d3 - d1) * d9;
                        d13 = (d4 - d2) * d9;
                        for (subX = 0; subX < 4; ++subX) {
                            j2 = subX + x * 4 << 11 | 0 + z * 4 << 7 | y * 8 + subY;
                            short1 = 128;
                            j2 -= short1;
                            d14 = 0.25;
                            d15 = (d11 - d10) * d14;
                            d16 = d10 - d15;
                            for (subZ = 0; subZ < 4; ++subZ) {
                                double d;
                                d16 += d15;
                                if (!(d < -25.0) || y * 8 + subY > 33) continue;
                                chunk[j2 += short1] = Blocks.field_150348_b;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, Block[] blocks, BiomeGenBase[] biomeArray) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this, par1, par2, blocks, biomeArray);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        int oceanLevel = 30;
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_76304_a(this.stoneNoise, par1 * 16, par2 * 16, 0, 16, 16, 1, d0 * 2.0, d0 * 2.0, d0 * 2.0);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeGenBase biomegenbase = biomeArray[z + x * 16];
                int i1 = (int)(this.stoneNoise[x + z * 16] / 3.0 + 3.0 + this.rand.nextDouble() * 0.25);
                int j1 = -1;
                Block b1 = biomegenbase.field_76752_A;
                Block b2 = biomegenbase.field_76753_B;
                for (int y = 127; y >= 0; --y) {
                    int index = (z * 16 + x) * 128 + y;
                    if (y <= 0) {
                        blocks[index] = Blocks.field_150357_h;
                        continue;
                    }
                    Block b3 = blocks[index];
                    if (b3 == Blocks.field_150350_a) {
                        j1 = -1;
                        continue;
                    }
                    if (b3 != Blocks.field_150348_b) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            b1 = Blocks.field_150350_a;
                            b2 = Blocks.field_150348_b;
                        } else if (y >= oceanLevel - 4 && y <= oceanLevel + 1) {
                            b1 = biomegenbase.field_76752_A;
                            b2 = biomegenbase.field_76753_B;
                        }
                        j1 = i1;
                        blocks[index] = b2;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    blocks[index] = b2;
                }
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public Chunk func_73154_d(int par1, int par2) {
        this.rand.setSeed((long)par1 * 341873128712L + (long)par2 * 132897987541L);
        Block[] ablock = new Block[32768];
        this.generateTerrain(par1, par2, ablock);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, par1 * 16, par2 * 16, 16, 16);
        this.replaceBlocksForBiome(par1, par2, ablock, this.biomesForGeneration);
        Chunk chunk = new Chunk(this.worldObj, ablock, par1, par2);
        byte[] abyte1 = chunk.func_76605_m();
        for (int k = 0; k < abyte1.length; ++k) {
            abyte1[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    private double[] initializeNoiseField(double[] par1ArrayOfDouble, int par2, int par3, int par4, int par5, int par6, int par7) {
        ChunkProviderEvent.InitNoiseField event = new ChunkProviderEvent.InitNoiseField((IChunkProvider)this, par1ArrayOfDouble, par2, par3, par4, par5, par6, par7);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.noisefield;
        }
        if (par1ArrayOfDouble == null) {
            par1ArrayOfDouble = new double[par5 * par6 * par7];
        }
        if (this.parabolicField == null) {
            this.parabolicField = new float[25];
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    float f;
                    this.parabolicField[k1 + 2 + (l1 + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(k1 * k1 + l1 * l1) + 0.2f));
                }
            }
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.noise5 = this.noiseGen5.func_76305_a(this.noise5, par2, par4, par5, par7, 1.121, 1.121, 0.5);
        this.noise6 = this.noiseGen6.func_76305_a(this.noise6, par2, par4, par5, par7, 200.0, 200.0, 0.5);
        this.noise3 = this.noiseGen3.func_76304_a(this.noise3, par2, par3, par4, par5, par6, par7, d0 / 80.0, d1 / 160.0, d0 / 80.0);
        this.noise1 = this.noiseGen1.func_76304_a(this.noise1, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        this.noise2 = this.noiseGen2.func_76304_a(this.noise2, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        boolean flag = false;
        boolean flag1 = false;
        int i2 = 0;
        int j2 = 0;
        for (int k2 = 0; k2 < par5; ++k2) {
            for (int l2 = 0; l2 < par7; ++l2) {
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int b0 = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[k2 + 2 + (l2 + 2) * (par5 + 5)];
                for (int i3 = -b0; i3 <= b0; ++i3) {
                    for (int j3 = -b0; j3 <= b0; ++j3) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[k2 + i3 + 2 + (l2 + j3 + 2) * (par5 + 5)];
                        float f4 = this.parabolicField[i3 + 2 + (j3 + 2) * 5] / (biomegenbase1.field_76748_D + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f4 /= 2.0f;
                        }
                        f1 += biomegenbase1.field_76748_D * f4;
                        f2 += biomegenbase1.field_76748_D * f4;
                        f3 += f4;
                    }
                }
                f1 /= f3;
                f2 /= f3;
                f1 = f1 * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d2 = this.noise6[j2] / 8000.0;
                if (d2 < 0.0) {
                    d2 = -d2 * 0.3;
                }
                if ((d2 = d2 * 3.0 - 2.0) < 0.0) {
                    if ((d2 /= 2.0) < -1.0) {
                        d2 = -1.0;
                    }
                    d2 /= 1.4;
                    d2 /= 2.0;
                } else {
                    if (d2 > 1.0) {
                        d2 = 1.0;
                    }
                    d2 /= 8.0;
                }
                ++j2;
                for (int k3 = 0; k3 < par6; ++k3) {
                    double d3 = f2;
                    double d4 = f1;
                    d3 += d2 * 0.2;
                    d3 = d3 * (double)par6 / 16.0;
                    double d5 = (double)par6 / 2.0 + d3 * 4.0;
                    double d6 = 0.0;
                    double d7 = ((double)k3 - d5) * 12.0 * 128.0 / 128.0 / d4;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.noise1[i2] / 512.0;
                    double d9 = this.noise2[i2] / 512.0;
                    double d10 = (this.noise3[i2] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k3 > par6 - 4) {
                        double d11 = (float)(k3 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    par1ArrayOfDouble[i2] = d6;
                    ++i2;
                }
            }
        }
        return par1ArrayOfDouble;
    }

    private double[] initializeNoiseFieldBottom(double[] noiseField, int par2, int par3, int par4, int par5, int par6, int par7) {
        ChunkProviderEvent.InitNoiseField event = new ChunkProviderEvent.InitNoiseField((IChunkProvider)this, noiseField, par2, par3, par4, par5, par6, par7);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.noisefield;
        }
        if (noiseField == null) {
            noiseField = new double[par5 * par6 * par7];
        }
        if (this.parabolicField == null) {
            this.parabolicField = new float[25];
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -2; l1 <= 2; ++l1) {
                    float f;
                    this.parabolicField[k1 + 2 + (l1 + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(k1 * k1 + l1 * l1) + 0.2f));
                }
            }
        }
        double d0 = 684.412;
        double d1 = 684.412;
        this.noise5 = this.noiseGen5.func_76305_a(this.noise5, par2, par4, par5, par7, 1.121, 1.121, 0.5);
        this.noise6 = this.noiseGen6.func_76305_a(this.noise6, par2, par4, par5, par7, 200.0, 200.0, 0.5);
        this.noise3 = this.noiseGen3.func_76304_a(this.noise3, par2, par3, par4, par5, par6, par7, d0 / 80.0, d1 / 160.0, d0 / 80.0);
        this.noise1 = this.noiseGen1.func_76304_a(this.noise1, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        this.noise2 = this.noiseGen2.func_76304_a(this.noise2, par2, par3, par4, par5, par6, par7, d0, d1, d0);
        boolean flag = false;
        boolean flag1 = false;
        int i2 = 0;
        int j2 = 0;
        float minHeight = -1.1f;
        float maxHeight = -1.0f;
        for (int k2 = 0; k2 < par5; ++k2) {
            for (int l2 = 0; l2 < par7; ++l2) {
                float f1 = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                int b0 = 2;
                for (int i3 = -b0; i3 <= b0; ++i3) {
                    for (int j3 = -b0; j3 <= b0; ++j3) {
                        float f4 = this.parabolicField[i3 + 2 + (j3 + 2) * 5] / (minHeight + 2.0f);
                        if (minHeight > minHeight) {
                            f4 /= 2.0f;
                        }
                        f1 += maxHeight * f4;
                        f2 += minHeight * f4;
                        f3 += f4;
                    }
                }
                f1 /= f3;
                f2 /= f3;
                f1 = f1 * 0.9f + 0.1f;
                f2 = (f2 * 4.0f - 1.0f) / 8.0f;
                double d2 = this.noise6[j2] / 8000.0;
                if (d2 < 0.0) {
                    d2 = -d2 * 0.3;
                }
                if ((d2 = d2 * 3.0 - 2.0) < 0.0) {
                    if ((d2 /= 2.0) < -1.0) {
                        d2 = -1.0;
                    }
                    d2 /= 1.4;
                    d2 /= 2.0;
                } else {
                    if (d2 > 1.0) {
                        d2 = 1.0;
                    }
                    d2 /= 8.0;
                }
                ++j2;
                for (int k3 = 0; k3 < par6; ++k3) {
                    double d3 = f2;
                    double d4 = f1;
                    d3 += d2 * 0.2;
                    d3 = d3 * (double)par6 / 16.0;
                    double d5 = (double)par6 / 2.0 + d3 * 4.0;
                    double d6 = 0.0;
                    double d7 = ((double)k3 - d5) * 12.0 * 128.0 / 128.0 / d4;
                    if (d7 < 0.0) {
                        d7 *= 4.0;
                    }
                    double d8 = this.noise1[i2] / 512.0;
                    double d9 = this.noise2[i2] / 512.0;
                    double d10 = (this.noise3[i2] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (k3 > par6 - 4) {
                        double d11 = (float)(k3 - (par6 - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    noiseField[i2] = d6;
                    ++i2;
                }
            }
        }
        return noiseField;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int chunkX, int chunkZ) {
        BlockSand.field_149832_M = true;
        int k = chunkX * 16;
        int l = chunkZ * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(k + 16, l + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(par1IChunkProvider, this.worldObj, this.rand, chunkX, chunkZ, flag));
        biomegenbase.func_76728_a(this.worldObj, this.rand, k, l);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomegenbase, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(par1IChunkProvider, this.worldObj, this.rand, chunkX, chunkZ, flag));
        BlockSand.field_149832_M = false;
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "HuecoMundoChunkProvider";
    }

    public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(p_73155_2_, p_73155_4_);
        return biomegenbase.func_76747_a(p_73155_1_);
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
    }

    public ChunkPosition func_147416_a(World var1, String var2, int var3, int var4, int var5) {
        return null;
    }
}

