/*
 * Decompiled with CFR 0.152.
 */
package littlebreadloaf.bleach_kd.world.gen;

import java.util.Random;
import littlebreadloaf.bleach_kd.ConfigHandler;
import littlebreadloaf.bleach_kd.blocks.BleachBlocks;
import littlebreadloaf.bleach_kd.world.biomes.BleachBiomes;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BleachGenHuecoStone
extends WorldGenerator {
    public boolean func_76484_a(World world, Random rand, int i, int j, int k) {
        if (world.func_72807_a(i, k) != BleachBiomes.HuecoMundo) {
            return false;
        }
        int topBlock = world.func_72825_h(i, k);
        Block blockTop = world.func_147439_a(i, topBlock, k);
        if (topBlock < 58 || blockTop != BleachBlocks.whitesand || blockTop != BleachBlocks.soulQuartzBlock) {
            return false;
        }
        int stoneHeight = rand.nextInt(7);
        int radiusMax = rand.nextInt(2) + 2;
        float radiusMin = 0.2f;
        for (int y = 0; y < stoneHeight; ++y) {
            for (int x = -radiusMax; x <= radiusMax; ++x) {
                for (int z = -radiusMax; z <= radiusMax; ++z) {
                    float lerp = 1.0f - (float)y / (float)topBlock;
                    float radius = (int)this.lerp(radiusMin, radiusMax, lerp);
                    if (y > 3 && (float)y - radius > 2.0f) {
                        radius -= 1.0f;
                    }
                    if (!(Math.sqrt(z * z + x * x) <= (double)radius)) continue;
                    world.func_147449_b(x + i, y + topBlock, z + k, Blocks.field_150348_b);
                }
            }
        }
        if (ConfigHandler.generateHuecoStone) {
            world.func_147449_b(i, topBlock, k, BleachBlocks.huecoStone);
        }
        return true;
    }

    float lerp(float v0, float v1, float t) {
        return v0 + (v1 - v0) * t;
    }
}

