/*
 * Decompiled with CFR 0.152.
 */
package radixcore.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;

public abstract class AbstractPacketHandler {
    protected SimpleNetworkWrapper wrapper;
    private int idCounter;

    public AbstractPacketHandler(String modId) {
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(modId);
        this.registerPackets();
    }

    public abstract void registerPackets();

    protected void registerPacket(Class packetClass, Side processorSide) {
        this.wrapper.registerMessage(packetClass, packetClass, this.idCounter, processorSide);
        ++this.idCounter;
    }

    public void sendPacketToAllPlayers(IMessage packet) {
        this.wrapper.sendToAll(packet);
    }

    public void sendPacketToAllPlayersExcept(IMessage packet, EntityPlayerMP player) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        ServerConfigurationManager serverConfiguration = server.func_71203_ab();
        for (int index = 0; index < serverConfiguration.field_72404_b.size(); ++index) {
            EntityPlayerMP playerInList = (EntityPlayerMP)serverConfiguration.field_72404_b.get(index);
            if (playerInList.func_70005_c_().equals(player.func_70005_c_())) continue;
            this.wrapper.sendTo(packet, playerInList);
        }
    }

    public void sendPacketToPlayer(IMessage packet, EntityPlayerMP player) {
        if (player != null) {
            this.wrapper.sendTo(packet, player);
        }
    }

    public void sendPacketToAllAround(IMessage packet, NetworkRegistry.TargetPoint point) {
        this.wrapper.sendToAllAround(packet, point);
    }

    public void sendPacketToDimension(IMessage packet, int dimensionId) {
        this.wrapper.sendToDimension(packet, dimensionId);
    }

    public void sendPacketToServer(IMessage packet) {
        this.wrapper.sendToServer(packet);
    }
}

