/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.client.gui;

import java.util.ArrayList;
import net.meteor.client.gui.GuiButtonFreezerRecipeMode;
import net.meteor.common.FreezerRecipes;
import net.meteor.common.block.container.ContainerFreezingMachine;
import net.meteor.common.tileentity.TileEntityFreezingMachine;
import net.meteor.common.util.Util;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.opengl.GL11;

public class GuiFreezingMachine
extends GuiContainer {
    public static final ResourceLocation freezingMachineTextures = new ResourceLocation("meteors", "textures/gui/container/freezing_machine.png");
    private TileEntityFreezingMachine freezer;
    private int fluidAmount = 0;
    private String fluidName;

    public GuiFreezingMachine(InventoryPlayer playerInv, TileEntityFreezingMachine freezer) {
        super((Container)new ContainerFreezingMachine(playerInv, freezer));
        this.freezer = freezer;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiButtonFreezerRecipeMode(0, this.field_147003_i + 149, this.field_147009_r + 60, 20, 20, this.freezer, this));
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(freezingMachineTextures);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        FluidTankInfo tankInfo = this.freezer.getTankInfo();
        FluidStack fluidStack = tankInfo.fluid;
        if (fluidStack != null && fluidStack.amount > 0) {
            this.fluidAmount = fluidStack.amount;
            Fluid fluid = FluidRegistry.getFluid((int)fluidStack.fluidID);
            if (fluid != null) {
                this.fluidName = fluid.getLocalizedName(fluidStack);
                IIcon icon = fluid.getIcon();
                int height = (int)((double)this.fluidAmount / (double)tankInfo.capacity * 69.0);
                int drawnHeight = 0;
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                for (int i = height / 16; i >= 0; --i) {
                    if (i > 0) {
                        this.func_94065_a(k + 13, l + 76 - 16 - drawnHeight, icon, 20, 16);
                        drawnHeight += 16;
                    } else {
                        this.func_94065_a(k + 13, l + 76 - drawnHeight - height, icon, 20, height);
                    }
                    height -= 16;
                }
            }
        } else if (this.fluidAmount > 0) {
            this.fluidAmount = 0;
            this.fluidName = "";
        }
        this.field_146297_k.func_110434_K().func_110577_a(freezingMachineTextures);
        this.func_73729_b(k + 13, l + 7, 176, 31, 20, 69);
        if (this.freezer.isFreezing()) {
            int i1 = this.freezer.getBurnTimeRemainingScaled(13);
            this.func_73729_b(k + 73, l + 36 + 12 - i1, 176, 12 - i1, 14, i1 + 2);
            i1 = this.freezer.getCookProgressScaled(24);
            this.func_73729_b(k + 96, l + 34, 176, 14, i1 + 1, 16);
        }
    }

    protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
        ArrayList<String> info;
        if (this.func_146978_c(13, 7, 20, 69, p_146979_1_, p_146979_2_)) {
            info = new ArrayList<String>();
            if (this.fluidName != null && !this.fluidName.isEmpty()) {
                info.add(this.fluidName);
            }
            info.add(this.fluidAmount + " / 10000 mB");
            this.func_146283_a(info, p_146979_1_ - this.field_147003_i, p_146979_2_ - this.field_147009_r);
        }
        if (this.func_146978_c(149, 60, 20, 20, p_146979_1_, p_146979_2_)) {
            info = new ArrayList();
            FreezerRecipes.RecipeType type = this.freezer.getRecipeMode();
            if (type == FreezerRecipes.RecipeType.item) {
                info.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"info.freezer.itemMode"));
                info.addAll(Util.getFormattedLines("info.freezer.itemMode.desc", EnumChatFormatting.WHITE));
            } else if (type == FreezerRecipes.RecipeType.fluid) {
                info.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"info.freezer.fluidMode"));
                info.addAll(Util.getFormattedLines("info.freezer.fluidMode.desc", EnumChatFormatting.WHITE));
            } else if (type == FreezerRecipes.RecipeType.both) {
                info.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"info.freezer.bothMode"));
                info.addAll(Util.getFormattedLines("info.freezer.bothMode.desc", EnumChatFormatting.WHITE));
            } else if (type == FreezerRecipes.RecipeType.either) {
                info.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"info.freezer.eitherMode"));
                info.addAll(Util.getFormattedLines("info.freezer.eitherMode.desc", EnumChatFormatting.WHITE));
            }
            this.func_146283_a(info, p_146979_1_ - this.field_147003_i, p_146979_2_ - this.field_147009_r);
        }
        String s = StatCollector.func_74838_a((String)"tile.freezingMachine.name");
        int i = this.field_146289_q.func_78256_a(s);
        this.field_146289_q.func_85187_a(s, 168 - i, 6, 0x404040, false);
    }

    protected void func_146284_a(GuiButton button) {
        this.freezer.pressButton(button.field_146127_k);
    }
}

