/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.meteor.common.MeteorsMod;
import net.meteor.common.climate.CrashLocation;
import net.meteor.common.climate.HandlerMeteor;
import net.meteor.common.packets.PacketBlockedMeteor;
import net.meteor.common.packets.PacketButtonPress;
import net.meteor.common.packets.PacketGhostMeteor;
import net.meteor.common.packets.PacketLastCrash;
import net.meteor.common.packets.PacketSettings;
import net.meteor.common.packets.PacketSoonestMeteor;
import net.meteor.plugin.baubles.Baubles;
import net.meteor.plugin.baubles.PacketToggleMagnetism;
import net.meteor.plugin.baubles.PacketTogglePlayerMagnetism;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class ClientHandler {
    public static CrashLocation lastCrashLocation = null;
    public static ChunkCoordinates nearestTimeLocation = null;
    public static ArrayList<ChunkCoordinates> ghostMetLocs = new ArrayList();

    public void registerPackets() {
        MeteorsMod.network.registerMessage(PacketBlockedMeteor.Handler.class, PacketBlockedMeteor.class, 0, Side.CLIENT);
        MeteorsMod.network.registerMessage(PacketButtonPress.Handler.class, PacketButtonPress.class, 1, Side.SERVER);
        MeteorsMod.network.registerMessage(PacketGhostMeteor.Handler.class, PacketGhostMeteor.class, 2, Side.CLIENT);
        MeteorsMod.network.registerMessage(PacketLastCrash.Handler.class, PacketLastCrash.class, 3, Side.CLIENT);
        MeteorsMod.network.registerMessage(PacketSettings.Handler.class, PacketSettings.class, 4, Side.CLIENT);
        MeteorsMod.network.registerMessage(PacketSoonestMeteor.Handler.class, PacketSoonestMeteor.class, 5, Side.CLIENT);
        if (Baubles.isBaublesLoaded()) {
            MeteorsMod.network.registerMessage(PacketToggleMagnetism.Handler.class, PacketToggleMagnetism.class, 6, Side.SERVER);
            MeteorsMod.network.registerMessage(PacketTogglePlayerMagnetism.Handler.class, PacketTogglePlayerMagnetism.class, 7, Side.CLIENT);
        }
    }

    public static ChunkCoordinates getClosestIncomingMeteor(double pX, double pZ) {
        ChunkCoordinates coords = null;
        double y = 50.0;
        for (int i = 0; i < ghostMetLocs.size(); ++i) {
            if (coords != null) {
                double var2;
                ChunkCoordinates loc = ghostMetLocs.get(i);
                double var1 = ClientHandler.getDistance(pX, y, pZ, loc.field_71574_a, y, loc.field_71573_c);
                if (!(var1 < (var2 = ClientHandler.getDistance(pX, y, pZ, coords.field_71574_a, y, coords.field_71573_c)))) continue;
                coords = loc;
                continue;
            }
            coords = ghostMetLocs.get(i);
        }
        return coords;
    }

    private static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double var7 = x1 - x2;
        double var9 = y1 - y2;
        double var11 = z1 - z2;
        return MathHelper.func_76133_a((double)(var7 * var7 + var9 * var9 + var11 * var11));
    }

    public static IChatComponent createMessage(String s, EnumChatFormatting ecf) {
        return new ChatComponentText(s).func_150255_a(new ChatStyle().func_150238_a(ecf));
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        MeteorsMod.network.sendTo((IMessage)new PacketSettings(), player);
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && event.entity instanceof EntityPlayer) {
            EntityPlayerMP player = (EntityPlayerMP)event.entity;
            HandlerMeteor metHandler = MeteorsMod.proxy.metHandlers.get(event.world.field_73011_w.field_76574_g);
            MeteorsMod.network.sendTo((IMessage)new PacketGhostMeteor(), player);
            metHandler.sendGhostMeteorPackets(player);
            if (metHandler.getForecast() == null) {
                MeteorsMod.log.info("FORECAST WAS NULL");
            }
            MeteorsMod.network.sendTo((IMessage)new PacketLastCrash(metHandler.getForecast().getLastCrashLocation()), player);
            MeteorsMod.network.sendTo((IMessage)new PacketSoonestMeteor(metHandler.getForecast().getNearestTimeMeteor()), player);
        }
    }
}

