/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.meteor.common.MeteorBlocks;
import net.meteor.common.MeteorItems;
import net.meteor.common.MeteorsMod;
import net.meteor.common.block.BlockSlippery;
import net.meteor.common.block.BlockSlipperyStairs;
import net.meteor.common.tileentity.TileEntitySlippery;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FreezerRecipes {
    private static FreezerRecipes theInstance = new FreezerRecipes();
    private List<FreezerRecipe> recipes = new ArrayList<FreezerRecipe>();
    private Set<Item> neededItems = new HashSet<Item>();

    public static FreezerRecipes instance() {
        return theInstance;
    }

    private FreezerRecipes() {
        this.addRecipe(new ItemStack(Blocks.field_150432_aD, 1), FluidRegistry.WATER, 1000, new ItemStack(Blocks.field_150403_cj, 1));
        this.addRecipe(Items.field_151042_j, new ItemStack(MeteorItems.FrozenIron, 1));
        this.addRecipe(new SlipperyRecipe());
        this.addRecipe(FluidRegistry.WATER, 1000, new ItemStack(Blocks.field_150432_aD, 1));
        this.addRecipe(FluidRegistry.LAVA, 1000, new ItemStack(Blocks.field_150343_Z, 1));
    }

    public void addRecipe(Block block, ItemStack result) {
        this.addRecipe(Item.func_150898_a((Block)block), result);
    }

    public void addRecipe(Item item, ItemStack result) {
        this.addRecipe(new ItemStack(item, 1), result);
    }

    public void addRecipe(ItemStack need, ItemStack result) {
        this.recipes.add(new FreezerRecipe(need, result));
        this.neededItems.add(need.func_77973_b());
    }

    public void addRecipe(Fluid fluid, int fluidAmount, ItemStack result) {
        this.recipes.add(new FreezerRecipe(fluid, fluidAmount, result));
    }

    public void addRecipe(ItemStack need, Fluid fluid, int fluidAmount, ItemStack result) {
        this.recipes.add(new FreezerRecipe(need, fluid, fluidAmount, result));
        this.neededItems.add(need.func_77973_b());
    }

    public void addRecipe(FreezerRecipe recipe) {
        this.recipes.add(recipe);
        if (recipe.requiresItem() && !(recipe instanceof SlipperyRecipe)) {
            this.neededItems.add(recipe.getItemStack().func_77973_b());
        }
    }

    private boolean canUseRecipe(FreezerRecipe recipe, RecipeType typeAvailable) {
        if (typeAvailable != RecipeType.either) {
            return recipe.getRecipeType() == typeAvailable;
        }
        return true;
    }

    public FreezerRecipe getFreezingResult(ItemStack item, FluidStack fluidStack, RecipeType typeAvailable) {
        for (FreezerRecipe recipe : this.recipes) {
            if (!this.canUseRecipe(recipe, typeAvailable) || !(fluidStack != null ? recipe.hasRequiredMaterials(item, fluidStack.getFluid(), fluidStack.amount) : recipe.hasRequiredMaterials(item, null, 0))) continue;
            return recipe;
        }
        return null;
    }

    public boolean isRequiredItem(ItemStack item) {
        return item != null && this.neededItems.contains(item.func_77973_b());
    }

    public static boolean isFreezableItem(ItemStack item) {
        if (MeteorsMod.instance.slipperyBlocksEnabled && item != null && item.func_77973_b() instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)item.func_77973_b();
            Block block = itemBlock.field_150939_a;
            return BlockSlippery.canBeSlippery(block);
        }
        return false;
    }

    public class SlipperyRecipe
    extends FreezerRecipe {
        public SlipperyRecipe() {
            super(FluidRegistry.WATER, 250, null);
            this.setRecipeType(RecipeType.both);
        }

        @Override
        public boolean requiresItem() {
            return true;
        }

        @Override
        public ItemStack getResult(ItemStack neededItem) {
            ItemBlock itemBlock = (ItemBlock)neededItem.func_77973_b();
            Block block = itemBlock.field_150939_a;
            ItemStack res = new ItemStack(MeteorBlocks.blockSlippery, 1, neededItem.func_77960_j());
            if (block instanceof BlockSlippery) {
                if (block.field_149765_K == 0.98f) {
                    res = new ItemStack(MeteorBlocks.blockSlipperyTwo, 1, neededItem.func_77960_j());
                } else if (block.field_149765_K == 1.03f) {
                    res = new ItemStack(MeteorBlocks.blockSlipperyThree, 1, neededItem.func_77960_j());
                } else if (block.field_149765_K == 1.07f) {
                    res = new ItemStack(MeteorBlocks.blockSlipperyFour, 1, neededItem.func_77960_j());
                }
                NBTTagCompound nbt = res.func_77942_o() ? res.func_77978_p() : new NBTTagCompound();
                nbt.func_74778_a("slipFacadeBlock", neededItem.func_77978_p().func_74779_i("slipFacadeBlock"));
                res.func_77982_d(nbt);
                return res;
            }
            if (block instanceof BlockSlipperyStairs) {
                if (block.field_149765_K == 0.98f) {
                    res = new ItemStack(MeteorBlocks.blockSlipperyStairsTwo, 1, neededItem.func_77960_j());
                } else if (block.field_149765_K == 1.03f) {
                    res = new ItemStack(MeteorBlocks.blockSlipperyStairsThree, 1, neededItem.func_77960_j());
                } else if (block.field_149765_K == 1.07f) {
                    res = new ItemStack(MeteorBlocks.blockSlipperyStairsFour, 1, neededItem.func_77960_j());
                }
                NBTTagCompound nbt = res.func_77942_o() ? res.func_77978_p() : new NBTTagCompound();
                nbt.func_74778_a("slipFacadeBlock", neededItem.func_77978_p().func_74779_i("slipFacadeBlock"));
                res.func_77982_d(nbt);
                return res;
            }
            if (block.func_149645_b() == 10) {
                res = new ItemStack(MeteorBlocks.blockSlipperyStairs, 1, neededItem.func_77960_j());
            }
            NBTTagCompound nbt = res.func_77942_o() ? res.func_77978_p() : new NBTTagCompound();
            nbt.func_74778_a("slipFacadeBlock", TileEntitySlippery.getNameFromBlock(block));
            res.func_77982_d(nbt);
            return res;
        }

        @Override
        public boolean hasRequiredMaterials(ItemStack item, Fluid fluid, int fluidAmount) {
            if (fluidAmount >= this.fluidAmountNeeded && this.fluid == fluid) {
                return FreezerRecipes.isFreezableItem(item);
            }
            return false;
        }
    }

    public class FreezerRecipe {
        protected Fluid fluid;
        protected int fluidAmountNeeded;
        protected ItemStack itemNeeded;
        protected ItemStack result;
        protected RecipeType type = RecipeType.both;

        public FreezerRecipe(ItemStack item, Fluid fluid, int fluidAmount, ItemStack result) {
            this.itemNeeded = item;
            this.fluid = fluid;
            this.fluidAmountNeeded = fluidAmount;
            this.result = result;
        }

        public FreezerRecipe(ItemStack item, ItemStack result) {
            this(item, null, 0, result);
            this.setRecipeType(RecipeType.item);
        }

        public FreezerRecipe(Fluid fluid, int fluidAmount, ItemStack result) {
            this(null, fluid, fluidAmount, result);
            this.setRecipeType(RecipeType.fluid);
        }

        public FreezerRecipe setRecipeType(RecipeType type) {
            this.type = type;
            return this;
        }

        public RecipeType getRecipeType() {
            return this.type;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public int getFluidAmount() {
            return this.fluidAmountNeeded;
        }

        public ItemStack getItemStack() {
            return this.itemNeeded;
        }

        public ItemStack getResult(ItemStack neededItem) {
            return this.result;
        }

        public boolean requiresFluid() {
            return this.fluid != null;
        }

        public boolean requiresItem() {
            return this.itemNeeded != null;
        }

        public boolean hasRequiredMaterials(ItemStack item, Fluid fluid, int fluidAmount) {
            if (fluidAmount >= this.fluidAmountNeeded) {
                if (this.requiresFluid() && this.fluid == fluid) {
                    return this.requiresItem() ? (item != null ? this.itemNeeded.func_77969_a(item) : false) : true;
                }
                if (this.requiresItem() && item != null) {
                    return this.itemNeeded.func_77969_a(item);
                }
            }
            return false;
        }
    }

    public static enum RecipeType {
        item(0),
        fluid(1),
        both(2),
        either(3);

        private int id;

        private RecipeType(int id) {
            this.id = id;
        }

        public int getID() {
            return this.id;
        }
    }
}

