/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.Random;
import net.meteor.common.ClientHandler;
import net.meteor.common.CommonProxy;
import net.meteor.common.CreativeTabMeteor;
import net.meteor.common.EnumMeteor;
import net.meteor.common.HandlerAchievement;
import net.meteor.common.HandlerGui;
import net.meteor.common.HandlerPlayerBreakSpeed;
import net.meteor.common.HandlerPlayerTick;
import net.meteor.common.HandlerRecipe;
import net.meteor.common.MeteorBlocks;
import net.meteor.common.MeteorItems;
import net.meteor.common.ModConfig;
import net.meteor.common.TooltipProvider;
import net.meteor.common.climate.HandlerMeteor;
import net.meteor.common.climate.HandlerWorld;
import net.meteor.common.command.CommandDebugMeteors;
import net.meteor.common.command.CommandDebugShields;
import net.meteor.common.command.CommandKittyAttack;
import net.meteor.common.command.CommandSpawnComet;
import net.meteor.common.command.CommandSpawnMeteor;
import net.meteor.common.enchantment.EnchantmentColdTouch;
import net.meteor.common.enchantment.EnchantmentMagnetized;
import net.meteor.common.entity.EntityAlienCreeper;
import net.meteor.common.entity.EntityComet;
import net.meteor.common.entity.EntityCometKitty;
import net.meteor.common.entity.EntityMeteor;
import net.meteor.common.entity.EntitySummoner;
import net.meteor.plugin.baubles.Baubles;
import net.meteor.plugin.thaumcraft.Thaumcraft;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

@Mod(modid="meteors", name="Falling Meteors", version="2.14.3", dependencies="after:Waila;after:Baubles;after:Thaumcraft")
public class MeteorsMod
implements IWorldGenerator {
    public static final String MOD_ID = "meteors";
    public static final String MOD_NAME = "Falling Meteors";
    public static final String VERSION = "2.14.3";
    public static final boolean loggable = false;
    public static Logger log;
    public static SimpleNetworkWrapper network;
    public static Enchantment Magnetization;
    public static Enchantment ColdTouch;
    public static final CreativeTabs meteorTab;
    @SidedProxy(clientSide="net.meteor.common.ClientProxy", serverSide="net.meteor.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="meteors")
    public static MeteorsMod instance;
    public HandlerAchievement achHandler;
    public HandlerPlayerTick playerTickHandler;
    public int MinTicksUntilMeteorSpawn;
    public int RandTicksUntilMeteorSpawn;
    public int MinTicksUntilMeteorCrashes;
    public int RandTicksUntilMeteorCrashes;
    public boolean meteorsFallOnlyAtNight;
    public boolean allowSummonedMeteorGrief = false;
    public int meteorFallDistance;
    public int MaxMeteorSize;
    public int MinMeteorSize;
    public int ShieldRadiusMultiplier;
    public int kittyAttackChance;
    public boolean textNotifyCrash;
    public boolean meteoriteEnabled;
    public boolean frezariteEnabled;
    public boolean kreknoriteEnabled;
    public boolean unknownEnabled;
    public boolean meteorShieldSound;
    private int chunkChecks;
    private int oreGenSize;
    public int MinMeteorSizeForPortal;
    public double ImpactExplosionMultiplier;
    public int ImpactSpread;
    public int cometFallChance;
    public int[] whitelistedDimensions;
    public boolean slipperyBlocksEnabled;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        ModConfig.instance.load(event.getSuggestedConfigurationFile());
        this.loadStaticConfigurationValues();
        MeteorBlocks.registerBlocks();
        MeteorItems.registerItems();
        MeteorItems.readyItems();
        this.loadPlugins();
        HandlerMeteor.defaultType = EnumMeteor.METEORITE;
        if (!this.meteoriteEnabled) {
            HandlerMeteor.defaultType = EnumMeteor.FREZARITE;
            if (!this.frezariteEnabled) {
                HandlerMeteor.defaultType = EnumMeteor.KREKNORITE;
                if (!this.kreknoriteEnabled) {
                    HandlerMeteor.defaultType = EnumMeteor.UNKNOWN;
                    if (!this.unknownEnabled) {
                        HandlerMeteor.defaultType = EnumMeteor.METEORITE;
                    }
                }
            }
        }
        this.achHandler = new HandlerAchievement();
        network = NetworkRegistry.INSTANCE.newSimpleChannel("METEORS");
        ClientHandler cHandler = new ClientHandler();
        cHandler.registerPackets();
        MinecraftForge.EVENT_BUS.register((Object)cHandler);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerEntities();
        HandlerRecipe recipeHandler = new HandlerRecipe();
        recipeHandler.addRecipes();
        this.playerTickHandler = new HandlerPlayerTick();
        this.achHandler.readyAchievements();
        proxy.loadStuff();
        MinecraftForge.EVENT_BUS.register((Object)new HandlerPlayerBreakSpeed());
        MinecraftForge.EVENT_BUS.register((Object)new HandlerWorld());
        MinecraftForge.EVENT_BUS.register((Object)new TooltipProvider());
        FMLCommonHandler.instance().bus().register((Object)recipeHandler);
        FMLCommonHandler.instance().bus().register((Object)this.achHandler);
        GameRegistry.registerFuelHandler((IFuelHandler)recipeHandler);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)1);
        FMLCommonHandler.instance().bus().register((Object)new HandlerPlayerTick());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new HandlerGui());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private void loadStaticConfigurationValues() {
        ModConfig config = ModConfig.instance;
        Magnetization = new EnchantmentMagnetized(config.get("ENCHANTMENTS", "Magnetization Enchantment ID", 157, ""), 2).func_77322_b("Magnetization");
        ColdTouch = new EnchantmentColdTouch(config.get("ENCHANTMENTS", "Cold Touch Enchantment ID", 158, ""), 2).func_77322_b("Cold Touch");
        this.meteorFallDistance = config.get("Meteor Fall Radius", 350, "When determining where a meteor falls, it chooses within this radius (blocks) of a random player.");
        this.kittyAttackChance = config.get("Kitty Attack Chance", 1, "Ranges from 0 to 100");
        this.textNotifyCrash = config.get("Text Crash Notification", false, "Pops up a chat message when a meteor falls.");
        this.meteoriteEnabled = config.get("Meteorite Meteor Enabled", true, "Allow Meteorite Meteors to Fall?");
        this.frezariteEnabled = config.get("Frezarite Meteor Enabled", true, "Allow Frezarite Meteors to Fall?");
        this.kreknoriteEnabled = config.get("Kreknorite Meteor Enabled", true, "Allow Kreknorite Meteors to Fall?");
        this.unknownEnabled = config.get("Unknown Meteor Enabled", true, "Allow Unknown Meteors to Fall?");
        this.chunkChecks = config.get("Chunk Generation Checks", 4, "How many veins of meteorite ore per chunk?");
        this.oreGenSize = config.get("Meteor Ore Gen Size", 6, "How much ore per vein?");
        this.meteorShieldSound = config.get("Meteor Shield Humming Noise Enabled", true, "Allows a humming sound for the Meteor Shield too happen on occasion.");
        this.cometFallChance = config.get("Comet Fall Chance", 20, "Ranges from 0 to 100");
        this.whitelistedDimensions = config.get("Whitelisted Dimensions", new int[]{0, 1, 7}, "Dimensions that meteors are allowed to naturally fall in. 0 = Surface, 1 = The End, 7 = Twilight Forest");
        int configTicks = config.get("Meteor Fall Deterrence", 25, "For more info, refer here: http://fallingmeteorsmod.wikia.com/wiki/Falling_Meteors#Configuration") * 100;
        int mSpawn = (int)((double)configTicks * 0.25);
        int mCrash = (int)((double)configTicks * 0.75);
        this.MinTicksUntilMeteorSpawn = (int)((double)mSpawn * 0.25);
        this.RandTicksUntilMeteorSpawn = (int)((double)mSpawn * 0.75);
        this.MinTicksUntilMeteorCrashes = (int)((double)mCrash * 0.5);
        this.RandTicksUntilMeteorCrashes = (int)((double)mCrash * 0.5);
        this.setClientStartConfig();
    }

    public void setClientStartConfig() {
        this.meteorsFallOnlyAtNight = ModConfig.instance.get("Meteors Only Fall at Night", true, "The amount of time left until a meteor falls will only tick down at night.");
        this.allowSummonedMeteorGrief = ModConfig.instance.get("Allow Summoned Meteor Grief", false, "Players can't summon meteors on land protected by other players with a Meteor Shield");
        this.ShieldRadiusMultiplier = ModConfig.instance.get("Shield Radius in Blocks", 64, "The range of the meteor shield is determined by this times the shield's power level.");
        this.MinMeteorSize = ModConfig.instance.get("Minimum Meteor Size", 1, "Minimum Size of a falling meteor. Ranges from 1 to 3.");
        this.MaxMeteorSize = ModConfig.instance.get("Maximum Meteor Size", 3, "Maximum Size of a falling meteor. Ranges from 1 to 3.");
        this.MinMeteorSize = MathHelper.func_76125_a((int)this.MinMeteorSize, (int)1, (int)3);
        this.MaxMeteorSize = MathHelper.func_76125_a((int)this.MaxMeteorSize, (int)1, (int)3);
        if (this.MinMeteorSize > this.MaxMeteorSize) {
            this.MinMeteorSize = this.MaxMeteorSize;
        } else if (this.MaxMeteorSize < this.MinMeteorSize) {
            this.MaxMeteorSize = this.MinMeteorSize;
        }
        this.MinMeteorSizeForPortal = ModConfig.instance.get("Minimum Meteor Size To Spawn Nether Portal", 2, "When a Kreknorite Meteor falls, if the meteor is this size or bigger, it will generate a nether portal.");
        if (this.MinMeteorSizeForPortal < this.MinMeteorSize) {
            this.MinMeteorSizeForPortal = this.MinMeteorSize;
        }
        this.ImpactExplosionMultiplier = ModConfig.instance.get("Meteor Impact Explosion Multiplier", 5.0, "This times the meteor's size is how big the explosion will be.");
        if (this.ImpactExplosionMultiplier > 20.0) {
            this.ImpactExplosionMultiplier = 20.0;
        } else if (this.ImpactExplosionMultiplier < 0.0) {
            this.ImpactExplosionMultiplier = 0.0;
        }
        this.ImpactSpread = MathHelper.func_76130_a((int)ModConfig.instance.get("Meteor Impact Spread", 4, "This times the meteor size determines how big of an impact the meteor's crater will have to spread ore."));
        this.slipperyBlocksEnabled = ModConfig.instance.get("Slippery Blocks Enabled", true, "Setting to false will disallow the creation of Slippery Blocks with the Freezer.");
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandKittyAttack());
        evt.registerServerCommand((ICommand)new CommandDebugShields());
        evt.registerServerCommand((ICommand)new CommandDebugMeteors());
        evt.registerServerCommand((ICommand)new CommandSpawnMeteor());
        evt.registerServerCommand((ICommand)new CommandSpawnComet());
    }

    private void registerEntities() {
        proxy.registerTileEntities();
        EntityRegistry.registerGlobalEntityID(EntityMeteor.class, (String)"Meteor", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntityMeteor.class, (String)"FallingMeteor", (int)1, (Object)this, (int)64, (int)8, (boolean)true);
        EntityRegistry.registerGlobalEntityID(EntityAlienCreeper.class, (String)"AlienCreeper", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)7864485, (int)16732697);
        EntityRegistry.registerModEntity(EntityAlienCreeper.class, (String)"AlienCreeper", (int)3, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerGlobalEntityID(EntityCometKitty.class, (String)"CometKitty", (int)EntityRegistry.findGlobalUniqueEntityId(), (int)0x222B33, (int)884535);
        EntityRegistry.registerModEntity(EntityCometKitty.class, (String)"CometKitty", (int)4, (Object)this, (int)80, (int)3, (boolean)true);
        EntityRegistry.registerGlobalEntityID(EntitySummoner.class, (String)"MeteorSummoner", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntitySummoner.class, (String)"MeteorSummoner", (int)2, (Object)this, (int)64, (int)8, (boolean)true);
        EntityRegistry.registerGlobalEntityID(EntityComet.class, (String)"FallingComet", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntityComet.class, (String)"FallingComet", (int)5, (Object)this, (int)64, (int)8, (boolean)true);
    }

    private void loadPlugins() {
        if (Loader.isModLoaded((String)"Waila")) {
            FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"net.meteor.plugin.waila.Waila.register");
        } else {
            log.info("Waila not found. Waila integration disabled.");
        }
        if (Loader.isModLoaded((String)"Baubles")) {
            Baubles.setupBaubleItems();
        } else {
            log.info("Baubles not found. Baubles integration disabled.");
        }
        if (Loader.isModLoaded((String)"Thaumcraft")) {
            Thaumcraft.incorporateThaumcraft();
        } else {
            log.info("Thaumcraft not found. Thaumcraft integration disabled.");
        }
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (chunkGenerator instanceof ChunkProviderGenerate) {
            int randZ;
            int randY;
            int randX;
            int i;
            int x = chunkX << 4;
            int z = chunkZ << 4;
            for (i = 0; i < this.chunkChecks; ++i) {
                randX = x + rand.nextInt(16);
                randY = rand.nextInt(16) + 6;
                randZ = z + rand.nextInt(16);
                new WorldGenMinable(MeteorBlocks.blockMeteorOre, this.oreGenSize).func_76484_a(world, rand, randX, randY, randZ);
            }
            for (i = 0; i < this.chunkChecks; ++i) {
                randX = x + rand.nextInt(16);
                randY = rand.nextInt(20) + 32;
                randZ = z + rand.nextInt(16);
                if (!(world.func_72807_a((int)randX, (int)randZ).field_76750_F <= 0.15f)) continue;
                new WorldGenMinable(MeteorBlocks.blockFrezariteOre, this.oreGenSize).func_76484_a(world, rand, randX, randY, randZ);
            }
        }
    }

    public boolean isDimensionWhitelisted(int dim) {
        for (int i = 0; i < this.whitelistedDimensions.length; ++i) {
            if (dim != this.whitelistedDimensions[i]) continue;
            return true;
        }
        return false;
    }

    public static void whatSide(Side side, String s) {
    }

    static {
        meteorTab = new CreativeTabMeteor("Falling Meteors Mod");
    }
}

