/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.meteor.common.block.BlockContainerMeteorsMod;
import net.meteor.common.block.BlockSlipperyStairs;
import net.meteor.common.tileentity.TileEntitySlippery;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSlippery
extends BlockContainerMeteorsMod {
    public BlockSlippery(float slipperiness) {
        super(Material.field_151588_w);
        this.field_149765_K = slipperiness;
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntitySlippery();
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a("ice");
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        TileEntitySlippery tileEntity = (TileEntitySlippery)world.func_147438_o(x, y, z);
        tileEntity.setFacadeBlockName(item.func_77978_p().func_74779_i("slipFacadeBlock"));
        tileEntity.func_70296_d();
        super.func_149689_a(world, x, y, z, entity, item);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            TileEntitySlippery teSlippery = (TileEntitySlippery)world.func_147438_o(x, y, z);
            ItemStack slipItem = new ItemStack((Block)this, 1, teSlippery.getFacadeBlock().func_149692_a(world.func_72805_g(x, y, z)));
            NBTTagCompound nbt = slipItem.func_77942_o() ? slipItem.func_77978_p() : new NBTTagCompound();
            nbt.func_74778_a("slipFacadeBlock", teSlippery.getFacadeBlockName());
            slipItem.func_77982_d(nbt);
            this.func_149642_a(world, x, y, z, slipItem);
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Item item = this.func_149694_d(world, x, y, z);
        if (item == null) {
            return null;
        }
        BlockSlippery block = (BlockSlippery)world.func_147439_a(x, y, z);
        ItemStack stack = new ItemStack(item, 1, world.func_72805_g(x, y, z));
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        TileEntitySlippery tileEntity = (TileEntitySlippery)world.func_147438_o(x, y, z);
        nbt.func_74778_a("slipFacadeBlock", tileEntity.getFacadeBlockName());
        stack.func_77982_d(nbt);
        return stack;
    }

    public static boolean canBeSlippery(Block block) {
        if ((block instanceof BlockSlippery || block instanceof BlockSlipperyStairs) && block.field_149765_K < 1.1f) {
            return true;
        }
        if (block.func_149645_b() == 0 || block.func_149645_b() == 31 || block.func_149645_b() == 10 || block.func_149645_b() == 39) {
            return !(block instanceof ITileEntityProvider) && !(block instanceof BlockSlab);
        }
        return false;
    }
}

