/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.climate;

import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.List;
import java.util.Random;
import net.meteor.common.EnumMeteor;
import net.meteor.common.IMeteorShield;
import net.meteor.common.MeteorsMod;
import net.meteor.common.climate.HandlerMeteor;
import net.meteor.common.entity.EntityComet;
import net.meteor.common.tileentity.TileEntityMeteorShield;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public class ClimateUpdater {
    private static Random random = new Random();
    private int ticks = 0;
    private int tickGoal = -1;
    private HandlerMeteor meteorHandler;
    private long lastTick = 0L;

    public ClimateUpdater(HandlerMeteor metHandler) {
        this.meteorHandler = metHandler;
    }

    public void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (!world.field_72995_K) {
            long wTime;
            int dim = world.field_73011_w.field_76574_g;
            if (world.func_82736_K().func_82766_b("meteorsFall") && MeteorsMod.instance.isDimensionWhitelisted(dim) && (wTime = world.func_82737_E()) % 20L == 0L && wTime != this.lastTick) {
                this.lastTick = wTime;
                if (this.tickGoal == -1) {
                    this.tickGoal = this.getNewTickGoal();
                }
                MeteorsMod mod = MeteorsMod.instance;
                this.meteorHandler.updateMeteors();
                if (world.func_72820_D() % 24000L >= 12000L || !mod.meteorsFallOnlyAtNight) {
                    ++this.ticks;
                    if (this.ticks >= this.tickGoal) {
                        EntityPlayer player;
                        int z;
                        int x;
                        if (this.meteorHandler.canSpawnNewMeteor() && world.field_73010_i.size() > 0) {
                            x = world.field_73012_v.nextInt(mod.meteorFallDistance);
                            z = world.field_73012_v.nextInt(mod.meteorFallDistance);
                            if (world.field_73012_v.nextBoolean()) {
                                x = -x;
                            }
                            if (world.field_73012_v.nextBoolean()) {
                                z = -z;
                            }
                            player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
                            ChunkCoordIntPair coords = world.func_72938_d(x = (int)((double)x + player.field_70165_t), z = (int)((double)z + player.field_70161_v)).func_76632_l();
                            if (this.meteorHandler.canSpawnNewMeteorAt(coords)) {
                                if (random.nextInt(100) < MeteorsMod.instance.kittyAttackChance) {
                                    this.meteorHandler.readyNewMeteor(x, z, HandlerMeteor.getMeteorSize(), 90, EnumMeteor.KITTY);
                                } else {
                                    this.meteorHandler.readyNewMeteor(x, z, HandlerMeteor.getMeteorSize(), random.nextInt(mod.RandTicksUntilMeteorCrashes + 1) + mod.MinTicksUntilMeteorCrashes, HandlerMeteor.getMeteorType());
                                }
                            }
                        }
                        if (random.nextInt(100) < MeteorsMod.instance.cometFallChance && world.field_73010_i.size() > 0) {
                            IMeteorShield ims;
                            int i;
                            x = world.field_73012_v.nextInt(mod.meteorFallDistance / 4);
                            z = world.field_73012_v.nextInt(mod.meteorFallDistance / 4);
                            if (world.field_73012_v.nextBoolean()) {
                                x = -x;
                            }
                            if (world.field_73012_v.nextBoolean()) {
                                z = -z;
                            }
                            player = (EntityPlayer)world.field_73010_i.get(world.field_73012_v.nextInt(world.field_73010_i.size()));
                            x = (int)((double)x + player.field_70165_t);
                            z = (int)((double)z + player.field_70161_v);
                            EntityComet comet = new EntityComet(world, x, z, HandlerMeteor.getCometType());
                            boolean blocked = false;
                            List<IMeteorShield> shields = this.meteorHandler.getShieldManager().getShieldsInRange(x, z);
                            for (i = 0; i < shields.size(); ++i) {
                                ims = shields.get(i);
                                if (!ims.getPreventComets()) continue;
                                blocked = true;
                                break;
                            }
                            if (!blocked) {
                                for (i = 0; i < shields.size(); ++i) {
                                    ims = shields.get(i);
                                    TileEntityMeteorShield shield = (TileEntityMeteorShield)world.func_147438_o(ims.getX(), ims.getY(), ims.getZ());
                                    if (shield == null) continue;
                                    shield.detectComet(comet);
                                }
                                world.func_72838_d((Entity)comet);
                            }
                        }
                        this.ticks = 0;
                        this.tickGoal = this.getNewTickGoal();
                    }
                }
            }
        }
    }

    private int getNewTickGoal() {
        return random.nextInt(MeteorsMod.instance.RandTicksUntilMeteorSpawn + 1) + MeteorsMod.instance.MinTicksUntilMeteorSpawn;
    }

    public int getSecondsUntilNewMeteor() {
        return this.tickGoal - this.ticks;
    }
}

