/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.climate;

import java.util.ArrayList;
import java.util.Iterator;
import net.meteor.common.climate.GhostMeteor;
import net.meteor.common.climate.HandlerMeteor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class GhostMeteorData
extends WorldSavedData {
    private static final String key = "metGhostMets";
    private static HandlerMeteor tempHandle;
    private HandlerMeteor metHandler;

    public GhostMeteorData(String s) {
        super(s);
    }

    public static GhostMeteorData forWorld(World world, HandlerMeteor metH) {
        tempHandle = metH;
        MapStorage storage = world.perWorldStorage;
        GhostMeteorData result = (GhostMeteorData)storage.func_75742_a(GhostMeteorData.class, key);
        if (result == null) {
            result = new GhostMeteorData(key);
            storage.func_75745_a(key, (WorldSavedData)result);
        }
        result.metHandler = metH;
        tempHandle = null;
        return result;
    }

    public void func_76184_a(NBTTagCompound tag) {
        if (this.metHandler != null) {
            this.metHandler.ghostMets = this.loadGhostMeteors(tag);
        } else {
            GhostMeteorData.tempHandle.ghostMets = this.loadGhostMeteors(tag);
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        this.saveGhostMeteors(tag);
    }

    private ArrayList<GhostMeteor> loadGhostMeteors(NBTTagCompound tag) {
        ArrayList<GhostMeteor> gMets = new ArrayList<GhostMeteor>();
        for (int i = 1; i <= 3; ++i) {
            GhostMeteor gmet;
            if (!tag.func_74764_b("GMet" + i) || (gmet = GhostMeteor.fromNBTString(tag.func_74779_i("GMet" + i))) == null) continue;
            gMets.add(gmet);
        }
        return gMets;
    }

    private void saveGhostMeteors(NBTTagCompound tag) {
        int i;
        Iterator<GhostMeteor> iter = this.metHandler.ghostMets.iterator();
        for (i = 1; iter.hasNext() && i <= 3; ++i) {
            GhostMeteor gmet = iter.next();
            tag.func_74778_a("GMet" + i, gmet.toString());
        }
        while (i < 4) {
            if (tag.func_74764_b("GMet" + i)) {
                tag.func_82580_o("GMet" + i);
            }
            ++i;
        }
    }

    public boolean func_76188_b() {
        return true;
    }
}

