/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.meteor.common.EnumMeteor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PacketBlockedMeteor
implements IMessage {
    public int x;
    public int y;
    public int z;
    public EnumMeteor type;

    public PacketBlockedMeteor() {
    }

    public PacketBlockedMeteor(int x, int y, int z, EnumMeteor type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    public void fromBytes(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.type = EnumMeteor.getTypeFromID(buffer.readInt());
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.type.getID());
    }

    public static class Handler
    implements IMessageHandler<PacketBlockedMeteor, IMessage> {
        public IMessage onMessage(PacketBlockedMeteor message, MessageContext ctx) {
            Block block = message.type.getRepresentingBlock();
            World world = this.getClientPlayer().field_70170_p;
            double d3 = Math.min(0.8666667f, 10.0f);
            if (d3 > 2.5) {
                d3 = 2.5;
            }
            int l1 = (int)(150.0 * d3);
            for (int i2 = 0; i2 < l1; ++i2) {
                float f3 = MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.0f, (float)((float)Math.PI * 2));
                double d5 = MathHelper.func_151240_a((Random)world.field_73012_v, (float)0.75f, (float)1.0f);
                double d6 = (double)0.2f + d3 / 100.0;
                double d7 = (double)(MathHelper.func_76134_b((float)f3) * 0.2f) * d5 * d5 * (d3 + 0.2);
                double d8 = (double)(MathHelper.func_76126_a((float)f3) * 0.2f) * d5 * d5 * (d3 + 0.2);
                world.func_72869_a("blockcrack_" + Block.func_149682_b((Block)block) + "_1", (double)((float)message.x + 0.5f), (double)((float)message.y + 1.0f), (double)((float)message.z + 0.5f), d7, d6, d8);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public EntityPlayer getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }
}

