/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.meteor.common.tileentity.TileEntityNetworkBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class PacketButtonPress
implements IMessage {
    private TileEntityNetworkBase tileEntity;
    private int buttonID;

    public PacketButtonPress() {
    }

    public PacketButtonPress(TileEntityNetworkBase tile, int buttonID) {
        this.tileEntity = tile;
        this.buttonID = buttonID;
    }

    public void fromBytes(ByteBuf buffer) {
        TileEntity tile;
        int dim = buffer.readInt();
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.buttonID = buffer.readInt();
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dim);
        if (world != null && (tile = world.func_147438_o(x, y, z)) instanceof TileEntityNetworkBase) {
            this.tileEntity = (TileEntityNetworkBase)tile;
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.tileEntity.func_145831_w().field_73011_w.field_76574_g);
        buffer.writeInt(this.tileEntity.field_145851_c);
        buffer.writeInt(this.tileEntity.field_145848_d);
        buffer.writeInt(this.tileEntity.field_145849_e);
        buffer.writeInt(this.buttonID);
    }

    public static class Handler
    implements IMessageHandler<PacketButtonPress, IMessage> {
        public IMessage onMessage(PacketButtonPress message, MessageContext ctx) {
            if (message.tileEntity != null) {
                message.tileEntity.onButtonPress(message.buttonID);
                message.tileEntity.postButtonPress(message.buttonID);
            }
            return null;
        }
    }
}

