/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.meteor.common.ClientHandler;
import net.meteor.common.climate.GhostMeteor;
import net.minecraft.util.ChunkCoordinates;

public class PacketGhostMeteor
implements IMessage {
    private boolean addGhostMeteor;
    private int x;
    private int y;
    private int z;

    public PacketGhostMeteor() {
        this.addGhostMeteor = false;
        this.z = -1;
        this.y = -1;
        this.x = -1;
    }

    public PacketGhostMeteor(boolean adding, GhostMeteor gMet) {
        this(adding, gMet.x, 0, gMet.z);
    }

    public PacketGhostMeteor(boolean adding, int x, int y, int z) {
        this.addGhostMeteor = adding;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buffer) {
        this.addGhostMeteor = buffer.readBoolean();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.addGhostMeteor);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    public static class Handler
    implements IMessageHandler<PacketGhostMeteor, IMessage> {
        public IMessage onMessage(PacketGhostMeteor message, MessageContext ctx) {
            ChunkCoordinates cc = new ChunkCoordinates(message.x, message.y, message.z);
            if (message.addGhostMeteor) {
                ClientHandler.ghostMetLocs.add(cc);
            } else if (cc.field_71574_a == -1 && cc.field_71572_b == -1 && cc.field_71573_c == -1) {
                ClientHandler.ghostMetLocs.clear();
            } else {
                for (int i = 0; i < ClientHandler.ghostMetLocs.size(); ++i) {
                    ChunkCoordinates cc2 = ClientHandler.ghostMetLocs.get(i);
                    if (cc2.field_71574_a != cc.field_71574_a || cc2.field_71573_c != cc.field_71573_c) continue;
                    ClientHandler.ghostMetLocs.remove(i);
                    break;
                }
            }
            return null;
        }
    }
}

