/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.meteor.common.ClientHandler;
import net.meteor.common.climate.CrashLocation;

public class PacketLastCrash
implements IMessage {
    private CrashLocation lastCrashLoc;

    public PacketLastCrash() {
    }

    public PacketLastCrash(CrashLocation loc) {
        this.lastCrashLoc = loc;
        if (this.lastCrashLoc == null) {
            this.lastCrashLoc = new CrashLocation(-1, -1, -1, false, null);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        boolean inOrbit = buffer.readBoolean();
        this.lastCrashLoc = x == -1 && y == -1 && z == -1 ? (ClientHandler.lastCrashLocation != null ? ClientHandler.lastCrashLocation.prevCrash : null) : new CrashLocation(x, y, z, inOrbit, ClientHandler.lastCrashLocation);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.lastCrashLoc.x);
        buffer.writeInt(this.lastCrashLoc.y);
        buffer.writeInt(this.lastCrashLoc.z);
        buffer.writeBoolean(this.lastCrashLoc.inOrbit);
    }

    public static class Handler
    implements IMessageHandler<PacketLastCrash, IMessage> {
        public IMessage onMessage(PacketLastCrash message, MessageContext ctx) {
            ClientHandler.lastCrashLocation = message.lastCrashLoc;
            return null;
        }
    }
}

