/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.meteor.common.ClientHandler;
import net.meteor.common.climate.GhostMeteor;
import net.minecraft.util.ChunkCoordinates;

public class PacketSoonestMeteor
implements IMessage {
    private ChunkCoordinates soonestMeteorLoc;

    public PacketSoonestMeteor() {
    }

    public PacketSoonestMeteor(GhostMeteor gMeteor) {
        this.soonestMeteorLoc = gMeteor != null ? new ChunkCoordinates(gMeteor.x, 0, gMeteor.z) : new ChunkCoordinates(-1, -1, -1);
    }

    public void fromBytes(ByteBuf buffer) {
        int x = buffer.readInt();
        int y = buffer.readInt();
        int z = buffer.readInt();
        this.soonestMeteorLoc = y == -1 ? null : new ChunkCoordinates(x, y, z);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.soonestMeteorLoc.field_71574_a);
        buffer.writeInt(this.soonestMeteorLoc.field_71572_b);
        buffer.writeInt(this.soonestMeteorLoc.field_71573_c);
    }

    public static class Handler
    implements IMessageHandler<PacketSoonestMeteor, IMessage> {
        public IMessage onMessage(PacketSoonestMeteor message, MessageContext ctx) {
            ClientHandler.nearestTimeLocation = message.soonestMeteorLoc;
            return null;
        }
    }
}

