/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.meteor.common.FreezerRecipes;
import net.meteor.common.MeteorItems;
import net.meteor.common.tileentity.TileEntityNetworkBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFreezingMachine
extends TileEntityNetworkBase
implements ISidedInventory,
IFluidHandler {
    private static int[] acccessibleSlots = new int[]{0, 1, 2, 3, 4};
    private ItemStack[] inv = new ItemStack[this.func_70302_i_()];
    private ItemStack lastKnownItem = null;
    private FluidTank tank = new FluidTank(10000);
    private FreezerRecipes.RecipeType acceptedRecipeType = FreezerRecipes.RecipeType.either;
    public int cookTime;
    public int burnTime;
    public int currentItemBurnTime;

    public int func_70302_i_() {
        return 5;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inv[slot] != null) {
            if (this.inv[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.inv[slot];
                this.inv[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inv[slot].func_77979_a(amount);
            if (this.inv[slot].field_77994_a == 0) {
                this.inv[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.inv[slot] = item;
        if (item != null && item.field_77994_a > this.func_70297_j_()) {
            item.field_77994_a = this.func_70297_j_();
        }
        if (slot == 3) {
            this.checkFluidContainer();
        }
    }

    private void checkFluidContainer() {
        ItemStack item = this.inv[3];
        if (item != null && FluidContainerRegistry.isContainer((ItemStack)item)) {
            if (FluidContainerRegistry.isFilledContainer((ItemStack)item)) {
                FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
                if ((fluid != null && fluid.isFluidEqual(this.tank.getFluid()) || this.tank.getFluidAmount() == 0) && this.tank.fill(fluid, false) == fluid.amount) {
                    ItemStack emptyContainer = null;
                    FluidContainerRegistry.FluidContainerData[] containerData = FluidContainerRegistry.getRegisteredFluidContainerData();
                    for (int i = 0; i < containerData.length; ++i) {
                        if (!containerData[i].filledContainer.func_77969_a(item)) continue;
                        emptyContainer = containerData[i].emptyContainer.func_77946_l();
                    }
                    if (emptyContainer != null) {
                        if (this.inv[4] == null) {
                            this.tank.fill(fluid, true);
                            this.inv[4] = emptyContainer;
                            this.func_70298_a(3, 1);
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        } else if (this.inv[4].func_77969_a(emptyContainer) && this.inv[4].field_77994_a + 1 <= this.inv[4].func_77976_d()) {
                            this.tank.fill(fluid, true);
                            ++this.inv[4].field_77994_a;
                            this.func_70298_a(3, 1);
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                    }
                }
            } else {
                ItemStack filledContainer;
                FluidStack fluidInTank = this.tank.getFluid();
                if (fluidInTank != null && (filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluidInTank, (ItemStack)item)) != null) {
                    if (this.inv[4] == null) {
                        this.tank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer).amount, true);
                        this.inv[4] = filledContainer;
                        this.func_70298_a(3, 1);
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    } else if (this.inv[4].func_77969_a(filledContainer) && this.inv[4].field_77994_a + 1 <= this.inv[4].func_77976_d()) {
                        this.tank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer).amount, true);
                        ++this.inv[4].field_77994_a;
                        this.func_70298_a(3, 1);
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
            }
        }
    }

    public String func_145825_b() {
        return "Freezer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inv = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inv.length) continue;
            this.inv[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.burnTime = nbt.func_74765_d("BurnTime");
        this.cookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = nbt.func_74765_d("ItemFreezeTime");
        this.acceptedRecipeType = FreezerRecipes.RecipeType.values()[nbt.func_74765_d("acceptedRecipeType")];
        this.tank.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("BurnTime", (short)this.burnTime);
        nbt.func_74777_a("CookTime", (short)this.cookTime);
        nbt.func_74777_a("ItemFreezeTime", (short)this.currentItemBurnTime);
        nbt.func_74777_a("acceptedRecipeType", (short)this.acceptedRecipeType.getID());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        this.tank.writeToNBT(nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (slot == 3) {
            return FluidContainerRegistry.isContainer((ItemStack)item);
        }
        return slot == 2 ? false : (slot == 1 ? TileEntityFreezingMachine.getItemFreezeTime(item) > 0 : true);
    }

    public int[] func_94128_d(int side) {
        return acccessibleSlots;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return FluidContainerRegistry.isContainer((ItemStack)item) ? slot == 3 : slot == 1;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 2 || slot == 4;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int i) {
        return this.cookTime * i / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int i) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.burnTime * i / this.currentItemBurnTime;
    }

    public FreezerRecipes.RecipeType getRecipeMode() {
        return this.acceptedRecipeType;
    }

    public void setRecipeMode(FreezerRecipes.RecipeType type) {
        this.acceptedRecipeType = type;
    }

    public boolean isFreezing() {
        return this.burnTime > 0;
    }

    public void func_145845_h() {
        boolean flag = this.burnTime > 0;
        boolean flag1 = false;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.inv[3] != null) {
                this.checkFluidContainer();
            }
            if (this.burnTime != 0 || this.inv[1] != null) {
                if (this.burnTime == 0 && this.canFreeze()) {
                    this.currentItemBurnTime = this.burnTime = TileEntityFreezingMachine.getItemFreezeTime(this.inv[1]);
                    if (this.burnTime > 0) {
                        flag1 = true;
                        if (this.inv[1] != null) {
                            --this.inv[1].field_77994_a;
                            if (this.inv[1].field_77994_a == 0) {
                                this.inv[1] = this.inv[1].func_77973_b().getContainerItem(this.inv[1]);
                            }
                        }
                    }
                }
                if (this.isFreezing() && this.canFreeze()) {
                    ++this.cookTime;
                    if (this.cookTime == 200) {
                        this.cookTime = 0;
                        this.freezeItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else {
                this.cookTime = 0;
            }
            if (flag != this.burnTime > 0) {
                flag1 = true;
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.burnTime > 0 ? meta + 4 : meta - 4, 2);
            }
        }
        if (flag1) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public static int getItemFreezeTime(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            if (item == MeteorItems.itemFrezaCrystal) {
                return 1600;
            }
            if (item == Item.func_150898_a((Block)Blocks.field_150432_aD)) {
                return 200;
            }
            if (item == Item.func_150898_a((Block)Blocks.field_150403_cj)) {
                return 400;
            }
        }
        return 0;
    }

    private boolean canFreeze() {
        FreezerRecipes.FreezerRecipe recipe = FreezerRecipes.instance().getFreezingResult(this.inv[0], this.tank.getFluid(), this.acceptedRecipeType);
        if (recipe == null) {
            return false;
        }
        ItemStack result = recipe.getResult(this.inv[0]);
        if (this.inv[2] == null) {
            if (this.lastKnownItem == null) {
                this.lastKnownItem = result;
            } else if (!result.func_77969_a(this.lastKnownItem)) {
                this.cookTime = 0;
                this.lastKnownItem = result;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        if (!this.inv[2].func_77969_a(result)) {
            return false;
        }
        int resultSize = this.inv[2].field_77994_a + result.field_77994_a;
        if (resultSize <= this.func_70297_j_() && resultSize <= this.inv[2].func_77976_d()) {
            if (this.lastKnownItem == null) {
                this.lastKnownItem = result;
            } else if (!result.func_77969_a(this.lastKnownItem)) {
                this.cookTime = 0;
                this.lastKnownItem = result;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public void freezeItem() {
        if (this.canFreeze()) {
            FreezerRecipes.FreezerRecipe recipe = FreezerRecipes.instance().getFreezingResult(this.inv[0], this.tank.getFluid(), this.acceptedRecipeType);
            if (this.inv[2] == null) {
                this.inv[2] = recipe.getResult(this.inv[0]).func_77946_l();
            } else if (this.inv[2].func_77973_b() == recipe.getResult(this.inv[0]).func_77973_b()) {
                this.inv[2].field_77994_a += recipe.getResult((ItemStack)this.inv[0]).field_77994_a;
            }
            if (recipe.requiresItem()) {
                --this.inv[0].field_77994_a;
                if (this.inv[0].field_77994_a <= 0) {
                    this.inv[0] = null;
                }
            }
            if (recipe.requiresFluid()) {
                this.tank.drain(recipe.getFluidAmount(), true);
                if (this.tank.getFluidAmount() == 0) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.tank.getFluidAmount() == 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (doDrain && this.tank.getFluidAmount() - maxDrain <= 0) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public FluidTankInfo getTankInfo() {
        return this.tank.getInfo();
    }

    @Override
    public void onButtonPress(int id) {
        if (id == 0) {
            int i = this.acceptedRecipeType.getID();
            i = i == 3 ? 0 : ++i;
            this.acceptedRecipeType = FreezerRecipes.RecipeType.values()[i];
        }
    }
}

