/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.common.tileentity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.meteor.common.ClientHandler;
import net.meteor.common.ClientProxy;
import net.meteor.common.EnumMeteor;
import net.meteor.common.HandlerAchievement;
import net.meteor.common.IMeteorShield;
import net.meteor.common.MeteorItems;
import net.meteor.common.MeteorsMod;
import net.meteor.common.climate.HandlerMeteor;
import net.meteor.common.climate.MeteorShieldData;
import net.meteor.common.entity.EntityComet;
import net.meteor.common.tileentity.TileEntityNetworkBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class TileEntityMeteorShield
extends TileEntityNetworkBase
implements ISidedInventory,
IMeteorShield {
    public static final int CHARGE_TIME = 1600;
    private boolean shieldedChunks = false;
    private boolean blockComets = false;
    public String owner = "None";
    private int range = 0;
    private int powerLevel = 0;
    private int cometX;
    private int cometZ;
    private int cometType = -1;
    public int age = 0;
    private ItemStack[] inv = new ItemStack[13];

    public TileEntityMeteorShield() {
    }

    public TileEntityMeteorShield(String theOwner) {
        this();
        this.owner = theOwner;
    }

    public void func_145845_h() {
        ++this.age;
        if (!this.shieldedChunks) {
            if (this.powerLevel > 0) {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                    MeteorsMod.proxy.metHandlers.get(this.field_145850_b.field_73011_w.field_76574_g).getShieldManager().addShield(this);
                }
                this.shieldedChunks = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                this.GenerateParticles(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73012_v);
            } else if (this.age >= 1600) {
                EntityPlayer player;
                this.setCharged();
                if (!this.field_145850_b.field_72995_K && this.owner != null && this.owner.length() > 0 && (player = this.field_145850_b.func_72924_a(this.owner)) != null) {
                    player.func_145747_a(ClientHandler.createMessage(StatCollector.func_74838_a((String)"MeteorShield.howToUpgrade"), EnumChatFormatting.GOLD));
                }
            }
        }
        if (this.shieldedChunks) {
            this.range = this.powerLevel * MeteorsMod.instance.ShieldRadiusMultiplier;
        }
    }

    public void setCharged() {
        if (this.powerLevel == 0) {
            this.powerLevel = 1;
        }
    }

    @Override
    public boolean getPreventComets() {
        return this.blockComets;
    }

    public EnumMeteor getCometType() {
        if (this.cometType == -1) {
            return EnumMeteor.METEORITE;
        }
        return EnumMeteor.getTypeFromID(this.cometType);
    }

    public List<String> getDisplayInfo() {
        ArrayList<String> info = new ArrayList<String>();
        if (this.powerLevel == 0) {
            info.add(StatCollector.func_74838_a((String)"info.meteorShield.charging"));
            info.add(StatCollector.func_74837_a((String)"info.meteorShield.charged", (Object[])new Object[]{(int)((float)this.age / 1600.0f * 100.0f)}));
        } else {
            info.add(StatCollector.func_74837_a((String)"info.meteorShield.powerLevel", (Object[])new Object[]{this.powerLevel, 5}));
            info.add(StatCollector.func_74837_a((String)"info.meteorShield.range", (Object[])new Object[]{this.range}));
        }
        info.add(StatCollector.func_74837_a((String)"info.meteorShield.owner", (Object[])new Object[]{this.owner}));
        if (this.powerLevel != 0) {
            if (this.blockComets) {
                info.add(StatCollector.func_74838_a((String)"info.meteorShield.cometsBeingBlocked"));
            } else if (this.cometType != -1) {
                info.add(StatCollector.func_74838_a((String)"info.meteorShield.cometEnteredOrbit"));
                info.add(StatCollector.func_74837_a((String)"info.meteorShield.cometX", (Object[])new Object[]{this.cometX}));
                info.add(StatCollector.func_74837_a((String)"info.meteorShield.cometZ", (Object[])new Object[]{this.cometZ}));
            } else {
                info.add(StatCollector.func_74838_a((String)"info.meteorShield.noComets"));
            }
        }
        return info;
    }

    public void addMeteorMaterials(List<ItemStack> items) {
        block0: for (int i = 0; i < items.size(); ++i) {
            ItemStack itemstack1;
            int k;
            ItemStack par1ItemStack = items.get(i);
            if (par1ItemStack.func_77985_e()) {
                for (k = 5; par1ItemStack.field_77994_a > 0 && k >= 5 && k < this.func_70302_i_(); ++k) {
                    itemstack1 = this.inv[k];
                    if (itemstack1 == null || itemstack1.func_77973_b() != par1ItemStack.func_77973_b() || par1ItemStack.func_77981_g() && par1ItemStack.func_77960_j() != itemstack1.func_77960_j() || !ItemStack.func_77970_a((ItemStack)par1ItemStack, (ItemStack)itemstack1)) continue;
                    int l = itemstack1.field_77994_a + par1ItemStack.field_77994_a;
                    if (l <= par1ItemStack.func_77976_d()) {
                        par1ItemStack.field_77994_a = 0;
                        itemstack1.field_77994_a = l;
                        continue;
                    }
                    if (itemstack1.field_77994_a >= par1ItemStack.func_77976_d()) continue;
                    par1ItemStack.field_77994_a -= par1ItemStack.func_77976_d() - itemstack1.field_77994_a;
                    itemstack1.field_77994_a = par1ItemStack.func_77976_d();
                }
            }
            if (par1ItemStack.field_77994_a <= 0) continue;
            for (k = 5; k >= 5 && k < this.func_70302_i_(); ++k) {
                itemstack1 = this.inv[k];
                if (itemstack1 != null) continue;
                this.inv[k] = par1ItemStack.func_77946_l();
                par1ItemStack.field_77994_a = 0;
                continue block0;
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void detectComet(EntityComet comet) {
        this.cometX = (int)comet.field_70165_t;
        this.cometZ = (int)comet.field_70161_v;
        this.cometType = comet.meteorType.getID();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @SideOnly(value=Side.CLIENT)
    private void GenerateParticles(World world, int x, int y, int z, Random random) {
        if (world.func_147439_a(x, y + 1, z).func_149662_c()) {
            return;
        }
        for (int currX = x - 2; currX <= x + 2; ++currX) {
            for (int currZ = z - 2; currZ <= z + 2; ++currZ) {
                if (currX > x - 2 && currX < x + 2 && currZ == z - 1) {
                    currZ = z + 2;
                }
                if (random.nextInt(100) != 25) continue;
                for (int currY = y; currY <= y + 1 && world.func_147437_c((currX - x) / 2 + x, currY, (currZ - z) / 2 + z); ++currY) {
                    ClientProxy.spawnParticle("meteorshield", (double)x + 0.5, (double)y + 2.0, (double)z + 0.5, (double)((float)(currX - x) + random.nextFloat()) - 0.5, (float)(currY - y) - random.nextFloat() - 1.0f, (double)((float)(currZ - z) + random.nextFloat()) - 0.5, world, -1);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.owner = nbt.func_74779_i("owner");
        if (this.owner == null || this.owner.trim().isEmpty()) {
            this.owner = "None";
        }
        this.powerLevel = nbt.func_74762_e("powerLevel");
        this.range = MeteorsMod.instance.ShieldRadiusMultiplier * this.powerLevel;
        this.blockComets = nbt.func_74767_n("blockComets");
        if (nbt.func_74764_b("cometType")) {
            this.cometType = nbt.func_74762_e("cometType");
            this.cometX = nbt.func_74762_e("cometX");
            this.cometZ = nbt.func_74762_e("cometZ");
        }
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inv = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inv.length) continue;
            this.inv[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("owner", this.owner);
        nbt.func_74768_a("powerLevel", this.powerLevel);
        nbt.func_74757_a("blockComets", this.blockComets);
        if (this.cometType != -1) {
            nbt.func_74768_a("cometType", this.cometType);
            nbt.func_74768_a("cometX", this.cometX);
            nbt.func_74768_a("cometZ", this.cometZ);
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            if (this.inv[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inv[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((double)this.field_145848_d + 1.5), (double)(this.field_145849_e + 1));
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack stack = this.func_70301_a(i);
        if (stack != null) {
            if (stack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                ItemStack stack2 = stack.func_77979_a(j);
                if (stack.field_77994_a <= 0) {
                    this.func_70299_a(i, null);
                }
                stack = stack2;
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (itemstack == null) {
            this.inv[i] = null;
            if (i > 0 && i < 5 && this.powerLevel > 1) {
                this.updateRange();
            }
        } else if (this.func_94041_b(i, itemstack)) {
            if (i < 5 && itemstack.field_77994_a > 1) {
                itemstack.field_77994_a = 1;
            }
            if (i == 0) {
                this.setCharged();
                this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "meteors:shield.powerup", 1.0f, 0.6f);
                this.func_70296_d();
            } else if (i > 0 && i < 5) {
                this.inv[i] = itemstack;
                this.updateRange();
            } else {
                this.inv[i] = itemstack;
            }
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack.func_77973_b() == MeteorItems.itemRedMeteorGem && i > 0 && i < 5) {
            return this.powerLevel > 0 && this.powerLevel < 5 && this.inv[i] == null;
        }
        if (itemstack.func_77973_b() == MeteorItems.itemMeteorChips && i == 0) {
            return this.powerLevel == 0;
        }
        return true;
    }

    public String func_145825_b() {
        return "Meteor Shield";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    private void updateRange() {
        int powerCrystals = 0;
        for (int i = 1; i <= 4; ++i) {
            if (this.inv[i] == null || this.inv[i].func_77973_b() != MeteorItems.itemRedMeteorGem) continue;
            ++powerCrystals;
        }
        int oldLevel = this.powerLevel;
        this.powerLevel = 1 + powerCrystals;
        this.range = MeteorsMod.instance.ShieldRadiusMultiplier * this.powerLevel;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.powerLevel > oldLevel) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "meteors:shield.powerup", 1.0f, (float)this.powerLevel / 10.0f + 0.5f);
            EntityPlayer player = this.field_145850_b.func_72924_a(this.owner);
            if (this.powerLevel == 5 && player != null) {
                player.func_71064_a((StatBase)HandlerAchievement.shieldFullyUpgraded, 1);
            }
            if (MeteorsMod.instance.ShieldRadiusMultiplier <= 0 && !this.field_145850_b.field_72995_K && player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"MeteorShield.noUpgrade")));
            }
        } else if (this.powerLevel < oldLevel) {
            // empty if block
        }
        this.func_70296_d();
    }

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }

    @Override
    public boolean isTileEntity() {
        return true;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public int getPowerLevel() {
        return this.powerLevel;
    }

    public boolean equals(Object o) {
        if (o instanceof IMeteorShield) {
            IMeteorShield shield = (IMeteorShield)o;
            return this.getX() == shield.getX() && this.getY() == shield.getY() && this.getZ() == shield.getZ();
        }
        return super.equals(o);
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K) {
            HandlerMeteor metHandler = MeteorsMod.proxy.metHandlers.get(this.field_145850_b.field_73011_w.field_76574_g);
            metHandler.getShieldManager().addShield(new MeteorShieldData(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.powerLevel, this.owner, this.blockComets));
        }
        this.func_145843_s();
    }

    public int[] func_94128_d(int side) {
        int[] slots = new int[8];
        for (int i = 0; i < 8; ++i) {
            slots[i] = i + 5;
        }
        return slots;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return slot < 5 && this.func_94041_b(slot, item);
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot > 4;
    }

    @Override
    public void onButtonPress(int id) {
        if (id == 0) {
            this.blockComets = !this.blockComets;
        }
    }
}

