/*
 * Decompiled with CFR 0.152.
 */
package net.meteor.plugin.baubles;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.meteor.common.MeteorsMod;
import net.meteor.common.item.ItemMeteorsMod;
import net.meteor.plugin.baubles.Baubles;
import net.meteor.plugin.baubles.HandlerKey;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class ItemMagnetismController
extends ItemMeteorsMod
implements IBauble {
    private static final String MAGNETIZED_TAG = "magnetEnabled";
    protected Enchantment enchantment;
    protected int level;

    public ItemMagnetismController() {
        this.func_77625_d(1);
        this.setEnch(MeteorsMod.Magnetization, 3);
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BELT;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        NBTTagCompound nbt = itemstack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b(MAGNETIZED_TAG)) {
            ItemMagnetismController.setNBTData(itemstack, true);
        }
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List info, boolean advTooltip) {
        String state = ItemMagnetismController.getNBTData(stack) ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"options.on") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"options.off");
        info.add(StatCollector.func_74837_a((String)"info.magnetisationController.state", (Object[])new Object[]{state}));
        info.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74837_a((String)"info.magnetisationController.one", (Object[])new Object[]{HandlerKey.getKey()}));
        info.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"info.magnetisationController.two"));
        info.add("");
    }

    public static void setNBTData(ItemStack itemstack, boolean val) {
        NBTTagCompound nbt = itemstack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74757_a(MAGNETIZED_TAG, val);
        itemstack.func_77982_d(nbt);
    }

    public static boolean getNBTData(ItemStack itemstack) {
        NBTTagCompound nbt = itemstack.func_77978_p();
        if (nbt != null && nbt.func_74764_b(MAGNETIZED_TAG)) {
            return nbt.func_74767_n(MAGNETIZED_TAG);
        }
        ItemMagnetismController.setNBTData(itemstack, true);
        return true;
    }

    public static int isMagnetizationEnabled(EntityPlayer player, int def) {
        IInventory inv = BaublesApi.getBaubles((EntityPlayer)player);
        ItemStack stack = inv.func_70301_a(3);
        if (stack != null && stack.func_77973_b() == Baubles.MagnetismController) {
            return ItemMagnetismController.getNBTData(stack) ? Math.max(EnchantmentHelper.func_77506_a((int)MeteorsMod.Magnetization.field_77352_x, (ItemStack)stack), def) : 0;
        }
        return def;
    }

    public ItemMeteorsMod setEnch(Enchantment ench, int lvl) {
        this.enchantment = ench;
        this.level = lvl;
        return this;
    }

    public int getDamage(ItemStack stack) {
        if (!stack.func_77948_v() && !this.isRestricted(stack)) {
            stack.func_77966_a(this.enchantment, this.level);
            NBTTagCompound tag = stack.func_77978_p();
            tag.func_74757_a("enchant-set", true);
            stack.func_77982_d(tag);
        }
        return super.getDamage(stack);
    }

    private boolean isRestricted(ItemStack item) {
        if (item.func_77942_o()) {
            NBTTagCompound tag = item.func_77978_p();
            if (tag.func_74764_b("enchant-set")) {
                return tag.func_74767_n("enchant-set");
            }
            tag.func_74757_a("enchant-set", false);
            item.func_77982_d(tag);
        }
        return false;
    }
}

