/*
 * Decompiled with CFR 0.152.
 */
package com.wildmobsmod.main;

import com.wildmobsmod.bison.RegisterBison;
import com.wildmobsmod.blocks.WildMobsModBlocks;
import com.wildmobsmod.cougar.RegisterCougar;
import com.wildmobsmod.deer.RegisterDeer;
import com.wildmobsmod.fox.RegisterFox;
import com.wildmobsmod.items.WildMobsModItems;
import com.wildmobsmod.main.CraftingManager;
import com.wildmobsmod.main.ServerProxy;
import com.wildmobsmod.spell.RegisterSpell;
import com.wildmobsmod.wizard.RegisterWizard;
import com.wildmobsmod.zomgus.RegisterZomgus;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="wildmobsmod", name="Wild Mobs Mod", version="1.1")
public class MainRegistry {
    @SidedProxy(clientSide="com.wildmobsmod.main.ClientProxy", serverSide="com.wildmobsmod.main.ServerProxy")
    public static ServerProxy proxy;
    public static Configuration config;
    public static int deerSpawnRate;
    public static int foxSpawnRate;
    public static int cougarSpawnRate;
    public static int cougarAttackChance;
    public static int chimpanzeeSpawnRate;
    public static int bisonSpawnRate;
    public static boolean enableDeer;
    public static boolean enableFox;
    public static boolean enableCougar;
    public static boolean enableZomgus;
    public static boolean enableBison;
    public static boolean enableWizard;
    public static boolean cougarHideIntoLeather;
    public static boolean enableElkVariant;
    public static boolean enableReindeerVariant;
    public static boolean enableArcticFoxVariant;
    public static boolean deerSpawnInMegaTaigas;
    public static boolean deerSpawnInColdBiomes;
    public static boolean foxesSpawnInColdBiomes;
    public static final String CATEGORY_DEER = "Deer";
    public static final String CATEGORY_FOX = "Fox";
    public static final String CATEGORY_COUGAR = "Cougar";
    public static final String CATEGORY_ZOMGUS = "Zomgus";
    public static final String CATEGORY_BISON = "Bison";
    public static final String CATEGORY_WIZARD = "Wizard";
    @Mod.Metadata
    public static ModMetadata meta;
    @Mod.Instance(value="wildmobsmod")
    public static MainRegistry modInstance;

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        MainRegistry.syncConfig();
        FMLCommonHandler.instance().bus().register((Object)modInstance);
        WildMobsModItems.mainRegistry();
        WildMobsModBlocks.mainRegistry();
        CraftingManager.mainRegistry();
        RegisterDeer.mainRegistry();
        RegisterFox.mainRegistry();
        RegisterCougar.mainRegistry();
        RegisterZomgus.mainRegistry();
        RegisterBison.mainRegistry();
        RegisterWizard.mainRegistry();
        RegisterSpell.mainRegistry();
        proxy.registerRenderThings();
    }

    public static void syncConfig() {
        deerSpawnRate = config.getInt("deerSpawnRate", CATEGORY_DEER, deerSpawnRate, 0, 100, "Deer spawn chance.");
        foxSpawnRate = config.getInt("foxSpawnRate", CATEGORY_FOX, foxSpawnRate, 0, 100, "Fox spawn chance.");
        cougarSpawnRate = config.getInt("cougarSpawnRate", CATEGORY_COUGAR, cougarSpawnRate, 0, 100, "Cougar spawn chance.");
        cougarAttackChance = config.getInt("cougarAttackChance", CATEGORY_COUGAR, cougarAttackChance, 0, 10000, "Sets the chance of cougars attacking the player. Smaller the value, bigger the chance. The value is multiplied by 1.8 on peaceful difficulty, 1.4 on easy, 1.0 on normal and 0.6 on hard.");
        bisonSpawnRate = config.getInt("bisonSpawnRate", CATEGORY_BISON, bisonSpawnRate, 0, 100, "Bison spawn chance.");
        enableDeer = config.getBoolean("enableDeer", CATEGORY_DEER, enableDeer, "Enable/disable deer.");
        enableFox = config.getBoolean("enableFox", CATEGORY_FOX, enableFox, "Enable/disable fox.");
        enableCougar = config.getBoolean("enableCougar", CATEGORY_COUGAR, enableCougar, "Enable/disable cougar.");
        enableZomgus = config.getBoolean("enableZomgus", CATEGORY_ZOMGUS, enableZomgus, "Enable/disable zomgus.");
        enableBison = config.getBoolean("enableBison", CATEGORY_BISON, enableBison, "Enable/disable bison.");
        enableWizard = config.getBoolean("enableWizard", CATEGORY_WIZARD, enableWizard, "Enable/disable wizard.");
        enableElkVariant = config.getBoolean("enableElkVariant", CATEGORY_DEER, enableElkVariant, "Enable/disable elk variant of deer. (Deer can still spawn in mega taigas, if deerSpawnInMegaTaigas is not disabled)");
        enableReindeerVariant = config.getBoolean("enableReindeerVariant", CATEGORY_DEER, enableReindeerVariant, "Enable/disable reindeer variant of deer. (Deer can still spawn in cold taigas, ice plains, ice mountains and extreme hills, if deerSpawnInColdBiomes is not disabled)");
        cougarHideIntoLeather = config.getBoolean("cougarHideIntoLeather", CATEGORY_COUGAR, cougarHideIntoLeather, "If set to true, cougar hide can be crafted into leather instead of fur.");
        deerSpawnInMegaTaigas = config.getBoolean("deerSpawnInMegaTaigas", CATEGORY_DEER, deerSpawnInMegaTaigas, "Can deer spawn in mega taigas?");
        deerSpawnInColdBiomes = config.getBoolean("deerSpawnInColdBiomes", CATEGORY_DEER, deerSpawnInColdBiomes, "Can deer spawn in cold taigas, ice plains, ice mountains and extreme hills?");
        enableArcticFoxVariant = config.getBoolean("enableArcticFoxVariant", CATEGORY_FOX, enableArcticFoxVariant, "Enable/disable arctic foxes. (Foxes can still spawn in cold taigas, ice plains and ice mountains, if foxesSpawnInColdBiomes is not disabled)");
        foxesSpawnInColdBiomes = config.getBoolean("foxesSpawnInColdBiomes", CATEGORY_FOX, foxesSpawnInColdBiomes, "Can foxes spawn in cold taigas, ice plains and ice mountains?");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("wildmobsmod")) {
            MainRegistry.syncConfig();
        }
    }

    static {
        deerSpawnRate = 8;
        foxSpawnRate = 7;
        cougarSpawnRate = 6;
        cougarAttackChance = 120;
        chimpanzeeSpawnRate = 12;
        bisonSpawnRate = 5;
        enableDeer = true;
        enableFox = true;
        enableCougar = true;
        enableZomgus = true;
        enableBison = true;
        enableWizard = true;
        cougarHideIntoLeather = false;
        enableElkVariant = true;
        enableReindeerVariant = true;
        enableArcticFoxVariant = true;
        deerSpawnInMegaTaigas = true;
        deerSpawnInColdBiomes = true;
        foxesSpawnInColdBiomes = true;
    }
}

