/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.buff;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.darkhax.bookshelf.buff.BuffEffect;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.bookshelf.lib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class Buff {
    private ResourceLocation icon;
    private ResourceLocation iconMap;
    private ItemStack iconStack;
    private int statusIconIndex;
    private String potionName;
    private boolean isBad;
    private int color;

    public Buff(String potionName, boolean isBad, int color, ResourceLocation icon) {
        this.potionName = potionName;
        this.isBad = isBad;
        this.color = color;
        this.icon = icon;
    }

    public Buff(String potionName, boolean isBad, int color, ResourceLocation iconMap, int iconIndex) {
        this.potionName = potionName;
        this.isBad = isBad;
        this.color = color;
        this.iconMap = iconMap;
        this.setIconIndex(iconIndex % 8, iconIndex / 8);
    }

    public Buff(String potionName, boolean isBad, int color, ItemStack iconStack) {
        this.potionName = potionName;
        this.isBad = isBad;
        this.color = color;
        this.iconStack = iconStack;
    }

    public Buff(String potionName, boolean isBad, int color) {
        this.potionName = potionName;
        this.isBad = isBad;
        this.color = color;
    }

    private void setIconIndex(int x, int y) {
        this.statusIconIndex = x + y * 8;
    }

    public boolean canUpdate() {
        return false;
    }

    public void onBuffTick(World world, EntityLivingBase entity, int duration, int power) {
    }

    public void onEffectEnded() {
    }

    public boolean shouldBeCured(EntityLivingBase entity, ItemStack stack) {
        return ItemStackUtils.isValidStack(stack) && stack.func_77973_b() == Items.field_151117_aB;
    }

    public boolean shouldRenderInvText(BuffEffect effect) {
        return true;
    }

    public int getStatusIconIndex() {
        return this.statusIconIndex;
    }

    public String getPotionName() {
        return this.potionName;
    }

    public String getTranslatedName() {
        return StatCollector.func_74838_a((String)("potion." + this.potionName + ".name"));
    }

    public boolean hasStatusIcon() {
        return this.icon != null || this.iconStack != null || this.iconMap != null || this.statusIconIndex >= 0;
    }

    public ResourceLocation getStatusIcon() {
        return this.icon;
    }

    public ResourceLocation getIconMap() {
        return this.iconMap;
    }

    public ItemStack getIconStack() {
        return this.iconStack;
    }

    public boolean isEffectBad() {
        return this.isBad;
    }

    public int getColor() {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, BuffEffect effect, Minecraft mc) {
        if (this.icon != null) {
            mc.field_71446_o.func_110577_a(this.icon);
            RenderUtils.drawTextureModalRectSize(x + 6, y + 7, 0, 0, 18, 18, 18.0f, 1.0f);
        } else if (ItemStackUtils.isValidStack(this.iconStack)) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(Minecraft.func_71410_x().field_71446_o.func_130087_a(1));
            mc.field_71462_r.func_94065_a(x + 8, y + 8, this.iconStack.func_77954_c(), 16, 16);
        } else if (this.iconMap != null) {
            int index = this.getStatusIconIndex();
            mc.field_71446_o.func_110577_a(this.iconMap);
            RenderUtils.drawTextureModalRectSize(x + 6, y + 7, index % 8 * 18, index / 8 * 18, 18, 18, 144.0f, 1.0f);
        }
    }
}

