/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public final class ReflectionUtils {
    private static Map<String, Method> cachedMethods = Maps.newHashMap();
    private static Map<String, Field> cachedFields = Maps.newHashMap();

    public static boolean doesClassExist(String className) {
        try {
            Class.forName(className, false, null);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static <T> Class<T> getClass(String className) {
        try {
            return (Class)ReflectionUtils.getCasted(Class.forName(className));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T, E> void setCachedFieldValue(Class<? super E> classToAccess, E instance, String mcpName, String srgName, T value) {
        Field field = ReflectionUtils.getCachedField(classToAccess, mcpName, srgName);
        try {
            field.set(instance, value);
        }
        catch (Throwable exception) {
            throw new UnableToSetFieldException(exception);
        }
    }

    public static <T, E> T getCachedFieldValue(Class<? super E> classToAccess, E instance, String mcpName, String srgName) {
        Field field = ReflectionUtils.getCachedField(classToAccess, mcpName, srgName);
        try {
            return (T)field.get(instance);
        }
        catch (Exception exception) {
            throw new UnableToGetFieldException(exception);
        }
    }

    public static <T, E> T invokeCachedMethod(Class<? super E> classToAccess, E instance, String mcpName, String srgName, Class<?>[] parameterTypes, Object[] parameterValues) {
        Method method = ReflectionUtils.getCachedMethod(classToAccess, mcpName, srgName, parameterTypes);
        try {
            return (T)method.invoke(instance, parameterValues);
        }
        catch (Exception exception) {
            throw new UnableToInvokeMethodException(exception);
        }
    }

    public static Field getCachedField(Class<?> classToAccess, String mcpName, String srgName) {
        String key = classToAccess.getCanonicalName() + '_' + srgName;
        if (cachedFields.containsKey(key)) {
            return cachedFields.get(key);
        }
        return ReflectionUtils.cacheAccessedField(classToAccess, mcpName, srgName);
    }

    private static Field cacheAccessedField(Class<?> classToAccess, String mcpName, String srgName) {
        String key = classToAccess.getCanonicalName() + '_' + srgName;
        try {
            Field method = classToAccess.getDeclaredField(srgName);
            method.setAccessible(true);
            cachedFields.put(key, method);
            return method;
        }
        catch (Throwable ex1) {
            try {
                Field method = classToAccess.getDeclaredField(mcpName);
                method.setAccessible(true);
                cachedFields.put(key, method);
                return method;
            }
            catch (Throwable ex2) {
                throw new UnableToFindFieldException(ex2);
            }
        }
    }

    public static Method getCachedMethod(Class<?> classToAccess, String mcpName, String srgName, Class<?> ... parameterTypes) {
        String key = classToAccess.getCanonicalName() + '_' + srgName;
        if (cachedMethods.containsKey(key)) {
            return cachedMethods.get(key);
        }
        return ReflectionUtils.cacheAccessedMethod(classToAccess, mcpName, srgName, parameterTypes);
    }

    private static Method cacheAccessedMethod(Class<?> classToAccess, String mcpName, String srgName, Class<?> ... parameterTypes) {
        String key = classToAccess.getCanonicalName() + '_' + srgName;
        try {
            Method method = classToAccess.getDeclaredMethod(srgName, parameterTypes);
            method.setAccessible(true);
            cachedMethods.put(key, method);
            return method;
        }
        catch (Throwable ex1) {
            try {
                Method method = classToAccess.getDeclaredMethod(mcpName, parameterTypes);
                method.setAccessible(true);
                cachedMethods.put(key, method);
                return method;
            }
            catch (Throwable ex2) {
                throw new UnableToFindMethodException(ex2);
            }
        }
    }

    public static <T> T getCasted(Object obj) {
        return (T)obj;
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        public UnableToFindFieldException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToFindMethodException
    extends RuntimeException {
        public UnableToFindMethodException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToInvokeMethodException
    extends RuntimeException {
        public UnableToInvokeMethodException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToGetFieldException
    extends RuntimeException {
        public UnableToGetFieldException(Throwable exception) {
            super(exception);
        }
    }

    public static class UnableToSetFieldException
    extends RuntimeException {
        public UnableToSetFieldException(Throwable exception) {
            super(exception);
        }
    }
}

