/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import com.google.common.collect.ArrayListMultimap;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageMarketList
implements IMessage {
    private ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap;

    public MessageMarketList() {
    }

    public MessageMarketList(ArrayListMultimap<IMarketCategory, IMarketEntry> entryMap) {
        this.entryMap = entryMap;
    }

    public void fromBytes(ByteBuf buf) {
        this.entryMap = ArrayListMultimap.create();
        int categoryCount = buf.readByte();
        for (int i = 0; i < categoryCount; ++i) {
            ResourceLocation categoryId = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
            IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategory(categoryId);
            if (category == null) {
                category = FarmingForBlockheadsAPI.getMarketCategoryOther();
            }
            int entryCount = buf.readShort();
            for (int j = 0; j < entryCount; ++j) {
                this.entryMap.put((Object)category, (Object)this.readEntry(buf, category));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.entryMap.keySet().size());
        for (IMarketCategory category : this.entryMap.keySet()) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)category.getRegistryName().toString());
            List entries = this.entryMap.get((Object)category);
            buf.writeShort(entries.size());
            for (IMarketEntry entry : entries) {
                this.writeEntry(entry, buf);
            }
        }
    }

    public ArrayListMultimap<IMarketCategory, IMarketEntry> getEntryMap() {
        return this.entryMap;
    }

    private MarketEntry readEntry(ByteBuf buf, IMarketCategory category) {
        ItemStack outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        ItemStack costItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        return new MarketEntry(outputItem, costItem, category);
    }

    private void writeEntry(IMarketEntry entry, ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)entry.getOutputItem());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)entry.getCostItem());
    }
}

