/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.screen;

import java.lang.reflect.Method;
import java.nio.DoubleBuffer;
import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import micdoodle8.mods.galacticraft.api.entity.ITelemetry;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderPlayerGC;
import micdoodle8.mods.galacticraft.core.client.screen.DrawGameScreen;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GameScreenText
implements IGameScreen {
    private float frameA;
    private float frameBx;
    private float frameBy;
    private int yPos;
    private DoubleBuffer planes;
    private Method renderModelMethod;
    private Method renderLayersMethod;

    public GameScreenText() {
        if (GCCoreUtil.getEffectiveSide().isClient()) {
            this.planes = BufferUtils.createDoubleBuffer((int)256);
            try {
                Class<RenderLivingBase> clazz = RenderLivingBase.class;
                boolean count = false;
                for (Method m : clazz.getDeclaredMethods()) {
                    String s = m.getName();
                    if (s.equals(GCCoreUtil.isDeobfuscated() ? "renderModel" : "func_77036_a")) {
                        m.setAccessible(true);
                        this.renderModelMethod = m;
                        if (!count) {
                            count = true;
                            continue;
                        }
                    } else {
                        if (!s.equals(GCCoreUtil.isDeobfuscated() ? "renderLayers" : "func_177093_a")) continue;
                        m.setAccessible(true);
                        this.renderLayersMethod = m;
                        if (!count) {
                            count = true;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setFrameSize(float frameSize) {
        this.frameA = frameSize;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(int type, float ticks, float sizeX, float sizeY, IScreenManager scr) {
        DrawGameScreen screen = (DrawGameScreen)scr;
        this.frameBx = sizeX - this.frameA;
        this.frameBy = sizeY - this.frameA;
        this.drawBlackBackground(0.0f);
        this.planeEquation(this.frameA, this.frameA, 0.0f, this.frameA, this.frameBy, 0.0f, this.frameA, this.frameBy, 1.0f);
        GL11.glClipPlane((int)12288, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12288);
        this.planeEquation(this.frameBx, this.frameBy, 0.0f, this.frameBx, this.frameA, 0.0f, this.frameBx, this.frameA, 1.0f);
        GL11.glClipPlane((int)12289, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12289);
        this.planeEquation(this.frameA, this.frameBy, 0.0f, this.frameBx, this.frameBy, 0.0f, this.frameBx, this.frameBy, 1.0f);
        GL11.glClipPlane((int)12290, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12290);
        this.planeEquation(this.frameBx, this.frameA, 0.0f, this.frameA, this.frameA, 0.0f, this.frameA, this.frameA, 1.0f);
        GL11.glClipPlane((int)12291, (DoubleBuffer)this.planes);
        GL11.glEnable((int)12291);
        this.yPos = 0;
        TileEntityTelemetry telemeter = TileEntityTelemetry.getNearest(screen.driver);
        String strName = "";
        String[] str = new String[]{GCCoreUtil.translate("gui.display.nolink"), "", "", "", ""};
        Render renderEntity = null;
        Entity entity = null;
        float Xmargin = 0.0f;
        if (telemeter != null && telemeter.clientData.length >= 3) {
            if (telemeter.clientClass != null) {
                if (telemeter.clientClass == screen.telemetryLastClass && (telemeter.clientClass != EntityPlayerMP.class || telemeter.clientName.equals(screen.telemetryLastName))) {
                    entity = screen.telemetryLastEntity;
                    renderEntity = screen.telemetryLastRender;
                    strName = screen.telemetryLastName;
                } else {
                    entity = null;
                    if (telemeter.clientClass == EntityPlayerMP.class) {
                        strName = telemeter.clientName;
                        entity = new EntityOtherPlayerMP(screen.driver.func_145831_w(), telemeter.clientGameProfile);
                        renderEntity = FMLClientHandler.instance().getClient().func_175598_ae().func_78713_a(entity);
                    } else {
                        try {
                            entity = (Entity)telemeter.clientClass.getConstructor(World.class).newInstance(screen.driver.func_145831_w());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (entity != null) {
                            strName = entity.func_70005_c_();
                        }
                        renderEntity = (Render)FMLClientHandler.instance().getClient().func_175598_ae().field_78729_o.get(telemeter.clientClass);
                    }
                }
                if (entity instanceof EntityHorse) {
                    ((EntityHorse)entity).func_110235_q(telemeter.clientData[4]);
                }
                if (entity instanceof EntityVillager) {
                    ((EntityVillager)entity).func_70938_b(telemeter.clientData[3]);
                    ((EntityVillager)entity).func_70873_a(telemeter.clientData[4]);
                } else if (entity instanceof EntityWolf) {
                    ((EntityWolf)entity).func_175547_a(EnumDyeColor.func_176766_a((int)telemeter.clientData[3]));
                    ((EntityWolf)entity).func_70918_i(telemeter.clientData[4] == 1);
                } else if (entity instanceof EntitySheep) {
                    ((EntitySheep)entity).func_175512_b(EnumDyeColor.func_176766_a((int)telemeter.clientData[3]));
                    ((EntitySheep)entity).func_70893_e(telemeter.clientData[4] == 1);
                } else if (entity instanceof EntityOcelot) {
                    ((EntityOcelot)entity).func_70912_b(telemeter.clientData[3]);
                } else if (!(entity instanceof EntitySkeleton) && entity instanceof EntityZombie) {
                    ((EntityZombie)entity).func_82227_f(telemeter.clientData[4] == 1);
                }
            }
            if (entity instanceof ITelemetry) {
                ((ITelemetry)entity).receiveData(telemeter.clientData, str);
            } else if (entity instanceof EntityLivingBase) {
                str[0] = telemeter.clientData[0] > 0 ? GCCoreUtil.translate("gui.player.ouch") : "";
                str[1] = telemeter.clientData[1] >= 0 ? GCCoreUtil.translate("gui.player.health") + ": " + telemeter.clientData[1] + "%" : "";
                str[2] = "" + telemeter.clientData[2] + " " + GCCoreUtil.translate("gui.player.bpm");
                if (telemeter.clientData[3] > -1) {
                    str[3] = GCCoreUtil.translate("gui.player.food") + ": " + telemeter.clientData[3] + "%";
                }
                if (telemeter.clientData[4] > -1) {
                    int oxygen = telemeter.clientData[4];
                    str[4] = (oxygen = oxygen % 4096 + oxygen / 4096) == 180 || oxygen == 90 ? GCCoreUtil.translate("gui.oxygen_storage.desc.1") + ": OK" : GCCoreUtil.translate("gui.oxygen_storage.desc.1") + ": " + this.makeOxygenString(oxygen) + GCCoreUtil.translate("gui.seconds");
                }
            } else if (telemeter.clientData[2] >= 0) {
                str[2] = GameScreenText.makeSpeedString(telemeter.clientData[2]);
            }
        } else {
            World w1 = screen.driver.func_145831_w();
            int time1 = w1 != null ? (int)((w1.func_72820_D() + 6000L) % 24000L) : 0;
            str[2] = this.makeTimeString(time1 * 360);
        }
        int textWidthPixels = 155;
        int textHeightPixels = 60;
        if (str[3].isEmpty()) {
            textHeightPixels -= 10;
        }
        if (str[4].isEmpty()) {
            textHeightPixels -= 10;
        }
        float borders = this.frameA * 2.0f + 0.05f * Math.min(sizeX, sizeY);
        float scaleXTest = (sizeX - borders) / (float)textWidthPixels;
        float scaleYTest = (sizeY - borders) / (float)textHeightPixels;
        float scale = sizeX;
        if (scaleYTest < scaleXTest) {
            scale = sizeY;
        }
        borders = this.frameA * 2.0f + 0.05f * scale;
        scaleXTest = (sizeX - borders) / (float)textWidthPixels;
        scaleYTest = (sizeY - borders) / (float)textHeightPixels;
        scale = sizeX;
        float scaleText = scaleXTest;
        if (scaleYTest < scaleXTest) {
            scale = sizeY;
            scaleText = scaleYTest;
        }
        float border = this.frameA + 0.025f * scale;
        if (entity != null && renderEntity != null) {
            Xmargin = (sizeX - borders) / 2.0f;
        }
        float Xoffset = (sizeX - borders - (float)textWidthPixels * scaleText) / 2.0f + Xmargin;
        float Yoffset = (sizeY - borders - (float)textHeightPixels * scaleText) / 2.0f + scaleText;
        GL11.glTranslatef((float)(border + Xoffset), (float)(border + Yoffset), (float)0.0f);
        GL11.glScalef((float)scaleText, (float)scaleText, (float)1.0f);
        int whiteColour = ColorUtil.to32BitColor(255, 240, 216, 255);
        this.drawText(strName, whiteColour);
        this.drawText(str[0], whiteColour);
        this.drawText(str[1], whiteColour);
        this.drawText(str[2], whiteColour);
        this.drawText(str[3], whiteColour);
        this.drawText(str[4], whiteColour);
        if (renderEntity != null && entity != null) {
            GL11.glTranslatef((float)(-Xmargin / 2.0f / scaleText), (float)((float)(textHeightPixels / 2) + (-Yoffset + (sizeY - borders) / 2.0f) / scaleText), (float)-5.0E-4f);
            float scalefactor = 38.0f / (float)Math.pow(Math.max(entity.field_70131_O, entity.field_70130_N), 0.65);
            GL11.glScalef((float)scalefactor, (float)scalefactor, (float)0.0015f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (entity instanceof ITelemetry) {
                ((ITelemetry)entity).adjustDisplay(telemeter.clientData);
            }
            RenderPlayerGC.flagThermalOverride = true;
            if (entity instanceof EntityLivingBase && renderEntity instanceof RenderLivingBase && this.renderModelMethod != null) {
                this.renderLiving((EntityLivingBase)entity, (RenderLivingBase)renderEntity, ticks % 1.0f);
            } else {
                renderEntity.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            }
            RenderPlayerGC.flagThermalOverride = false;
        }
        screen.telemetryLastClass = telemeter == null ? null : telemeter.clientClass;
        screen.telemetryLastEntity = entity;
        screen.telemetryLastRender = renderEntity;
        screen.telemetryLastName = strName;
        GL11.glDisable((int)12291);
        GL11.glDisable((int)12290);
        GL11.glDisable((int)12289);
        GL11.glDisable((int)12288);
    }

    private void renderLiving(EntityLivingBase entity, RenderLivingBase render, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        render.func_177087_b().field_78091_s = entity.func_70631_g_();
        try {
            float f = 0.0f;
            float f1 = 0.0f;
            float f2 = f1 - f;
            float f7 = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            float f8 = 0.0f;
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179091_B();
            GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
            float f4 = 0.0625f;
            GlStateManager.func_179109_b((float)0.0f, (float)-1.5078125f, (float)0.0f);
            float f5 = entity.field_184618_aE + (entity.field_70721_aZ - entity.field_184618_aE) * partialTicks;
            float f6 = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - partialTicks);
            if (entity.func_70631_g_()) {
                f6 *= 3.0f;
            }
            if (f5 > 1.0f) {
                f5 = 1.0f;
            }
            GlStateManager.func_179141_d();
            render.func_177087_b().func_78086_a(entity, f6, f5, partialTicks);
            render.func_177087_b().func_78087_a(f6, f5, f8, f2, f7, 0.0625f, (Entity)entity);
            this.renderModelMethod.invoke((Object)render, entity, Float.valueOf(f6), Float.valueOf(f5), Float.valueOf(f8), Float.valueOf(f2), Float.valueOf(f7), Float.valueOf(0.0625f));
            GlStateManager.func_179132_a((boolean)true);
            this.renderLayersMethod.invoke((Object)render, entity, Float.valueOf(f6), Float.valueOf(f5), Float.valueOf(partialTicks), Float.valueOf(f8), Float.valueOf(f2), Float.valueOf(f7), Float.valueOf(0.0625f));
            GlStateManager.func_179101_C();
        }
        catch (Exception exception) {
            // empty catch block
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private String makeTimeString(int l) {
        int hrs = l / 360000;
        int mins = l / 6000 - hrs * 60;
        int secs = l / 100 - hrs * 3600 - mins * 60;
        String hrsStr = hrs > 9 ? "" + hrs : "0" + hrs;
        String minsStr = mins > 9 ? "" + mins : "0" + mins;
        String secsStr = secs > 9 ? "" + secs : "0" + secs;
        return hrsStr + ":" + minsStr + ":" + secsStr;
    }

    public static String makeSpeedString(int speed100) {
        int sp1 = speed100 / 100;
        int sp2 = speed100 % 100;
        String spstr1 = GCCoreUtil.translate("gui.rocket.speed") + ": " + sp1;
        String spstr2 = (sp2 > 9 ? "" : "0") + sp2;
        return spstr1 + "." + spstr2 + " " + GCCoreUtil.translate("gui.lander.velocityu");
    }

    private String makeOxygenString(int oxygen) {
        int sp1 = oxygen * 9 / 20;
        int sp2 = oxygen * 9 % 20 / 2;
        String spstr1 = "" + sp1;
        String spstr2 = "" + sp2;
        return spstr1 + "." + spstr2;
    }

    private void drawText(String str, int colour) {
        Minecraft.func_71410_x().field_71466_p.func_175065_a(str, 0.0f, (float)this.yPos, colour, false);
        this.yPos += 10;
    }

    private void drawBlackBackground(float greyLevel) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        GL11.glColor4f((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameBy, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameBx, (double)this.frameA, (double)0.005f).func_181675_d();
        worldRenderer.func_181662_b((double)this.frameA, (double)this.frameA, (double)0.005f).func_181675_d();
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }

    private void planeEquation(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        double[] result = new double[]{y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2), z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2), x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2), -(x1 * (y2 * z3 - y3 * z2) + x2 * (y3 * z1 - y1 * z3) + x3 * (y1 * z2 - y2 * z1))};
        this.planes.put(result, 0, 4);
        this.planes.position(0);
    }
}

