/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.tbintegration.tan;

import com.tiviacz.travelersbackpack.api.fluids.effects.FluidEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.ISyncedOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.api.thirst.WaterType;
import toughasnails.thirst.ThirstHandler;

public class TANPurifiedWaterEffect
extends FluidEffect {
    public static TANPurifiedWaterEffect PURIFIED_WATER_EFFECT;

    public TANPurifiedWaterEffect() {
        super("purified_water", 250);
    }

    public void affectDrinker(FluidStack fluidStack, World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            IThirst thirst = ThirstHelper.getThirstData((EntityPlayer)player);
            WaterType type = WaterType.PURIFIED;
            thirst.addStats(type.getThirst(), type.getHydration());
            this.addEffects(player, type);
        }
    }

    private void addEffects(EntityPlayer player, WaterType type) {
        if (player.field_70170_p.field_73012_v.nextFloat() < type.getPoisonChance() && SyncedConfig.getBooleanValue((ISyncedOption)GameplayOption.ENABLE_THIRST)) {
            player.func_70690_d(new PotionEffect(TANPotions.thirst, 600));
        }
    }

    public boolean canExecuteEffect(FluidStack fluidStack, World world, Entity entity) {
        if (entity instanceof EntityPlayer) {
            ThirstHandler thirstHandler = (ThirstHandler)ThirstHelper.getThirstData((EntityPlayer)((EntityPlayer)entity));
            return thirstHandler.isThirsty();
        }
        return false;
    }

    public static void registerEffect() {
        PURIFIED_WATER_EFFECT = new TANPurifiedWaterEffect();
    }
}

