/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen;

import com.badlogic.gdx.jnigen.AntPathMatcher;
import com.badlogic.gdx.jnigen.BuildConfig;
import com.badlogic.gdx.jnigen.BuildTarget;
import com.badlogic.gdx.jnigen.FileDescriptor;
import java.util.ArrayList;

public class AndroidNdkScriptGenerator {
    public void generate(BuildConfig config, BuildTarget target) {
        if (target.os != BuildTarget.TargetOs.Android) {
            throw new IllegalArgumentException("target os must be Android");
        }
        if (!config.libsDir.exists() && !config.libsDir.mkdirs()) {
            throw new RuntimeException("Couldn't create directory for shared library files in '" + config.libsDir + "'");
        }
        if (!config.jniDir.exists() && !config.jniDir.mkdirs()) {
            throw new RuntimeException("Couldn't create native code directory '" + config.jniDir + "'");
        }
        ArrayList<FileDescriptor> files = new ArrayList<FileDescriptor>();
        int idx = 0;
        String[] includes = new String[target.cIncludes.length + target.cppIncludes.length];
        for (String include : target.cIncludes) {
            includes[idx++] = config.jniDir + "/" + include;
        }
        for (String include : target.cppIncludes) {
            includes[idx++] = config.jniDir + "/" + include;
        }
        idx = 0;
        String[] excludes = new String[target.cExcludes.length + target.cppExcludes.length + 1];
        for (String exclude : target.cExcludes) {
            excludes[idx++] = config.jniDir + "/" + exclude;
        }
        for (String exclude : target.cppExcludes) {
            excludes[idx++] = config.jniDir + "/" + exclude;
        }
        excludes[idx] = "**/target/*";
        this.gatherSourceFiles(config.jniDir, includes, excludes, files);
        FileDescriptor application = config.jniDir.child("Application.mk");
        application.writeString(new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/Application.mk.template", FileDescriptor.FileType.Classpath).readString(), false);
        String template = new FileDescriptor("com/badlogic/gdx/jnigen/resources/scripts/Android.mk.template", FileDescriptor.FileType.Classpath).readString();
        StringBuilder srcFiles = new StringBuilder();
        for (int i = 0; i < files.size(); ++i) {
            if (i > 0) {
                srcFiles.append("\t");
            }
            srcFiles.append(files.get(i).path().replace('\\', '/').replace(config.jniDir.toString() + "/", ""));
            if (i < files.size() - 1) {
                srcFiles.append("\\\n");
                continue;
            }
            srcFiles.append("\n");
        }
        StringBuilder headerDirs = new StringBuilder();
        for (String headerDir : target.headerDirs) {
            headerDirs.append(headerDir);
            headerDirs.append(" ");
        }
        template = template.replace("%sharedLibName%", config.sharedLibName);
        template = template.replace("%headerDirs%", headerDirs);
        template = template.replace("%cFlags%", target.cFlags);
        template = template.replace("%cppFlags%", target.cppFlags);
        template = template.replace("%linkerFlags%", target.linkerFlags);
        template = template.replace("%srcFiles%", srcFiles);
        config.jniDir.child("Android.mk").writeString(template, false);
    }

    private void gatherSourceFiles(FileDescriptor file, String[] includes, String[] excludes, ArrayList<FileDescriptor> files) {
        String fileName = file.path().replace('\\', '/');
        if (file.isDirectory()) {
            if (this.match(fileName, excludes)) {
                return;
            }
            for (FileDescriptor child : file.list()) {
                this.gatherSourceFiles(child, includes, excludes, files);
            }
        } else if (this.match(fileName, includes) && !this.match(fileName, excludes)) {
            files.add(file);
        }
    }

    private boolean match(String file, String[] patterns) {
        return new AntPathMatcher().match(file, patterns);
    }
}

