/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.jnigen.parsing;

import com.badlogic.gdx.jnigen.parsing.CMethodParser;
import java.util.ArrayList;

public class JniHeaderCMethodParser
implements CMethodParser {
    private static final String C_METHOD_MARKER = "JNIEXPORT";

    @Override
    public CMethodParser.CMethodParserResult parse(String headerFile) {
        ArrayList<CMethodParser.CMethod> methods = new ArrayList<CMethodParser.CMethod>();
        int index = headerFile.indexOf(C_METHOD_MARKER);
        if (index == -1) {
            return null;
        }
        while (index >= 0) {
            CMethodParser.CMethod method = this.parseCMethod(headerFile, index);
            if (method == null) {
                throw new RuntimeException("Couldn't parse method");
            }
            methods.add(method);
            index = headerFile.indexOf(C_METHOD_MARKER, method.endIndex);
        }
        return new CMethodParser.CMethodParserResult(methods);
    }

    private CMethodParser.CMethod parseCMethod(String headerFile, int start) {
        int headEnd = headerFile.indexOf(40, start);
        String head = headerFile.substring(start, headEnd).trim();
        String returnType = head.split(" ")[1].trim();
        int argsStart = headEnd + 1;
        int argsEnd = headerFile.indexOf(41, argsStart);
        String[] args = headerFile.substring(argsStart, argsEnd).split(",");
        return new CMethodParser.CMethod(returnType, head, args, start, argsEnd + 1);
    }
}

