/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.client.BindingRegistry;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.settings.IKeyConflictContext;

public class ButtonBinding
implements Comparable<ButtonBinding> {
    private final int defaultButton;
    private int button;
    private String descriptionKey;
    private String category;
    private IKeyConflictContext context;
    private boolean pressed;
    private int pressedTime;
    private boolean reserved;

    public ButtonBinding(int button, String descriptionKey, String category, IKeyConflictContext context) {
        this(button, descriptionKey, category, context, false);
    }

    ButtonBinding(int button, String descriptionKey, String category, IKeyConflictContext context, boolean reserved) {
        this.defaultButton = button;
        this.button = button;
        this.descriptionKey = descriptionKey;
        this.category = category;
        this.context = context;
        this.reserved = reserved;
    }

    public int getButton() {
        return this.button;
    }

    public void setButton(int button) {
        this.button = button;
    }

    public String getDescription() {
        return this.descriptionKey;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean isDefault() {
        return this.button == this.defaultButton;
    }

    public boolean isButtonPressed() {
        return this.pressed && this.pressedTime == 0 && this.isActiveAndValidContext();
    }

    public boolean isNotReserved() {
        return !this.reserved;
    }

    public boolean isButtonDown() {
        return this.pressed && this.isActiveAndValidContext();
    }

    public void reset() {
        this.button = this.defaultButton;
    }

    public static void tick() {
        for (ButtonBinding binding : BindingRegistry.getInstance().getRegisteredBindings()) {
            if (!binding.isButtonDown()) continue;
            --binding.pressedTime;
        }
    }

    public static void setButtonState(int button, boolean state) {
        List<ButtonBinding> bindings = BindingRegistry.getInstance().getBindingListForButton(button);
        for (ButtonBinding binding : bindings) {
            binding.pressed = state;
            if (!state) continue;
            binding.pressedTime = 0;
        }
    }

    public static void resetButtonStates() {
        for (ButtonBinding binding : BindingRegistry.getInstance().getRegisteredBindings()) {
            binding.pressed = false;
        }
    }

    @Override
    public int compareTo(ButtonBinding o) {
        return I18n.func_135052_a((String)this.descriptionKey, (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)o.descriptionKey, (Object[])new Object[0]));
    }

    public boolean isConflictingContext() {
        List<ButtonBinding> bindings = BindingRegistry.getInstance().getBindingListForButton(this.button);
        if (bindings == null) {
            return false;
        }
        for (ButtonBinding binding : bindings) {
            if (!this.conflicts(binding)) continue;
            return true;
        }
        return false;
    }

    private boolean isActiveAndValidContext() {
        return this.context.isActive() && !this.isConflictingContext();
    }

    private boolean conflicts(ButtonBinding binding) {
        return this != binding && this.button == binding.getButton() && this.context.conflicts(binding.context);
    }

    public int hashCode() {
        return this.descriptionKey.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

