/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.badlogic.gdx.controllers.Controller;
import com.mrcrayfish.controllable.client.IControllerListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.libsdl.SDL_Error;
import uk.co.electronstudio.sdl2gdx.SDL2Controller;
import uk.co.electronstudio.sdl2gdx.SDL2ControllerManager;

public class ControllerManager {
    private SDL2ControllerManager manager = new SDL2ControllerManager();
    private Set<IControllerListener> listeners = new HashSet<IControllerListener>();
    private Map<Integer, String> controllers = new HashMap<Integer, String>();

    public void update() {
        try {
            this.manager.pollState();
        }
        catch (SDL_Error error) {
            error.printStackTrace();
        }
        int connectedCount = 0;
        for (Controller controller : this.manager.getControllers()) {
            if (!(controller instanceof SDL2Controller)) continue;
            ++connectedCount;
        }
        if (connectedCount == this.controllers.size()) {
            return;
        }
        Map<Integer, String> oldControllers = this.controllers;
        HashMap<Integer, String> newControllers = new HashMap<Integer, String>();
        for (int i = 0; i < this.manager.getControllers().size; ++i) {
            Controller controller = this.manager.getControllers().get(i);
            if (!(controller instanceof SDL2Controller)) continue;
            SDL2Controller sdl2Controller = (SDL2Controller)controller;
            newControllers.put(sdl2Controller.joystick.instanceID.id, sdl2Controller.getName());
        }
        this.controllers = newControllers;
        newControllers.forEach((jid, pair) -> {
            if (!oldControllers.containsKey(jid)) {
                this.listeners.forEach(listener -> listener.connected((int)jid));
            }
        });
        oldControllers.forEach((jid, pair) -> {
            if (!newControllers.containsKey(jid)) {
                this.listeners.forEach(listener -> listener.disconnected((int)jid));
            }
        });
    }

    @Nullable
    public String getName(int jid) {
        return this.controllers.get(jid);
    }

    @Nullable
    public SDL2Controller getSDL2ControllerById(int jid) {
        for (Controller controller : this.manager.getControllers()) {
            if (!(controller instanceof SDL2Controller) || ((SDL2Controller)controller).joystick.instanceID.id != jid) continue;
            return (SDL2Controller)controller;
        }
        return null;
    }

    public int getFirstControllerJid() {
        for (Controller controller : this.manager.getControllers()) {
            if (!(controller instanceof SDL2Controller)) continue;
            return ((SDL2Controller)controller).joystick.instanceID.id;
        }
        return -1;
    }

    public Map<Integer, String> getControllers() {
        return this.controllers;
    }

    public int getControllerCount() {
        return this.controllers.size();
    }

    public void addControllerListener(IControllerListener listener) {
        this.listeners.add(listener);
    }

    public void close() {
        this.manager.close();
    }
}

