/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.client.ActionVisibility;
import com.mrcrayfish.controllable.client.ButtonBinding;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.event.AvailableActionsEvent;
import com.mrcrayfish.controllable.event.GatherActionsEvent;
import com.mrcrayfish.controllable.event.RenderAvailableActionsEvent;
import com.mrcrayfish.controllable.event.RenderPlayerPreviewEvent;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.BlockContainer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RenderEvents {
    public static final ResourceLocation CONTROLLER_BUTTONS = new ResourceLocation("controllable", "textures/gui/buttons.png");
    private Map<Integer, Action> actions = new HashMap<Integer, Action>();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71439_g != null && !mc.field_71474_y.field_74319_N) {
            boolean verbose;
            this.actions.clear();
            LinkedHashMap<ButtonBinding, Action> actionMap = new LinkedHashMap<ButtonBinding, Action>();
            ActionVisibility visibility = Controllable.getOptions().getActionVisibility();
            if (visibility == ActionVisibility.NONE) {
                return;
            }
            boolean bl = verbose = visibility == ActionVisibility.ALL;
            if (mc.field_71462_r instanceof GuiContainer) {
                if (mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                    Slot slot;
                    GuiContainer container = (GuiContainer)mc.field_71462_r;
                    if (container.getSlotUnderMouse() != null && (slot = container.getSlotUnderMouse()).func_75216_d()) {
                        actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.pickup_stack", (Object[])new Object[0]), Action.Side.LEFT));
                        actionMap.put(ButtonBindings.SPLIT_STACK, new Action(I18n.func_135052_a((String)"controllable.action.pickup_item", (Object[])new Object[0]), Action.Side.LEFT));
                        actionMap.put(ButtonBindings.QUICK_MOVE, new Action(I18n.func_135052_a((String)"controllable.action.quick_move", (Object[])new Object[0]), Action.Side.LEFT));
                    }
                } else {
                    actionMap.put(ButtonBindings.PICKUP_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.place_stack", (Object[])new Object[0]), Action.Side.LEFT));
                    actionMap.put(ButtonBindings.SPLIT_STACK, new Action(I18n.func_135052_a((String)"controllable.action.place_item", (Object[])new Object[0]), Action.Side.LEFT));
                }
                actionMap.put(ButtonBindings.INVENTORY, new Action(I18n.func_135052_a((String)"controllable.action.close_inventory", (Object[])new Object[0]), Action.Side.RIGHT));
            } else if (mc.field_71462_r == null) {
                ItemStack currentItem;
                ItemStack offHandStack;
                boolean blockHit = mc.field_71476_x != null && mc.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK;
                boolean canOpenBlock = false;
                if (blockHit) {
                    canOpenBlock = mc.field_71441_e.func_180495_p(mc.field_71476_x.func_178782_a()).func_177230_c() instanceof BlockContainer;
                }
                if (!mc.field_71439_g.func_184587_cr()) {
                    if (blockHit) {
                        actionMap.put(ButtonBindings.ATTACK, new Action(I18n.func_135052_a((String)"controllable.action.break", (Object[])new Object[0]), Action.Side.RIGHT));
                    } else {
                        actionMap.put(ButtonBindings.ATTACK, new Action(I18n.func_135052_a((String)"controllable.action.attack", (Object[])new Object[0]), Action.Side.RIGHT));
                    }
                }
                if ((offHandStack = mc.field_71439_g.func_184592_cb()).func_77975_n() != EnumAction.NONE) {
                    switch (offHandStack.func_77975_n()) {
                        case EAT: {
                            if (!mc.field_71439_g.func_71024_bL().func_75121_c()) break;
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.eat", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case DRINK: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.drink", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case BLOCK: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.block", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case BOW: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.pull_bow", (Object[])new Object[0]), Action.Side.RIGHT));
                        }
                    }
                }
                if ((currentItem = mc.field_71439_g.field_71071_by.func_70448_g()).func_77975_n() != EnumAction.NONE) {
                    switch (currentItem.func_77975_n()) {
                        case EAT: {
                            if (!mc.field_71439_g.func_71024_bL().func_75121_c()) break;
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.eat", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case DRINK: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.drink", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case BLOCK: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.block", (Object[])new Object[0]), Action.Side.RIGHT));
                            break;
                        }
                        case BOW: {
                            actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.pull_bow", (Object[])new Object[0]), Action.Side.RIGHT));
                        }
                    }
                } else if (currentItem.func_77973_b() instanceof ItemBlock) {
                    if (blockHit) {
                        actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.place_block", (Object[])new Object[0]), Action.Side.RIGHT));
                    }
                } else if (!currentItem.func_190926_b() && !mc.field_71439_g.func_184587_cr()) {
                    actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.use_item", (Object[])new Object[0]), Action.Side.RIGHT));
                }
                if (!mc.field_71439_g.func_70093_af() && blockHit && canOpenBlock && !mc.field_71439_g.func_184587_cr()) {
                    actionMap.put(ButtonBindings.USE_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.interact", (Object[])new Object[0]), Action.Side.RIGHT));
                }
                if (verbose) {
                    actionMap.put(ButtonBindings.JUMP, new Action(I18n.func_135052_a((String)"controllable.action.jump", (Object[])new Object[0]), Action.Side.LEFT));
                }
                actionMap.put(ButtonBindings.INVENTORY, new Action(I18n.func_135052_a((String)"controllable.action.inventory", (Object[])new Object[0]), Action.Side.LEFT));
                if (!(!verbose || mc.field_71439_g.func_184592_cb().func_190926_b() && mc.field_71439_g.field_71071_by.func_70448_g().func_190926_b())) {
                    actionMap.put(ButtonBindings.SWAP_HANDS, new Action(I18n.func_135052_a((String)"controllable.action.swap_hands", (Object[])new Object[0]), Action.Side.LEFT));
                }
                if (mc.field_71439_g.func_184218_aH()) {
                    actionMap.put(ButtonBindings.SNEAK, new Action(I18n.func_135052_a((String)"controllable.action.dismount", (Object[])new Object[0]), Action.Side.RIGHT));
                } else if (verbose) {
                    actionMap.put(ButtonBindings.SNEAK, new Action(I18n.func_135052_a((String)"controllable.action.sneak", (Object[])new Object[0]), Action.Side.RIGHT));
                }
                if (!mc.field_71439_g.field_71071_by.func_70448_g().func_190926_b()) {
                    actionMap.put(ButtonBindings.DROP_ITEM, new Action(I18n.func_135052_a((String)"controllable.action.drop_item", (Object[])new Object[0]), Action.Side.LEFT));
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new AvailableActionsEvent(this.actions));
            MinecraftForge.EVENT_BUS.post((Event)new GatherActionsEvent(actionMap, visibility));
            actionMap.forEach((binding, action) -> this.actions.put(binding.getButton(), (Action)action));
        }
    }

    @SubscribeEvent
    public void onRenderScreen(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Controllable.getInput().getLastUse() <= 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74319_N) {
            return;
        }
        if (Controllable.getController() == null) {
            return;
        }
        GlStateManager.func_179094_E();
        if (!MinecraftForge.EVENT_BUS.post((Event)new RenderAvailableActionsEvent())) {
            GuiIngame guiIngame = mc.field_71456_v;
            boolean isChatVisible = mc.field_71462_r == null && guiIngame.func_146158_b().field_146253_i.stream().anyMatch(chatLine -> guiIngame.func_73834_c() - chatLine.func_74540_b() < 200);
            int leftIndex = 0;
            int rightIndex = 0;
            for (int button : this.actions.keySet()) {
                Action action = this.actions.get(button);
                Action.Side side = action.getSide();
                int texU = button * 13;
                int texV = Controllable.getOptions().getControllerType().ordinal() * 13;
                int size = 13;
                ScaledResolution resolution = new ScaledResolution(mc);
                int x = side == Action.Side.LEFT ? 5 : resolution.func_78326_a() - 5 - size;
                int y = resolution.func_78328_b() + (side == Action.Side.LEFT ? leftIndex : rightIndex) * -15 - size - 5;
                mc.func_110434_K().func_110577_a(CONTROLLER_BUTTONS);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179140_f();
                if (isChatVisible && side == Action.Side.LEFT && leftIndex >= 2) continue;
                Gui.func_146110_a((int)x, (int)y, (float)texU, (float)texV, (int)size, (int)size, (float)256.0f, (float)256.0f);
                if (side == Action.Side.LEFT) {
                    mc.field_71466_p.func_78276_b(action.getDescription(), x + 18, y + 3, Color.WHITE.getRGB());
                    ++leftIndex;
                    continue;
                }
                int width = mc.field_71466_p.func_78256_a(action.getDescription());
                mc.field_71466_p.func_78276_b(action.getDescription(), x - 5 - width, y + 3, Color.WHITE.getRGB());
                ++rightIndex;
            }
        }
        if (mc.field_71439_g != null && mc.field_71462_r == null && Controllable.getOptions().isRenderMiniPlayer() && !MinecraftForge.EVENT_BUS.post((Event)new RenderPlayerPreviewEvent())) {
            GuiInventory.func_147046_a((int)20, (int)45, (int)20, (float)0.0f, (float)0.0f, (EntityLivingBase)mc.field_71439_g);
        }
        GlStateManager.func_179121_F();
    }
}

