/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client.settings;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.gui.widget.OptionSliderWidget;
import com.mrcrayfish.controllable.client.settings.ControllableOption;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.math.MathHelper;

public class ControllableOptionSlider
extends ControllableOption<Double> {
    private float stepSize;
    private float minValue;
    private float maxValue;

    public ControllableOptionSlider(String titleKey, float stepSize, float minValue, float maxValue, Supplier<Double> getter, Consumer<Double> setter, Function<Double, String> formatter) {
        super(titleKey, getter, setter, formatter);
        this.stepSize = stepSize;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void setValue(float value) {
        double oldValue = (Double)this.getGetter().get();
        this.getSetter().accept(this.denormalize(value));
        if (oldValue != (Double)this.getGetter().get()) {
            Controllable.getOptions().saveOptions();
        }
    }

    public float normalize() {
        return MathHelper.func_76131_a((float)((this.snapToStepClamp(((Double)this.getGetter().get()).floatValue()) - this.minValue) / (this.maxValue - this.minValue)), (float)0.0f, (float)1.0f);
    }

    public double denormalize(float value) {
        return this.snapToStepClamp(this.minValue + (this.maxValue - this.minValue) * MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f));
    }

    public float snapToStepClamp(float value) {
        return MathHelper.func_76131_a((float)this.snapToStep(value), (float)this.minValue, (float)this.maxValue);
    }

    private float snapToStep(float value) {
        if (this.stepSize > 0.0f) {
            value = this.stepSize * (float)Math.round(value / this.stepSize);
        }
        return value;
    }

    @Override
    public GuiButton createOption(int id, int x, int y, int width) {
        return new OptionSliderWidget(id, x, y, width, this);
    }
}

