/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.mixin.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.ButtonBindings;
import com.mrcrayfish.controllable.client.Controller;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @ModifyArg(method={"processKeyBinds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/Minecraft;sendClickBlockToController(Z)V"))
    private boolean sendClickBlockToController(boolean leftClick) {
        return leftClick || MinecraftMixin.isLeftClicking();
    }

    @Redirect(method={"processKeyBinds"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/settings/KeyBinding;isKeyDown()Z"), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/client/entity/EntityPlayerSP;isHandActive()Z"), to=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/PlayerControllerMP;onStoppedUsingItem(Lnet/minecraft/entity/player/EntityPlayer;)V")))
    private boolean onKeyDown(KeyBinding binding) {
        return binding.func_151470_d() || MinecraftMixin.isRightClicking();
    }

    private static boolean isRightClicking() {
        Controller controller = Controllable.getController();
        return controller != null && ButtonBindings.USE_ITEM.isButtonDown();
    }

    private static boolean isLeftClicking() {
        Minecraft mc = Minecraft.func_71410_x();
        Controller controller = Controllable.getController();
        if (controller != null && ButtonBindings.ATTACK.isButtonDown()) {
            boolean usingVirtualMouse = Controllable.getOptions().isVirtualMouse() && Controllable.getInput().getLastUse() > 0;
            return mc.field_71462_r == null && (Mouse.isGrabbed() || usingVirtualMouse);
        }
        return false;
    }
}

