/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.forestry;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Locale;

public enum BeeBranchRegister implements IBranchDefinition
{
    TWILIGHT("Crepusculum"),
    SWAMP("Palus"),
    DARK_FOREST("Maestus"),
    SNOWY_FOREST("Frigidus"),
    HIGHLANDS("Superior");

    private final IClassification classification;
    private static IAllele[] defaultTemplate;

    private BeeBranchRegister(String genus) {
        this.classification = BeeManager.beeFactory.createBranch(this.name().toLowerCase(Locale.ENGLISH), genus);
    }

    public IAllele[] getTemplate() {
        IAllele[] template = BeeBranchRegister.copyDefaultTemplate();
        IAllele[] copiedAlleles = new IAllele[template.length];
        System.arraycopy(template, 0, copiedAlleles, 0, template.length);
        return copiedAlleles;
    }

    public IClassification getBranch() {
        return this.classification;
    }

    private static IAllele[] copyDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
        }
        IAllele[] copiedAlleles = new IAllele[defaultTemplate.length];
        System.arraycopy(defaultTemplate, 0, copiedAlleles, 0, defaultTemplate.length);
        return copiedAlleles;
    }
}

