/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.management.feature;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.quark.base.module.Feature;
import vazkii.quark.management.capability.ShulkerBoxDropIn;

public class RightClickAddToShulkerBox
extends Feature {
    public static List<ResourceLocation> shulkerBoxes;
    public static boolean dropoffAnyShulkerBox;
    private static final ResourceLocation SHULKER_BOX_CAP;

    public static String[] getBasicShulkerBoxes() {
        return (String[])ImmutableSet.of((Object)Blocks.field_190977_dl, (Object)Blocks.field_190978_dm, (Object)Blocks.field_190979_dn, (Object)Blocks.field_190980_do, (Object)Blocks.field_190981_dp, (Object)Blocks.field_190982_dq, (Object[])new Block[]{Blocks.field_190983_dr, Blocks.field_190984_ds, Blocks.field_190985_dt, Blocks.field_190986_du, Blocks.field_190987_dv, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190990_dy, Blocks.field_190991_dz, Blocks.field_190975_dA}).stream().map(IForgeRegistryEntry.Impl::getRegistryName).map(Objects::toString).toArray(String[]::new);
    }

    public static boolean isShulkerBox(ItemStack stack, List<ResourceLocation> boxes, boolean acceptGeneric) {
        return !stack.func_190926_b() && RightClickAddToShulkerBox.isShulkerBox(stack.func_77973_b().getRegistryName(), boxes, acceptGeneric);
    }

    public static boolean isShulkerBox(Block block, List<ResourceLocation> boxes, boolean acceptGeneric) {
        return RightClickAddToShulkerBox.isShulkerBox(block.getRegistryName(), boxes, acceptGeneric);
    }

    public static boolean isShulkerBox(ResourceLocation loc, List<ResourceLocation> boxes, boolean acceptGeneric) {
        if (loc == null) {
            return false;
        }
        if (boxes.contains(loc)) {
            return true;
        }
        return acceptGeneric && loc.toString().contains("shulker_box");
    }

    @Override
    public void setupConfig() {
        String[] shulkerArr = this.loadPropStringList("Shulker Boxes", "Blocks which should be interpreted as Shulker Boxes.", RightClickAddToShulkerBox.getBasicShulkerBoxes());
        shulkerBoxes = Arrays.stream(shulkerArr).map(ResourceLocation::new).collect(Collectors.toList());
        dropoffAnyShulkerBox = this.loadPropBool("Dropoff to Any Shulker Box", "Allow anything with 'shulker_box' in its item identifier to be treated as a shulker box?", true);
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (RightClickAddToShulkerBox.isShulkerBox((ItemStack)event.getObject(), shulkerBoxes, dropoffAnyShulkerBox)) {
            event.addCapability(SHULKER_BOX_CAP, (ICapabilityProvider)new ShulkerBoxDropIn());
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        SHULKER_BOX_CAP = new ResourceLocation("quark", "shulker_box_drop_in");
    }
}

