/*
 * Decompiled with CFR 0.152.
 */
package shadows.click;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.click.ClickMachineConfig;
import shadows.click.block.AutoClickerBlock;
import shadows.click.block.AutoClickerTile;
import shadows.click.block.gui.AutoClickContainer;
import shadows.click.util.FakePlayerUtil;
import shadows.placebo.block_entity.TickingBlockEntityType;
import shadows.placebo.config.Configuration;
import shadows.placebo.container.ContainerUtil;
import shadows.placebo.loot.LootSystem;
import shadows.placebo.recipe.RecipeHelper;

@Mod(value="clickmachine")
public class ClickMachine {
    public static final String MODID = "clickmachine";
    public static final Logger LOG = LogManager.getLogger((String)"clickmachine");
    public static final RecipeHelper HELPER = new RecipeHelper("clickmachine");
    @ObjectHolder(value="clickmachine:auto_clicker")
    public static final AutoClickerBlock AUTO_CLICKER = null;
    @ObjectHolder(value="clickmachine:container")
    public static final MenuType<AutoClickContainer> CONTAINER = null;
    @ObjectHolder(value="clickmachine:tile")
    public static final BlockEntityType<AutoClickerTile> TILE = null;

    public ClickMachine() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::blockJoin);
        ClickMachineConfig.init(new Configuration(new File(FMLPaths.CONFIGDIR.get().toFile(), "clickmachine.cfg")));
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        Block b = (Block)new AutoClickerBlock().setRegistryName(MODID, "auto_clicker");
        e.getRegistry().register((IForgeRegistryEntry)b);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((Item)new BlockItem(b, new Item.Properties().m_41491_(CreativeModeTab.f_40751_)).setRegistryName(b.getRegistryName())));
    }

    @SubscribeEvent
    public void container(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((MenuType)ContainerUtil.makeType(AutoClickContainer::new).setRegistryName(MODID, "container")));
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new TickingBlockEntityType(AutoClickerTile::new, (Set)ImmutableSet.of((Object)((Object)AUTO_CLICKER)), false, true).setRegistryName(MODID, "tile")));
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent e) {
        Ingredient diorite = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42064_});
        HELPER.addShaped((Object)AUTO_CLICKER, 3, 3, new Object[]{diorite, diorite, diorite, diorite, Blocks.f_50491_, diorite, diorite, Blocks.f_50330_, diorite});
        LootSystem.defaultBlockTable((Block)AUTO_CLICKER);
    }

    public void blockJoin(EntityJoinWorldEvent e) {
        if (e.getEntity() instanceof FakePlayerUtil.UsefulFakePlayer) {
            e.setCanceled(true);
        }
    }
}

