/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.util;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.Mod;
import shadows.placebo.util.DeadPacketListenerImpl;

@Mod.EventBusSubscriber
public class FakePlayerUtil {
    private static final Map<Level, Map<GameProfile, UsefulFakePlayer>> PLAYERS = new WeakHashMap<Level, Map<GameProfile, UsefulFakePlayer>>();

    public static UsefulFakePlayer getPlayer(Level world, GameProfile profile) {
        return PLAYERS.computeIfAbsent(world, p -> new HashMap()).computeIfAbsent(profile, p -> {
            UsefulFakePlayer player = new UsefulFakePlayer(world, profile);
            player.f_8906_ = new DeadPacketListenerImpl((FakePlayer)player);
            return player;
        });
    }

    public static void setupFakePlayerForUse(UsefulFakePlayer player, BlockPos pos, Direction direction, ItemStack toHold, boolean sneaking) {
        float pitch;
        player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)toHold);
        float f = direction == Direction.UP ? -90.0f : (pitch = direction == Direction.DOWN ? 90.0f : 0.0f);
        float yaw = direction == Direction.SOUTH ? 0.0f : (direction == Direction.WEST ? 90.0f : (direction == Direction.NORTH ? 180.0f : -90.0f));
        Vec3i sideVec = direction.m_122436_();
        Direction.Axis a = direction.m_122434_();
        Direction.AxisDirection ad = direction.m_122421_();
        double x = a == Direction.Axis.X && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.m_123341_() / 1.9;
        double y = 0.5 + (double)sideVec.m_123342_() / 1.9;
        double z = a == Direction.Axis.Z && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.m_123343_() / 1.9;
        player.m_7678_((double)pos.m_123341_() + x, (double)pos.m_123342_() + y - (double)player.m_20192_(), (double)pos.m_123343_() + z, yaw, pitch);
        if (!toHold.m_41619_()) {
            player.m_21204_().m_22178_(toHold.m_41638_(EquipmentSlot.MAINHAND));
        }
        player.m_20260_(sneaking);
    }

    public static void cleanupFakePlayerFromUse(UsefulFakePlayer player, ItemStack resultStack, ItemStack oldStack, Consumer<ItemStack> stackCallback) {
        if (!oldStack.m_41619_()) {
            player.m_21204_().m_22161_(oldStack.m_41638_(EquipmentSlot.MAINHAND));
        }
        player.m_150109_().f_35974_.set(player.m_150109_().f_35977_, (Object)ItemStack.f_41583_);
        stackCallback.accept(resultStack);
        if (!player.m_150109_().m_7983_()) {
            player.m_150109_().m_36071_();
        }
        player.m_20260_(false);
    }

    public static ItemStack rightClickInDirection(UsefulFakePlayer player, Level world, BlockPos pos, Direction side, BlockState sourceState) {
        InteractionResult type;
        BlockPos blockpos;
        BlockState state;
        HitResult toUse = FakePlayerUtil.rayTrace(player, world, player.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get()));
        if (toUse == null) {
            return player.m_21205_();
        }
        ItemStack itemstack = player.m_21205_();
        if (toUse.m_6662_() == HitResult.Type.ENTITY) {
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityHitResult)toUse).m_82443_(), toUse, InteractionType.INTERACT_AT)) {
                return player.m_21205_();
            }
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityHitResult)toUse).m_82443_(), null, InteractionType.INTERACT)) {
                return player.m_21205_();
            }
        } else if (toUse.m_6662_() == HitResult.Type.BLOCK && (state = world.m_8055_(blockpos = ((BlockHitResult)toUse).m_82425_())) != sourceState && state.m_60767_() != Material.f_76296_ && (type = player.f_8941_.m_7179_((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND, (BlockHitResult)toUse)) == InteractionResult.SUCCESS) {
            return player.m_21205_();
        }
        if (toUse == null || toUse.m_6662_() == HitResult.Type.MISS) {
            for (int i = 1; i <= 5; ++i) {
                state = world.m_8055_(pos.m_5484_(side, i));
                if (state == sourceState || state.m_60767_() == Material.f_76296_) continue;
                player.f_8941_.m_7179_((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND, (BlockHitResult)toUse);
                return player.m_21205_();
            }
        }
        if (itemstack.m_41619_() && (toUse == null || toUse.m_6662_() == HitResult.Type.MISS)) {
            ForgeHooks.onEmptyClick((Player)player, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        if (!itemstack.m_41619_()) {
            player.f_8941_.m_6261_((ServerPlayer)player, world, itemstack, InteractionHand.MAIN_HAND);
        }
        return player.m_21205_();
    }

    public static ItemStack leftClickInDirection(UsefulFakePlayer player, Level world, BlockPos pos, Direction side, BlockState sourceState) {
        BlockPos blockpos;
        BlockState state;
        HitResult toUse = FakePlayerUtil.rayTrace(player, world, player.m_21133_((Attribute)ForgeMod.REACH_DISTANCE.get()));
        if (toUse == null) {
            return player.m_21205_();
        }
        if (toUse.m_6662_() == HitResult.Type.ENTITY) {
            if (FakePlayerUtil.processUseEntity(player, world, ((EntityHitResult)toUse).m_82443_(), null, InteractionType.ATTACK)) {
                return player.m_21205_();
            }
        } else if (toUse.m_6662_() == HitResult.Type.BLOCK && (state = world.m_8055_(blockpos = ((BlockHitResult)toUse).m_82425_())) != sourceState && state.m_60767_() != Material.f_76296_) {
            player.f_8941_.m_7391_(blockpos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, ((BlockHitResult)toUse).m_82434_(), player.f_19853_.m_151558_());
            return player.m_21205_();
        }
        if (toUse == null || toUse.m_6662_() == HitResult.Type.MISS) {
            for (int i = 1; i <= 5; ++i) {
                state = world.m_8055_(pos.m_5484_(side, i));
                if (state == sourceState || state.m_60767_() == Material.f_76296_) continue;
                player.f_8941_.m_7391_(pos.m_5484_(side, i), ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, side.m_122424_(), player.f_19853_.m_151558_());
                return player.m_21205_();
            }
        }
        return player.m_21205_();
    }

    public static HitResult traceEntities(UsefulFakePlayer player, Vec3 base, Vec3 target, Level world) {
        Entity pointedEntity = null;
        EntityHitResult result = null;
        Vec3 vec3d3 = null;
        AABB search = new AABB(base.f_82479_, base.f_82480_, base.f_82481_, target.f_82479_, target.f_82480_, target.f_82481_).m_82377_(0.5, 0.5, 0.5);
        List list = world.m_6249_((Entity)player, search, entity -> EntitySelector.f_20408_.test(entity) && entity != null && entity.m_6087_());
        double d2 = 5.0;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AABB aabb = entity1.m_142469_().m_82400_((double)entity1.m_6143_());
            Optional optVec = aabb.m_82371_(base, target);
            if (aabb.m_82390_(base)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                vec3d3 = optVec.orElse(base);
                d2 = 0.0;
                continue;
            }
            if (!optVec.isPresent() || !((d3 = base.m_82554_((Vec3)optVec.get())) < d2) && d2 != 0.0) continue;
            if (entity1.m_20201_() == player.m_20201_() && !entity1.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                vec3d3 = (Vec3)optVec.get();
                continue;
            }
            pointedEntity = entity1;
            vec3d3 = (Vec3)optVec.get();
            d2 = d3;
        }
        if (pointedEntity != null && base.m_82554_(vec3d3) > 5.0) {
            pointedEntity = null;
            result = BlockHitResult.m_82426_(vec3d3, null, (BlockPos)new BlockPos(vec3d3));
        }
        if (pointedEntity != null) {
            result = new EntityHitResult(pointedEntity, vec3d3);
        }
        return result;
    }

    public static boolean processUseEntity(UsefulFakePlayer player, Level world, Entity entity, @Nullable HitResult result, InteractionType action) {
        if (entity != null && player.m_20280_(entity) < 36.0) {
            if (action == InteractionType.INTERACT) {
                return player.m_36157_(entity, InteractionHand.MAIN_HAND) == InteractionResult.SUCCESS;
            }
            if (action == InteractionType.INTERACT_AT) {
                if (ForgeHooks.onInteractEntityAt((Player)player, (Entity)entity, (Vec3)result.m_82450_(), (InteractionHand)InteractionHand.MAIN_HAND) != null) {
                    return false;
                }
                return entity.m_7111_((Player)player, result.m_82450_(), InteractionHand.MAIN_HAND) == InteractionResult.SUCCESS;
            }
            if (action == InteractionType.ATTACK) {
                if (entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof Arrow || entity == player) {
                    return false;
                }
                player.m_5706_(entity);
                return true;
            }
        }
        return false;
    }

    public static HitResult rayTrace(UsefulFakePlayer player, Level level, double reachDist) {
        HitResult toUse;
        Vec3 base = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        Vec3 look = player.m_20154_();
        Vec3 target = base.m_82520_(look.f_82479_ * reachDist, look.f_82480_ * reachDist, look.f_82481_ * reachDist);
        BlockHitResult trace = level.m_45547_(new ClipContext(base, target, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        HitResult traceEntity = FakePlayerUtil.traceEntities(player, base, target, level);
        Object object = toUse = trace == null ? traceEntity : trace;
        if (trace != null && traceEntity != null) {
            double d1 = trace.m_82450_().m_82554_(base);
            double d2 = traceEntity.m_82450_().m_82554_(base);
            toUse = traceEntity.m_6662_() == HitResult.Type.ENTITY && d1 > d2 ? traceEntity : trace;
        }
        return toUse;
    }

    public static class UsefulFakePlayer
    extends FakePlayer {
        public UsefulFakePlayer(Level world, GameProfile name) {
            super((ServerLevel)world, name);
        }

        public float m_20236_(Pose pose) {
            return 0.0f;
        }

        public void m_143399_(AbstractContainerMenu p_143400_) {
        }

        public OptionalInt m_5893_(MenuProvider p_9033_) {
            return OptionalInt.empty();
        }

        public float m_36403_(float adjustTicks) {
            return 1.0f;
        }

        public Entity changeDimension(ServerLevel server, ITeleporter teleporter) {
            return FakePlayerUtil.getPlayer((Level)server, this.m_36316_());
        }
    }

    public static enum InteractionType {
        INTERACT,
        INTERACT_AT,
        ATTACK;

    }
}

