/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.network.BiblioNetworking;
import jds.bibliocraft.network.packet.client.BiblioPanelerClient;
import jds.bibliocraft.states.PanelProperty;
import jds.bibliocraft.states.PanelState;
import jds.bibliocraft.states.TextureProperty;
import jds.bibliocraft.states.TextureState;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityFurniturePaneler;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockFurniturePaneler
extends BiblioWoodBlock {
    public static final String name = "FurniturePaneler";
    public static final BlockFurniturePaneler instance = new BlockFurniturePaneler();

    public BlockFurniturePaneler() {
        super(name, false);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack playerHand = player.func_184586_b(EnumHand.MAIN_HAND);
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof TileEntityFurniturePaneler) {
                TileEntityFurniturePaneler paneler = (TileEntityFurniturePaneler)tile;
                int slot = BlockFurniturePaneler.checkTopClickedPlace(paneler.getAngle(), hitX, hitY, hitZ);
                if (player.func_70093_af()) {
                    ItemStack test;
                    if (face == EnumFacing.UP && slot >= 0 && slot <= 2 && (test = paneler.func_70301_a(slot)) != ItemStack.field_190927_a) {
                        this.dropStackInSlot(world, pos, slot, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
                        paneler.func_70299_a(slot, ItemStack.field_190927_a);
                        if (slot == 2) {
                            paneler.executeRecipe();
                        }
                        paneler.updateRecipeManager();
                        return true;
                    }
                } else if (playerHand != ItemStack.field_190927_a && face == EnumFacing.UP) {
                    if (slot == 0 && Config.isBlock(playerHand)) {
                        Block thing = Block.func_149634_a((Item)playerHand.func_77973_b());
                        boolean thaumcraftException = playerHand.func_77977_a().contains("tile.blockWoodenDevice");
                        if ((thing.func_149662_c(thing.func_176223_P()) || thaumcraftException) && paneler.addItemsToBlock(playerHand, 0, player)) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                            BiblioNetworking.INSTANCE.sendTo((IMessage)new BiblioPanelerClient(playerHand, paneler.func_174877_v()), (EntityPlayerMP)player);
                            return true;
                        }
                    }
                    if (slot == 1 && paneler.checkIfFramedBiblioCraftBlock(playerHand) && paneler.addItemsToBlock(playerHand, 1, player)) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                        return true;
                    }
                }
                paneler.playerFromBlock = player;
                player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public static int checkTopClickedPlace(EnumFacing angle, float x, float y, float z) {
        switch (angle) {
            case SOUTH: {
                if (x > 0.5f) {
                    return 0;
                }
                if (z < 0.5f) {
                    return 1;
                }
                return 2;
            }
            case WEST: {
                if (z > 0.5f) {
                    return 0;
                }
                if (x > 0.5f) {
                    return 1;
                }
                return 2;
            }
            case NORTH: {
                if (x < 0.5f) {
                    return 0;
                }
                if (z > 0.5f) {
                    return 1;
                }
                return 2;
            }
            case EAST: {
                if (z < 0.5f) {
                    return 0;
                }
                if (x < 0.5f) {
                    return 1;
                }
                return 2;
            }
        }
        return -1;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFurniturePaneler();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ItemStack stack;
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("wood");
        modelParts.add("paneler");
        if (tile instanceof TileEntityFurniturePaneler && (stack = tile.func_70301_a(0)) != ItemStack.field_190927_a) {
            int stackSize = stack.func_190916_E();
            if (stackSize >= 1) {
                modelParts.add("panel1");
            }
            if (stackSize > 8) {
                modelParts.add("panel2");
            }
            if (stackSize > 16) {
                modelParts.add("panel3");
            }
            if (stackSize > 24) {
                modelParts.add("panel4");
            }
            if (stackSize > 32) {
                modelParts.add("panel5");
            }
            if (stackSize > 40) {
                modelParts.add("panel6");
            }
            if (stackSize > 48) {
                modelParts.add("panel7");
            }
            if (stackSize > 54) {
                modelParts.add("panel8");
            }
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        return transform;
    }

    @Override
    public ExtendedBlockState getExtendedBlockStateAlternate(ExtendedBlockState state) {
        return new ExtendedBlockState((Block)this, new IProperty[]{WOOD_TYPE}, new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE, TextureProperty.instance, PanelProperty.instance});
    }

    @Override
    public IExtendedBlockState getIExtendedBlockStateAlternate(BiblioTileEntity biblioTile, IExtendedBlockState state) {
        TextureState textureString = new TextureState(biblioTile.getCustomTextureString());
        state = state.withProperty((IUnlistedProperty)TextureProperty.instance, (Object)textureString);
        if (biblioTile instanceof TileEntityFurniturePaneler) {
            TileEntityFurniturePaneler paneler = (TileEntityFurniturePaneler)biblioTile;
            PanelState panalTextureString = new PanelState(paneler.getCustomCraftingTex());
            state = state.withProperty((IUnlistedProperty)PanelProperty.instance, (Object)panalTextureString);
        }
        return state;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        return this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.63f, 1.0f);
    }
}

