/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.tileentity.TileEntityLightSwitch;
import com.mrcrayfish.furniture.util.Bounds;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLightSwitch
extends BlockFurniture {
    private static final AxisAlignedBB[] BOUNDING_BOXES = new Bounds(14, 3, 4, 16, 13, 12).getRotatedBounds();
    private static final AxisAlignedBB[] COLLISION_BOXES = new Bounds(15, 4, 5, 16, 12, 11).getRotatedBounds();

    public BlockLightSwitch() {
        super(Material.field_151575_d);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOXES[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b()];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)COLLISION_BOXES[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b()]);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLightSwitch) {
            if (this == FurnitureBlocks.LIGHT_SWITCH_OFF) {
                ((TileEntityLightSwitch)tileEntity).setState(true);
            } else {
                ((TileEntityLightSwitch)tileEntity).setState(false);
            }
            worldIn.func_184133_a(null, pos, FurnitureSounds.light_switch, SoundCategory.BLOCKS, 1.0f, 0.9f + RANDOM.nextFloat() * 0.1f);
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityLightSwitch();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)FurnitureBlocks.LIGHT_SWITCH_OFF);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess blockAccess, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tileEntity;
        super.getDrops(drops, blockAccess, pos, state, fortune);
        if (blockAccess instanceof World && !((World)blockAccess).field_72995_K && (tileEntity = blockAccess.func_175625_s(pos)) instanceof TileEntityLightSwitch) {
            TileEntityLightSwitch lightSwitch = (TileEntityLightSwitch)tileEntity;
            for (ItemStack drop : drops) {
                if (!(drop.func_77973_b() instanceof ItemBlock) || ((ItemBlock)drop.func_77973_b()).func_179223_d() != FurnitureBlocks.LIGHT_SWITCH_OFF) continue;
                NBTTagCompound tileEntityTag = new NBTTagCompound();
                lightSwitch.func_189515_b(tileEntityTag);
                tileEntityTag.func_82580_o("x");
                tileEntityTag.func_82580_o("y");
                tileEntityTag.func_82580_o("z");
                NBTTagCompound compound = drop.func_77942_o() ? drop.func_77978_p() : new NBTTagCompound();
                compound.func_74782_a("BlockEntityTag", (NBTBase)tileEntityTag);
                drop.func_77982_d(compound);
            }
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP && side != EnumFacing.DOWN && world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing.func_176734_d());
    }
}

