/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.blocks.BlockModernCouch;
import com.mrcrayfish.furniture.util.Bounds;
import com.mrcrayfish.furniture.util.SeatUtil;
import com.mrcrayfish.furniture.util.StateHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockParkBench
extends BlockFurniture {
    public static final PropertyEnum<BlockModernCouch.CouchType> TYPE = PropertyEnum.func_177709_a((String)"type", BlockModernCouch.CouchType.class);
    public static final AxisAlignedBB BOUNDING_BOX = new Bounds(0, 0, 0, 16, 18, 16).toAABB();
    public static final AxisAlignedBB CHAIR_SEAT = new Bounds(0, 0, 0, 16, 9, 16).toAABB();
    public static final AxisAlignedBB[] CHAIR_BACKREST = new Bounds(11, 9, 0, 16, 18, 16).getRotatedBounds();

    public BlockParkBench(String id) {
        super(Material.field_151575_d);
        this.func_149663_c(id);
        this.setRegistryName(id);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)BlockModernCouch.CouchType.BOTH)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        BlockParkBench.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_SEAT);
        BlockParkBench.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b()]);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean left = false;
        boolean right = false;
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT) instanceof BlockParkBench && StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.LEFT) == StateHelper.Direction.DOWN) {
            left = true;
        }
        if (StateHelper.getBlock(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT) instanceof BlockParkBench && StateHelper.getRotation(world, pos, (EnumFacing)state.func_177229_b((IProperty)FACING), StateHelper.Direction.RIGHT) == StateHelper.Direction.DOWN) {
            right = true;
        }
        if (left && !right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)BlockModernCouch.CouchType.LEFT));
        }
        if (!left && right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)BlockModernCouch.CouchType.RIGHT));
        }
        if (!left && !right) {
            return state.func_177226_a(TYPE, (Comparable)((Object)BlockModernCouch.CouchType.BOTH));
        }
        return state.func_177226_a(TYPE, (Comparable)((Object)BlockModernCouch.CouchType.NONE));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return SeatUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.375);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }
}

