/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.attributes;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.BlockCustomSandOre;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.world.WorldGenAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class GenAttributeAquamarine
extends WorldGenAttribute {
    private List<IBlockState> replaceableStates = null;
    private List<String> replaceableStatesSerialized = new ArrayList<String>();

    public GenAttributeAquamarine() {
        super(0);
        Config.addDynamicEntry(new ConfigEntry(ConfigEntry.Section.WORLDGEN, "aquamarine"){

            @Override
            public void loadFromConfig(Configuration cfg) {
                String[] applicableReplacements = cfg.getStringList("ReplacementStates", this.getConfigurationSection(), new String[]{"minecraft:sand:0"}, "Defines the blockstates that may be replaced by aquamarine shale when trying to generate aquamarine shale. format: <modid>:<name>:<meta> - Use meta -1 for wildcard");
                GenAttributeAquamarine.this.replaceableStatesSerialized = Arrays.asList(applicableReplacements);
            }
        });
    }

    private void resolveReplaceableStates() {
        this.replaceableStates = new LinkedList<IBlockState>();
        for (String stateStr : this.replaceableStatesSerialized) {
            Integer meta;
            String[] spl = stateStr.split(":");
            if (spl.length != 3) {
                AstralSorcery.log.info("Skipping invalid replacement state: " + stateStr);
                continue;
            }
            String strMeta = spl[2];
            try {
                meta = Integer.parseInt(strMeta);
            }
            catch (NumberFormatException exc) {
                AstralSorcery.log.error("Skipping invalid replacement state: " + stateStr + " - Its 'meta' is not a number!");
                continue;
            }
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(spl[0], spl[1]));
            if (b == null || b == Blocks.field_150350_a) {
                AstralSorcery.log.error("Skipping invalid replacement state: " + stateStr + " - The block does not exist!");
                continue;
            }
            if (meta == -1) {
                this.replaceableStates.addAll((Collection<IBlockState>)b.func_176194_O().func_177619_a());
                continue;
            }
            this.replaceableStates.add(b.func_176203_a(meta.intValue()));
        }
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        if (this.replaceableStates == null) {
            this.resolveReplaceableStates();
        }
        for (int i = 0; i < Config.aquamarineAmount; ++i) {
            int rZ;
            int rY;
            int rX = chunkX * 16 + random.nextInt(16) + 8;
            BlockPos pos = new BlockPos(rX, rY = 48 + random.nextInt(19), rZ = chunkZ * 16 + random.nextInt(16) + 8);
            IBlockState stateAt = world.func_180495_p(pos);
            if (MiscUtils.getMatchingState(this.replaceableStates, stateAt) == null) continue;
            boolean foundWater = false;
            for (int yy = 0; yy < 2; ++yy) {
                BlockPos check = pos.func_177967_a(EnumFacing.UP, yy);
                IBlockState bs = world.func_180495_p(check);
                Block block = bs.func_177230_c();
                if ((!(block instanceof BlockLiquid) || bs.func_185904_a() != Material.field_151586_h) && !block.equals(Blocks.field_150432_aD) && !block.equals(Blocks.field_150403_cj) && !block.equals(Blocks.field_185778_de)) continue;
                foundWater = true;
                break;
            }
            if (!foundWater) continue;
            world.func_175656_a(pos, BlocksAS.customSandOre.func_176223_P().func_177226_a(BlockCustomSandOre.ORE_TYPE, (Comparable)((Object)BlockCustomSandOre.OreType.AQUAMARINE)));
        }
    }
}

