/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.TileEntityLinkable;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public interface IModuleInventory
extends IItemHandlerModifiable {
    public NonNullList<ItemStack> getInventory();

    public EnumModuleType[] acceptedModules();

    default public TileEntity getTileEntity() {
        return (TileEntity)this;
    }

    default public int getMaxNumberOfModules() {
        return this.acceptedModules().length;
    }

    default public void onModuleInserted(ItemStack stack, EnumModuleType module) {
        TileEntity te = this.getTileEntity();
        if (!te.func_145831_w().field_72995_K) {
            IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
            te.func_145831_w().func_184138_a(te.func_174877_v(), state, state, 3);
            te.func_145831_w().func_175685_c(te.func_174877_v(), te.func_145838_q(), false);
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a((Packet)this.getTileEntity().func_189518_D_());
        }
    }

    default public void onModuleRemoved(ItemStack stack, EnumModuleType module) {
        TileEntity te = this.getTileEntity();
        if (!te.func_145831_w().field_72995_K) {
            IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
            te.func_145831_w().func_184138_a(te.func_174877_v(), state, state, 3);
            te.func_145831_w().func_175685_c(te.func_174877_v(), te.func_145838_q(), false);
            FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a((Packet)this.getTileEntity().func_189518_D_());
        }
    }

    default public boolean enableHack() {
        return false;
    }

    default public int fixSlotId(int id) {
        return id >= 100 ? id - 100 : id;
    }

    default public int getSlots() {
        return this.acceptedModules().length;
    }

    default public ItemStack getStackInSlot(int slot) {
        return this.getModuleInSlot(slot);
    }

    default public ItemStack getModuleInSlot(int slot) {
        return (slot = this.fixSlotId(slot)) < 0 || slot >= this.getSlots() ? ItemStack.field_190927_a : (ItemStack)this.getInventory().get(slot);
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.getModuleInSlot(slot = this.fixSlotId(slot)).func_77946_l();
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            TileEntity te = this.getTileEntity();
            if (stack.func_77973_b() instanceof ItemModule) {
                this.onModuleRemoved(stack, ((ItemModule)stack.func_77973_b()).getModuleType());
                if (te instanceof TileEntityLinkable) {
                    ModuleUtils.createLinkedAction(EnumLinkedAction.MODULE_REMOVED, stack, (TileEntityLinkable)te);
                }
            }
            return ((ItemStack)this.getInventory().set(slot, (Object)ItemStack.field_190927_a)).func_77946_l();
        }
        return stack.func_77946_l();
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.getModuleInSlot(slot = this.fixSlotId(slot)).func_190926_b()) {
            return stack;
        }
        int returnSize = 0;
        if (stack.func_190916_E() > 1) {
            returnSize = stack.func_190916_E() - 1;
        }
        if (!simulate) {
            ItemStack copy = stack.func_77946_l();
            TileEntity te = this.getTileEntity();
            copy.func_190920_e(1);
            this.getInventory().set(slot, (Object)copy);
            if (stack.func_77973_b() instanceof ItemModule) {
                this.onModuleInserted(stack, ((ItemModule)stack.func_77973_b()).getModuleType());
                if (te instanceof TileEntityLinkable) {
                    ModuleUtils.createLinkedAction(EnumLinkedAction.MODULE_INSERTED, copy, (TileEntityLinkable)te);
                }
            }
        }
        if (returnSize != 0) {
            ItemStack toReturn = stack.func_77946_l();
            toReturn.func_190920_e(returnSize);
            return toReturn;
        }
        return ItemStack.field_190927_a;
    }

    default public void setStackInSlot(int slot, ItemStack stack) {
        slot = this.fixSlotId(slot);
        TileEntity te = this.getTileEntity();
        ItemStack previous = this.getModuleInSlot(slot);
        if (!previous.func_190926_b()) {
            this.onModuleRemoved(previous, ((ItemModule)previous.func_77973_b()).getModuleType());
            if (te instanceof TileEntityLinkable) {
                ModuleUtils.createLinkedAction(EnumLinkedAction.MODULE_REMOVED, previous, (TileEntityLinkable)te);
            }
        }
        this.getInventory().set(slot, (Object)stack);
        if (stack.func_77973_b() instanceof ItemModule) {
            this.onModuleInserted(stack, ((ItemModule)stack.func_77973_b()).getModuleType());
            if (te instanceof TileEntityLinkable) {
                ModuleUtils.createLinkedAction(EnumLinkedAction.MODULE_INSERTED, stack, (TileEntityLinkable)te);
            }
        }
    }

    default public int getSlotLimit(int slot) {
        return 1;
    }

    default public boolean isItemValid(int slot, ItemStack stack) {
        return this.getModuleInSlot(slot = this.fixSlotId(slot)).func_190926_b() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemModule && this.getAcceptedModules().contains((Object)((ItemModule)stack.func_77973_b()).getModuleType()) && !this.hasModule(((ItemModule)stack.func_77973_b()).getModuleType());
    }

    default public ArrayList<EnumModuleType> getAcceptedModules() {
        ArrayList<EnumModuleType> list = new ArrayList<EnumModuleType>();
        for (EnumModuleType module : this.acceptedModules()) {
            list.add(module);
        }
        return list;
    }

    default public ArrayList<EnumModuleType> getInsertedModules() {
        ArrayList<EnumModuleType> modules = new ArrayList<EnumModuleType>();
        for (ItemStack stack : this.getInventory()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemModule)) continue;
            modules.add(((ItemModule)stack.func_77973_b()).getModuleType());
        }
        return modules;
    }

    default public ItemStack getModule(EnumModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b() || !(((ItemStack)modules.get(i)).func_77973_b() instanceof ItemModule) || ((ItemModule)((ItemStack)modules.get(i)).func_77973_b()).getModuleType() != module) continue;
            return (ItemStack)modules.get(i);
        }
        return ItemStack.field_190927_a;
    }

    default public void insertModule(ItemStack module) {
        int i;
        if (module.func_190926_b() || !(module.func_77973_b() instanceof ItemModule)) {
            return;
        }
        NonNullList<ItemStack> modules = this.getInventory();
        for (i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b() || ((ItemStack)modules.get(i)).func_77973_b() != module.func_77973_b()) continue;
            return;
        }
        for (i = 0; i < modules.size(); ++i) {
            if (!((ItemStack)modules.get(i)).func_190926_b()) continue;
            ItemStack toInsert = module.func_77946_l();
            modules.set(i, (Object)toInsert);
            this.onModuleInserted(toInsert, ((ItemModule)module.func_77973_b()).getModuleType());
            break;
        }
    }

    default public void removeModule(EnumModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b() || !(((ItemStack)modules.get(i)).func_77973_b() instanceof ItemModule) || ((ItemModule)((ItemStack)modules.get(i)).func_77973_b()).getModuleType() != module) continue;
            ItemStack removed = ((ItemStack)modules.get(i)).func_77946_l();
            modules.set(i, (Object)ItemStack.field_190927_a);
            this.onModuleRemoved(removed, module);
        }
    }

    default public boolean hasModule(EnumModuleType module) {
        NonNullList<ItemStack> modules = this.getInventory();
        if (module == null) {
            for (int i = 0; i < modules.size(); ++i) {
                if (!((ItemStack)modules.get(i)).func_190926_b()) continue;
                return true;
            }
        } else {
            for (int i = 0; i < modules.size(); ++i) {
                if (((ItemStack)modules.get(i)).func_190926_b() || !(((ItemStack)modules.get(i)).func_77973_b() instanceof ItemModule) || ((ItemModule)((ItemStack)modules.get(i)).func_77973_b()).getModuleType() != module) continue;
                return true;
            }
        }
        return false;
    }

    default public NonNullList<ItemStack> readModuleInventory(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c("Modules", 10);
        NonNullList modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            byte slot = stackTag.func_74771_c("ModuleSlot");
            if (slot < 0 || slot >= modules.size()) continue;
            modules.set((int)slot, (Object)new ItemStack(stackTag));
        }
        return modules;
    }

    default public NBTTagCompound writeModuleInventory(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        NonNullList<ItemStack> modules = this.getInventory();
        for (int i = 0; i < modules.size(); ++i) {
            if (((ItemStack)modules.get(i)).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("ModuleSlot", (byte)i);
            ((ItemStack)modules.get(i)).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a("Modules", (NBTBase)list);
        return tag;
    }
}

