/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;

public abstract class TileEntityLinkable
extends CustomizableSCTE
implements ITickable {
    public ArrayList<LinkedBlock> linkedBlocks = new ArrayList();
    private NBTTagList nbtTagStorage = null;

    public void func_73660_a() {
        if (this.func_145830_o() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            this.sync();
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("linkedBlocks")) {
            if (!this.func_145830_o()) {
                this.nbtTagStorage = tag.func_150295_c("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.func_150295_c("linkedBlocks", 10));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.func_145830_o() && this.linkedBlocks.size() > 0) {
            NBTTagList tagList = new NBTTagList();
            WorldUtils.addScheduledTask(this.field_145850_b, () -> {
                for (int i = this.linkedBlocks.size() - 1; i >= 0; --i) {
                    LinkedBlock block = this.linkedBlocks.get(i);
                    NBTTagCompound toAppend = new NBTTagCompound();
                    if (block != null) {
                        if (!block.validate(this.field_145850_b)) {
                            this.linkedBlocks.remove(i);
                            continue;
                        }
                        toAppend.func_74778_a("blockName", block.blockName);
                        toAppend.func_74768_a("blockX", block.getX());
                        toAppend.func_74768_a("blockY", block.getY());
                        toAppend.func_74768_a("blockZ", block.getZ());
                    }
                    tagList.func_74742_a((NBTBase)toAppend);
                }
                tag.func_74782_a("linkedBlocks", (NBTBase)tagList);
            });
        }
        return tag;
    }

    private void readLinkedBlocks(NBTTagList list) {
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String name = list.func_150305_b(i).func_74779_i("blockName");
            int x = list.func_150305_b(i).func_74762_e("blockX");
            int y = list.func_150305_b(i).func_74762_e("blockY");
            int z = list.func_150305_b(i).func_74762_e("blockZ");
            LinkedBlock block = new LinkedBlock(name, new BlockPos(x, y, z));
            if (this.func_145830_o() && !block.validate(this.field_145850_b)) {
                list.func_74744_a(i);
                continue;
            }
            if (this.linkedBlocks.contains(block)) continue;
            TileEntityLinkable.link(this, block.asTileEntity(this.field_145850_b));
        }
    }

    public void func_145843_s() {
        for (LinkedBlock block : this.linkedBlocks) {
            TileEntityLinkable.unlink(block.asTileEntity(this.field_145850_b), this);
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module) {
        super.onModuleInserted(stack, module);
        ModuleUtils.createLinkedAction(EnumLinkedAction.MODULE_INSERTED, stack, this);
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module) {
        super.onModuleRemoved(stack, module);
        ModuleUtils.createLinkedAction(EnumLinkedAction.MODULE_REMOVED, stack, this);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        this.createLinkedBlockAction(EnumLinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, this);
    }

    public static void link(TileEntityLinkable tileEntity1, TileEntityLinkable tileEntity2) {
        if (TileEntityLinkable.isLinkedWith(tileEntity1, tileEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(tileEntity1);
        LinkedBlock block2 = new LinkedBlock(tileEntity2);
        if (!tileEntity1.linkedBlocks.contains(block2)) {
            tileEntity1.linkedBlocks.add(block2);
        }
        if (!tileEntity2.linkedBlocks.contains(block1)) {
            tileEntity2.linkedBlocks.add(block1);
        }
    }

    public static void unlink(TileEntityLinkable tileEntity1, TileEntityLinkable tileEntity2) {
        if (tileEntity1 == null || tileEntity2 == null) {
            return;
        }
        LinkedBlock block = new LinkedBlock(tileEntity2);
        if (tileEntity1.linkedBlocks.contains(block)) {
            tileEntity1.linkedBlocks.remove(block);
        }
    }

    public static boolean isLinkedWith(TileEntityLinkable tileEntity1, TileEntityLinkable tileEntity2) {
        return tileEntity1.linkedBlocks.contains(new LinkedBlock(tileEntity2)) && tileEntity2.linkedBlocks.contains(new LinkedBlock(tileEntity1));
    }

    public void createLinkedBlockAction(EnumLinkedAction action, Object[] parameters, TileEntityLinkable excludedTE) {
        ArrayList<TileEntityLinkable> list = new ArrayList<TileEntityLinkable>();
        list.add(excludedTE);
        this.createLinkedBlockAction(action, parameters, list);
    }

    public void createLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<TileEntityLinkable> excludedTEs) {
        for (LinkedBlock block : this.linkedBlocks) {
            if (excludedTEs.contains(block.asTileEntity(this.field_145850_b))) continue;
            block.asTileEntity(this.field_145850_b).onLinkedBlockAction(action, parameters, excludedTEs);
            block.asTileEntity(this.field_145850_b).sync();
        }
    }

    protected void onLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<TileEntityLinkable> excludedTEs) {
    }
}

